/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.ex;

import com.intellij.analysis.AnalysisScope;
import com.intellij.analysis.AnalysisUIOptions;
import com.intellij.analysis.PerformAnalysisInBackgroundOption;
import com.intellij.codeInsight.FileModificationService;
import com.intellij.codeInsight.daemon.ProblemHighlightFilter;
import com.intellij.codeInsight.daemon.impl.DaemonProgressIndicator;
import com.intellij.codeInsight.daemon.impl.HighlightInfoProcessor;
import com.intellij.codeInsight.daemon.impl.LocalInspectionsPass;
import com.intellij.codeInspection.CommonProblemDescriptor;
import com.intellij.codeInspection.GlobalInspectionContext;
import com.intellij.codeInspection.GlobalInspectionTool;
import com.intellij.codeInspection.GlobalSimpleInspectionTool;
import com.intellij.codeInspection.InspectionEP;
import com.intellij.codeInspection.InspectionManager;
import com.intellij.codeInspection.InspectionProfile;
import com.intellij.codeInspection.InspectionProfileEntry;
import com.intellij.codeInspection.InspectionToolResultExporter;
import com.intellij.codeInspection.InspectionsBundle;
import com.intellij.codeInspection.LocalInspectionTool;
import com.intellij.codeInspection.ProblemDescriptionsProcessor;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemDescriptorBase;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.codeInspection.SuppressionUtil;
import com.intellij.codeInspection.actions.CleanupInspectionUtil;
import com.intellij.codeInspection.ex.BatchModeDescriptorsUtil;
import com.intellij.codeInspection.ex.ExternalAnnotatorBatchInspection;
import com.intellij.codeInspection.ex.GlobalInspectionContextEx;
import com.intellij.codeInspection.ex.GlobalInspectionContextUtil;
import com.intellij.codeInspection.ex.GlobalInspectionToolWrapper;
import com.intellij.codeInspection.ex.InspectionManagerEx;
import com.intellij.codeInspection.ex.InspectionProfileImpl;
import com.intellij.codeInspection.ex.InspectionProfileWrapper;
import com.intellij.codeInspection.ex.InspectionRVContentProviderImpl;
import com.intellij.codeInspection.ex.InspectionToolWrapper;
import com.intellij.codeInspection.ex.LocalInspectionToolWrapper;
import com.intellij.codeInspection.ex.PairedUnfairLocalInspectionTool;
import com.intellij.codeInspection.ex.ScopeToolState;
import com.intellij.codeInspection.ex.Tools;
import com.intellij.codeInspection.ex.ToolsImpl;
import com.intellij.codeInspection.lang.GlobalInspectionContextExtension;
import com.intellij.codeInspection.reference.RefElement;
import com.intellij.codeInspection.reference.RefEntity;
import com.intellij.codeInspection.reference.RefGraphAnnotator;
import com.intellij.codeInspection.reference.RefManagerImpl;
import com.intellij.codeInspection.ui.DefaultInspectionToolPresentation;
import com.intellij.codeInspection.ui.InspectionResultsView;
import com.intellij.codeInspection.ui.InspectionToolPresentation;
import com.intellij.concurrency.JobLauncher;
import com.intellij.concurrency.JobLauncherImpl;
import com.intellij.concurrency.SensitiveProgressWrapper;
import com.intellij.diagnostic.ThreadDumper;
import com.intellij.lang.LangBundle;
import com.intellij.lang.annotation.ProblemGroup;
import com.intellij.lang.injection.InjectedLanguageManager;
import com.intellij.notification.NotificationGroup;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.ToggleAction;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.application.TransactionGuard;
import com.intellij.openapi.application.ex.ApplicationManagerEx;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.extensions.ExtensionPointListener;
import com.intellij.openapi.extensions.PluginDescriptor;
import com.intellij.openapi.progress.PerformInBackgroundOption;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressIndicatorProvider;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.progress.impl.CoreProgressManager;
import com.intellij.openapi.progress.util.ProgressIndicatorUtils;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.IndexNotReadyException;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectUtil;
import com.intellij.openapi.project.ProjectUtilCore;
import com.intellij.openapi.roots.FileIndex;
import com.intellij.openapi.roots.ProjectFileIndex;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.ui.MessageType;
import com.intellij.openapi.util.ActionCallback;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.EmptyRunnable;
import com.intellij.openapi.util.NotNullLazyValue;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.wm.ToolWindowManager;
import com.intellij.psi.PsiBinaryFile;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiNamedElement;
import com.intellij.psi.SingleRootFileViewProvider;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.GlobalSearchScopesCore;
import com.intellij.psi.search.LocalSearchScope;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.search.scope.packageSet.NamedScope;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.testFramework.LightVirtualFile;
import com.intellij.ui.GuiUtils;
import com.intellij.ui.content.Content;
import com.intellij.ui.content.ContentFactory;
import com.intellij.ui.content.ContentManager;
import com.intellij.util.ExceptionUtil;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.Processor;
import com.intellij.util.SystemProperties;
import com.intellij.util.ThrowableRunnable;
import com.intellij.util.TripleFunction;
import com.intellij.util.containers.ContainerUtil;
import gnu.trove.THashSet;
import java.lang.reflect.Constructor;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.TreeSet;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.Future;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.TimeUnit;
import java.util.function.Predicate;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class GlobalInspectionContextImpl
extends GlobalInspectionContextEx {
    private static final boolean INSPECT_INJECTED_PSI = SystemProperties.getBooleanProperty((String)"idea.batch.inspections.inspect.injected.psi", (boolean)true);
    private static final Logger LOG = Logger.getInstance(GlobalInspectionContextImpl.class);
    public static volatile boolean TESTING_VIEW;
    public static final NotificationGroup NOTIFICATION_GROUP;
    private final NotNullLazyValue<? extends ContentManager> myContentManager;
    private volatile InspectionResultsView myView;
    private Content myContent;
    private volatile boolean myViewClosed = true;
    private long myInspectionStartedTimestamp;
    private final ConcurrentMap<InspectionToolWrapper<?, ?>, InspectionToolPresentation> myPresentationMap = new ConcurrentHashMap();
    private static final String EXPLODED_AAR = "exploded-aar";
    private final List<ProgressIndicator> dependentIndicators = ContainerUtil.createLockFreeCopyOnWriteList();
    private static final VirtualFile TOMBSTONE;
    private static final TripleFunction<LocalInspectionTool, PsiElement, GlobalInspectionContext, RefElement> CONVERT;

    public GlobalInspectionContextImpl(@NotNull Project project, @NotNull NotNullLazyValue<? extends ContentManager> contentManager2) {
        super(project);
        this.myContentManager = contentManager2;
    }

    @NotNull
    private ContentManager getContentManager() {
        return (ContentManager)this.myContentManager.getValue();
    }

    public void addView(@NotNull InspectionResultsView view, @NotNull String title, boolean isOffline) {
        LOG.assertTrue(this.myContent == null, (Object)"GlobalInspectionContext is busy under other view now");
        this.myView = view;
        if (!isOffline) {
            this.myView.setUpdating(true);
        }
        this.myContent = ContentFactory.SERVICE.getInstance().createContent((JComponent)view, title, false);
        this.myContent.setHelpId("reference.toolWindows.inspections");
        this.myContent.setDisposer((Disposable)this.myView);
        Disposer.register((Disposable)this.myContent, () -> {
            if (this.myView != null) {
                this.close(false);
            }
            this.myContent = null;
        });
        RefManagerImpl.EP_NAME.addExtensionPointListener((ExtensionPointListener)new ExtensionPointListener<RefGraphAnnotator>(){

            public void extensionRemoved(@NotNull RefGraphAnnotator graphAnnotator, @NotNull PluginDescriptor pluginDescriptor) {
                ((RefManagerImpl)GlobalInspectionContextImpl.this.getRefManager()).unregisterAnnotator(graphAnnotator);
            }
        }, (Disposable)this.myContent);
        ContentManager contentManager2 = this.getContentManager();
        contentManager2.addContent(this.myContent);
        contentManager2.setSelectedContent(this.myContent);
        ToolWindowManager.getInstance((Project)this.getProject()).getToolWindow("Inspection Results").activate(null);
    }

    public void addView(@NotNull InspectionResultsView view) {
        this.addView(view, InspectionsBundle.message((String)(view.isSingleInspectionRun() ? "inspection.results.for.inspection.toolwindow.title" : "inspection.results.for.profile.toolwindow.title"), (Object[])new Object[]{view.getCurrentProfileName(), this.getCurrentScope().getShortenName()}), false);
    }

    @Override
    public void doInspections(@NotNull AnalysisScope scope) {
        if (this.myContent != null) {
            this.getContentManager().removeContent(this.myContent, true);
        }
        super.doInspections(scope);
    }

    public void resolveElement(@NotNull InspectionProfileEntry tool, @NotNull PsiElement element2) {
        RefElement refElement = this.getRefManager().getReference(element2);
        if (refElement == null) {
            return;
        }
        Tools tools = this.getTools().get(tool.getShortName());
        if (tools != null) {
            for (ScopeToolState state : tools.getTools()) {
                InspectionToolWrapper toolWrapper = state.getTool();
                InspectionToolResultExporter presentation2 = this.getPresentationOrNull(toolWrapper);
                if (presentation2 == null) continue;
                GlobalInspectionContextImpl.resolveElementRecursively(presentation2, (RefEntity)refElement);
            }
        }
    }

    public InspectionResultsView getView() {
        return this.myView;
    }

    private static void resolveElementRecursively(@NotNull InspectionToolResultExporter presentation2, @NotNull RefEntity refElement) {
        presentation2.suppressProblem(refElement);
        List children2 = refElement.getChildren();
        for (RefEntity child2 : children2) {
            GlobalInspectionContextImpl.resolveElementRecursively(presentation2, child2);
        }
    }

    @NotNull
    public AnalysisUIOptions getUIOptions() {
        return AnalysisUIOptions.getInstance(this.getProject());
    }

    public void setSplitterProportion(float proportion) {
        this.getUIOptions().SPLITTER_PROPORTION = proportion;
    }

    @NotNull
    public ToggleAction createToggleAutoscrollAction() {
        return this.getUIOptions().getAutoScrollToSourceHandler().createToggleAction();
    }

    @Override
    protected void launchInspections(@NotNull AnalysisScope scope) {
        this.myViewClosed = false;
        super.launchInspections(scope);
    }

    @Override
    @NotNull
    protected PerformInBackgroundOption createOption() {
        return new PerformAnalysisInBackgroundOption(this.getProject());
    }

    @Override
    protected void notifyInspectionsFinished(@NotNull AnalysisScope scope) {
        if (ApplicationManager.getApplication().isUnitTestMode() && !TESTING_VIEW) {
            return;
        }
        LOG.assertTrue(ApplicationManager.getApplication().isDispatchThread());
        long elapsed = System.currentTimeMillis() - this.myInspectionStartedTimestamp;
        LOG.info("Code inspection finished. Took " + elapsed + "ms");
        if (this.getProject().isDisposed()) {
            return;
        }
        InspectionResultsView newView = this.myView == null ? new InspectionResultsView(this, new InspectionRVContentProviderImpl()) : null;
        if (!(this.myView == null ? newView : this.myView).hasProblems()) {
            int totalFiles = this.getStdJobDescriptors().BUILD_GRAPH.getTotalAmount();
            NOTIFICATION_GROUP.createNotification(InspectionsBundle.message((String)"inspection.no.problems.message", (Object[])new Object[]{totalFiles, scope.getShortenName()}), MessageType.INFO).notify(this.getProject());
            this.close(true);
            if (newView != null) {
                Disposer.dispose((Disposable)newView);
            }
        } else if (newView != null && !newView.isDisposed() && this.getCurrentScope() != null) {
            this.addView(newView);
            newView.update();
        }
        if (this.myView != null) {
            this.myView.setUpdating(false);
        }
    }

    private static boolean isIgnoredFile(@NotNull PsiFile psiFile) {
        for (VirtualFile file2 = psiFile.getVirtualFile(); file2 != null; file2 = file2.getParent()) {
            if (!EXPLODED_AAR.equals(file2.getName())) continue;
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void runTools(@NotNull AnalysisScope scope, boolean runGlobalToolsOnly, boolean isOfflineInspections) {
        this.myInspectionStartedTimestamp = System.currentTimeMillis();
        ProgressIndicator progressIndicator2 = ProgressIndicatorProvider.getGlobalProgressIndicator();
        if (progressIndicator2 == null) {
            throw new IncorrectOperationException("Must be run under progress");
        }
        if (!isOfflineInspections && ApplicationManager.getApplication().isDispatchThread()) {
            throw new IncorrectOperationException("Must not start inspections from within EDT");
        }
        if (ApplicationManager.getApplication().isWriteAccessAllowed()) {
            throw new IncorrectOperationException("Must not start inspections from within write action");
        }
        if (!isOfflineInspections && ApplicationManager.getApplication().isReadAccessAllowed()) {
            throw new IncorrectOperationException("Must not start inspections from within global read action");
        }
        InspectionManager inspectionManager = InspectionManager.getInstance((Project)this.getProject());
        ((RefManagerImpl)this.getRefManager()).initializeAnnotators();
        ArrayList<Tools> globalTools = new ArrayList<Tools>();
        ArrayList<Tools> localTools = new ArrayList<Tools>();
        ArrayList globalSimpleTools = new ArrayList();
        this.initializeTools(globalTools, localTools, globalSimpleTools);
        this.appendPairedInspectionsForUnfairTools(globalTools, globalSimpleTools, localTools);
        this.runGlobalTools(scope, inspectionManager, globalTools, isOfflineInspections);
        if (runGlobalToolsOnly || localTools.isEmpty() && globalSimpleTools.isEmpty()) {
            return;
        }
        SearchScope searchScope = (SearchScope)ReadAction.compute(() -> ((AnalysisScope)scope).toSearchScope());
        THashSet localScopeFiles = searchScope instanceof LocalSearchScope ? new THashSet() : null;
        for (Tools tools : globalSimpleTools) {
            GlobalInspectionToolWrapper toolWrapper = (GlobalInspectionToolWrapper)tools.getTool();
            GlobalSimpleInspectionTool tool = (GlobalSimpleInspectionTool)toolWrapper.getTool();
            tool.inspectionStarted(inspectionManager, (GlobalInspectionContext)this, (ProblemDescriptionsProcessor)this.getPresentation(toolWrapper));
        }
        boolean headlessEnvironment = ApplicationManager.getApplication().isHeadlessEnvironment();
        Map<String, InspectionToolWrapper<?, ?>> map2 = GlobalInspectionContextImpl.getInspectionWrappersMap(localTools);
        ArrayBlockingQueue filesToInspect = new ArrayBlockingQueue(1000);
        SensitiveProgressWrapper iteratingIndicator = new SensitiveProgressWrapper(progressIndicator2);
        Future<?> future2 = this.startIterateScopeInBackground(scope, (Collection<? super VirtualFile>)localScopeFiles, headlessEnvironment, filesToInspect, iteratingIndicator);
        PsiManager psiManager = PsiManager.getInstance((Project)this.getProject());
        Processor processor2 = virtualFile -> {
            ProgressManager.checkCanceled();
            Boolean readActionSuccess = (Boolean)DumbService.getInstance((Project)this.getProject()).tryRunReadActionInSmartMode(() -> {
                long start2 = this.myProfile == null ? 0L : System.currentTimeMillis();
                PsiFile file2 = psiManager.findFile(virtualFile);
                if (file2 == null) {
                    return true;
                }
                if (!scope.contains(virtualFile)) {
                    LOG.info(file2.getName() + "; scope: " + scope + "; " + virtualFile);
                    return true;
                }
                boolean includeDoNotShow = this.includeDoNotShow(this.getCurrentProfile());
                this.inspectFile(file2, GlobalInspectionContextImpl.getEffectiveRange(searchScope, file2), inspectionManager, map2, GlobalInspectionContextImpl.getWrappersFromTools(globalSimpleTools, file2, includeDoNotShow, wrapper2 -> !(wrapper2.getTool() instanceof ExternalAnnotatorBatchInspection)), GlobalInspectionContextImpl.getWrappersFromTools(localTools, file2, includeDoNotShow, wrapper2 -> !(wrapper2.getTool() instanceof ExternalAnnotatorBatchInspection)));
                if (start2 != 0L) {
                    this.updateProfile((VirtualFile)virtualFile, System.currentTimeMillis() - start2);
                }
                return true;
            }, "Inspect code is not available until indices are ready");
            if (readActionSuccess == null || !readActionSuccess.booleanValue()) {
                throw new ProcessCanceledException();
            }
            PsiFile file2 = (PsiFile)ReadAction.compute(() -> psiManager.findFile(virtualFile));
            if (file2 == null) {
                return true;
            }
            boolean includeDoNotShow = this.includeDoNotShow(this.getCurrentProfile());
            List externalAnnotatable = ContainerUtil.concat(GlobalInspectionContextImpl.getWrappersFromTools(localTools, file2, includeDoNotShow, wrapper2 -> wrapper2.getTool() instanceof ExternalAnnotatorBatchInspection), GlobalInspectionContextImpl.getWrappersFromTools(globalSimpleTools, file2, includeDoNotShow, wrapper2 -> wrapper2.getTool() instanceof ExternalAnnotatorBatchInspection));
            externalAnnotatable.forEach(wrapper2 -> {
                ProblemDescriptor[] descriptors = ((ExternalAnnotatorBatchInspection)wrapper2.getTool()).checkFile(file2, this, inspectionManager);
                InspectionToolPresentation toolPresentation = this.getPresentation((InspectionToolWrapper)wrapper2);
                ReadAction.run(() -> BatchModeDescriptorsUtil.addProblemDescriptors(Arrays.asList(descriptors), false, this, null, CONVERT, toolPresentation));
            });
            return true;
        };
        try {
            LinkedBlockingQueue filesFailedToInspect = new LinkedBlockingQueue();
            while (true) {
                Disposable disposable2 = Disposer.newDisposable();
                DaemonProgressIndicator wrapper2 = new DaemonProgressIndicator();
                this.dependentIndicators.add(wrapper2);
                try {
                    ReadAction.run(() -> {
                        wrapper2.start();
                        ProgressIndicatorUtils.forceWriteActionPriority(wrapper2, disposable2);
                        if (ApplicationManagerEx.getApplicationEx().isWriteActionPending()) {
                            throw new ProcessCanceledException();
                        }
                    });
                    ((JobLauncherImpl)JobLauncher.getInstance()).processQueue(filesToInspect, filesFailedToInspect, wrapper2, TOMBSTONE, processor2);
                }
                catch (ProcessCanceledException e) {
                    progressIndicator2.checkCanceled();
                    assert (isOfflineInspections || !ApplicationManager.getApplication().isReadAccessAllowed()) : "Must be outside read action. PCE=\n" + ExceptionUtil.getThrowableText((Throwable)e);
                    assert (isOfflineInspections || !ApplicationManager.getApplication().isDispatchThread()) : "Must be outside EDT. PCE=\n" + ExceptionUtil.getThrowableText((Throwable)e);
                    ApplicationManager.getApplication().runReadAction(EmptyRunnable.getInstance());
                    continue;
                }
                finally {
                    this.dependentIndicators.remove((Object)wrapper2);
                    Disposer.dispose((Disposable)disposable2);
                    continue;
                }
                break;
            }
        }
        finally {
            iteratingIndicator.cancel();
            filesToInspect.clear();
            try {
                future2.get(30L, TimeUnit.SECONDS);
            }
            catch (Exception e) {
                LOG.error("Thread dump: \n" + ThreadDumper.dumpThreadsToString(), (Throwable)e);
            }
        }
        ProgressManager.checkCanceled();
        for (Tools tools : globalSimpleTools) {
            GlobalInspectionToolWrapper toolWrapper = (GlobalInspectionToolWrapper)tools.getTool();
            GlobalSimpleInspectionTool tool = (GlobalSimpleInspectionTool)toolWrapper.getTool();
            ProblemDescriptionsProcessor problemDescriptionProcessor = this.getProblemDescriptionProcessor(toolWrapper, map2);
            tool.inspectionFinished(inspectionManager, (GlobalInspectionContext)this, problemDescriptionProcessor);
        }
        this.addProblemsToView(globalSimpleTools);
    }

    private static TextRange getEffectiveRange(SearchScope searchScope, PsiFile file2) {
        List scopeFileElements;
        if (searchScope instanceof LocalSearchScope && !(scopeFileElements = ContainerUtil.filter((Object[])((LocalSearchScope)searchScope).getScope(), e -> e.getContainingFile() == file2)).isEmpty()) {
            int start2 = -1;
            int end = -1;
            for (PsiElement scopeElement : scopeFileElements) {
                TextRange elementRange = scopeElement.getTextRange();
                start2 = start2 == -1 ? elementRange.getStartOffset() : Math.min(elementRange.getStartOffset(), start2);
                end = end == -1 ? elementRange.getEndOffset() : Math.max(elementRange.getEndOffset(), end);
            }
            return new TextRange(start2, end);
        }
        return new TextRange(0, file2.getTextLength());
    }

    @Override
    protected void canceled() {
        super.canceled();
        this.dependentIndicators.forEach(ProgressIndicator::cancel);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void inspectFile(@NotNull PsiFile file2, @NotNull TextRange range2, @NotNull InspectionManager inspectionManager, @NotNull Map<String, InspectionToolWrapper<?, ?>> wrappersMap, @NotNull List<? extends GlobalInspectionToolWrapper> globalSimpleTools, @NotNull List<? extends LocalInspectionToolWrapper> localTools) {
        if (GlobalInspectionContextImpl.isIgnoredFile(file2)) {
            return;
        }
        Document document = PsiDocumentManager.getInstance((Project)this.getProject()).getDocument(file2);
        if (document == null) {
            return;
        }
        try {
            file2.putUserData(InspectionProfileWrapper.CUSTOMIZATION_KEY, p -> new InspectionProfileWrapper(this.getCurrentProfile()));
            LocalInspectionsPass pass = new LocalInspectionsPass(file2, document, range2.getStartOffset(), range2.getEndOffset(), LocalInspectionsPass.EMPTY_PRIORITY_RANGE, true, HighlightInfoProcessor.getEmpty(), INSPECT_INJECTED_PSI);
            pass.doInspectInBatch(this, inspectionManager, localTools);
            GlobalInspectionContextImpl.assertUnderDaemonProgress();
            JobLauncher.getInstance().invokeConcurrentlyUnderProgress(globalSimpleTools, ProgressIndicatorProvider.getGlobalProgressIndicator(), toolWrapper -> {
                GlobalSimpleInspectionTool tool = (GlobalSimpleInspectionTool)toolWrapper.getTool();
                ProblemsHolder holder = new ProblemsHolder(inspectionManager, file2, false);
                ProblemDescriptionsProcessor problemDescriptionProcessor = this.getProblemDescriptionProcessor((GlobalInspectionToolWrapper)((Object)toolWrapper), wrappersMap);
                tool.checkFile(file2, inspectionManager, holder, (GlobalInspectionContext)this, problemDescriptionProcessor);
                InspectionToolPresentation toolPresentation = this.getPresentation((InspectionToolWrapper)toolWrapper);
                BatchModeDescriptorsUtil.addProblemDescriptors(holder.getResults(), false, this, null, CONVERT, toolPresentation);
                return true;
            });
            VirtualFile virtualFile = file2.getVirtualFile();
            String displayUrl = ProjectUtilCore.displayUrlRelativeToProject((VirtualFile)virtualFile, (String)virtualFile.getPresentableUrl(), (Project)this.getProject(), (boolean)true, (boolean)false);
            this.incrementJobDoneAmount(this.getStdJobDescriptors().LOCAL_ANALYSIS, displayUrl);
        }
        catch (ProcessCanceledException | IndexNotReadyException e) {
            throw e;
        }
        catch (Throwable e) {
            LOG.error("In file: " + file2.getViewProvider().getVirtualFile().getPath(), e);
        }
        finally {
            file2.putUserData(InspectionProfileWrapper.CUSTOMIZATION_KEY, null);
            InjectedLanguageManager.getInstance((Project)this.getProject()).dropFileCaches(file2);
        }
    }

    protected boolean includeDoNotShow(InspectionProfile profile) {
        return profile.getSingleTool() != null;
    }

    @NotNull
    private Future<?> startIterateScopeInBackground(final @NotNull AnalysisScope scope, final @Nullable Collection<? super VirtualFile> localScopeFiles, final boolean headlessEnvironment, final @NotNull BlockingQueue<? super VirtualFile> outFilesToInspect, @NotNull ProgressIndicator progressIndicator2) {
        Task.Backgroundable task2 = new Task.Backgroundable(this.getProject(), InspectionsBundle.message((String)"scanning.files.to.inspect.progress.text", (Object[])new Object[0])){

            public void run(@NotNull ProgressIndicator indicator) {
                try {
                    ProjectFileIndex fileIndex = ProjectRootManager.getInstance((Project)this.getProject()).getFileIndex();
                    scope.accept(arg_0 -> this.lambda$run$1((FileIndex)fileIndex, headlessEnvironment, localScopeFiles, outFilesToInspect, arg_0));
                }
                catch (ProcessCanceledException e) {
                }
                finally {
                    try {
                        outFilesToInspect.put(TOMBSTONE);
                    }
                    catch (InterruptedException e) {
                        LOG.error((Throwable)e);
                    }
                }
            }

            private /* synthetic */ boolean lambda$run$1(FileIndex fileIndex, boolean headlessEnvironment2, Collection localScopeFiles2, BlockingQueue outFilesToInspect2, VirtualFile file2) {
                ProgressManager.checkCanceled();
                if (ProjectUtil.isProjectOrWorkspaceFile((VirtualFile)file2) || !fileIndex.isInContent(file2)) {
                    return true;
                }
                PsiFile psiFile = (PsiFile)ReadAction.compute(() -> {
                    Document document;
                    if (this.getProject().isDisposed()) {
                        throw new ProcessCanceledException();
                    }
                    PsiFile psi = PsiManager.getInstance((Project)this.getProject()).findFile(file2);
                    Document document2 = document = psi == null ? null : GlobalInspectionContextImpl.this.shouldProcess(psi, headlessEnvironment2, localScopeFiles2);
                    if (document != null) {
                        return psi;
                    }
                    return null;
                });
                if (psiFile != null) {
                    try {
                        if (ApplicationManager.getApplication().isReadAccessAllowed()) {
                            throw new IllegalStateException("Must not have read action");
                        }
                        outFilesToInspect2.put(file2);
                    }
                    catch (InterruptedException e) {
                        LOG.error((Throwable)e);
                    }
                }
                ProgressManager.checkCanceled();
                return true;
            }
        };
        return ((CoreProgressManager)ProgressManager.getInstance()).runProcessWithProgressAsynchronously(task2, progressIndicator2, null);
    }

    private Document shouldProcess(@NotNull PsiFile file2, boolean headlessEnvironment, @Nullable Collection<? super VirtualFile> localScopeFiles) {
        VirtualFile virtualFile = file2.getVirtualFile();
        if (virtualFile == null) {
            return null;
        }
        if (GlobalInspectionContextImpl.isBinary(file2)) {
            return null;
        }
        if (this.myViewClosed && !headlessEnvironment) {
            throw new ProcessCanceledException();
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("Running local inspections on " + virtualFile.getPath());
        }
        if (SingleRootFileViewProvider.isTooLargeForIntelligence(virtualFile)) {
            return null;
        }
        if (localScopeFiles != null && !localScopeFiles.add((VirtualFile)virtualFile)) {
            return null;
        }
        if (!ProblemHighlightFilter.shouldProcessFileInBatch((PsiFile)file2)) {
            return null;
        }
        return PsiDocumentManager.getInstance((Project)this.getProject()).getDocument(file2);
    }

    private void runGlobalTools(@NotNull AnalysisScope scope, @NotNull InspectionManager inspectionManager, @NotNull List<? extends Tools> globalTools, boolean isOfflineInspections) {
        LOG.assertTrue(!ApplicationManager.getApplication().isReadAccessAllowed() || isOfflineInspections, (Object)"Must not run under read action, too unresponsive");
        ArrayList needRepeatSearchRequest = new ArrayList();
        SearchScope initialSearchScope = (SearchScope)ReadAction.compute(() -> ((AnalysisScope)scope).toSearchScope());
        boolean canBeExternalUsages = scope.getScopeType() != 1 || !scope.isIncludeTestSource();
        for (Tools tools : globalTools) {
            for (ScopeToolState state : tools.getTools()) {
                NamedScope stateScope;
                if (!state.isEnabled() || (stateScope = state.getScope(this.getProject())) == null) continue;
                AnalysisScope scopeForState = new AnalysisScope(GlobalSearchScopesCore.filterScope((Project)this.getProject(), (NamedScope)stateScope).intersectWith(initialSearchScope), this.getProject());
                InspectionToolWrapper toolWrapper = state.getTool();
                GlobalInspectionTool tool = (GlobalInspectionTool)toolWrapper.getTool();
                InspectionToolPresentation toolPresentation = this.getPresentation(toolWrapper);
                try {
                    if (tool.isGraphNeeded()) {
                        try {
                            ((RefManagerImpl)this.getRefManager()).findAllDeclarations();
                        }
                        catch (Throwable e) {
                            this.getStdJobDescriptors().BUILD_GRAPH.setDoneAmount(0);
                            throw e;
                        }
                    }
                    ThrowableRunnable runnable2 = () -> {
                        tool.runInspection(scopeForState, inspectionManager, (GlobalInspectionContext)this, (ProblemDescriptionsProcessor)toolPresentation);
                        if ((canBeExternalUsages || tool.getAdditionalJobs((GlobalInspectionContext)this) != null) && tool.queryExternalUsagesRequests(inspectionManager, (GlobalInspectionContext)this, (ProblemDescriptionsProcessor)toolPresentation)) {
                            needRepeatSearchRequest.add(toolWrapper);
                        }
                    };
                    if (tool.isReadActionNeeded()) {
                        ReadAction.run((ThrowableRunnable)runnable2);
                        continue;
                    }
                    runnable2.run();
                }
                catch (ProcessCanceledException | IndexNotReadyException e) {
                    throw e;
                }
                catch (Throwable e) {
                    LOG.error(e);
                }
            }
        }
        for (GlobalInspectionContextExtension globalInspectionContextExtension : this.myExtensions.values()) {
            try {
                globalInspectionContextExtension.performPostRunActivities(needRepeatSearchRequest, (GlobalInspectionContext)this);
            }
            catch (ProcessCanceledException | IndexNotReadyException e) {
                throw e;
            }
            catch (Throwable e) {
                LOG.error(e);
            }
        }
        this.addProblemsToView(globalTools);
    }

    public ActionCallback initializeViewIfNeeded() {
        if (this.myView != null) {
            return ActionCallback.DONE;
        }
        return ApplicationManager.getApplication().getInvokator().invokeLater(() -> {
            if (this.getCurrentScope() == null) {
                return;
            }
            InspectionResultsView view = this.getView();
            if (view == null) {
                view = new InspectionResultsView(this, new InspectionRVContentProviderImpl());
                this.addView(view);
            }
        }, x -> this.getCurrentScope() == null);
    }

    private void appendPairedInspectionsForUnfairTools(@NotNull List<? super Tools> globalTools, @NotNull List<? super Tools> globalSimpleTools, @NotNull List<Tools> localTools) {
        Tools[] lArray;
        for (Tools tool : lArray = localTools.toArray(new Tools[0])) {
            InspectionToolWrapper batchInspection;
            LocalInspectionToolWrapper toolWrapper = (LocalInspectionToolWrapper)tool.getTool();
            LocalInspectionTool localTool = (LocalInspectionTool)toolWrapper.getTool();
            if (!(localTool instanceof PairedUnfairLocalInspectionTool)) continue;
            String batchShortName = ((PairedUnfairLocalInspectionTool)localTool).getInspectionForBatchShortName();
            InspectionProfileImpl currentProfile = this.getCurrentProfile();
            InspectionToolWrapper pairedWrapper = currentProfile.getInspectionTool(batchShortName, this.getProject());
            InspectionToolWrapper inspectionToolWrapper = batchInspection = pairedWrapper != null ? pairedWrapper.createCopy() : null;
            if (batchInspection == null || this.getTools().containsKey(batchShortName)) continue;
            InspectionProfileEntry batchTool = batchInspection.getTool();
            ScopeToolState defaultState = tool.getDefaultState();
            ToolsImpl newTool = new ToolsImpl(batchInspection, defaultState.getLevel(), true, defaultState.isEnabled());
            for (ScopeToolState state : tool.getTools()) {
                NamedScope scope = state.getScope(this.getProject());
                if (scope == null) continue;
                newTool.addTool(scope, batchInspection, state.isEnabled(), state.getLevel());
            }
            if (batchTool instanceof LocalInspectionTool) {
                localTools.add(newTool);
            } else if (batchTool instanceof GlobalSimpleInspectionTool) {
                globalSimpleTools.add(newTool);
            } else if (batchTool instanceof GlobalInspectionTool) {
                globalTools.add(newTool);
            } else {
                throw new AssertionError(batchTool);
            }
            this.myTools.put(batchShortName, newTool);
            batchInspection.initialize((GlobalInspectionContext)this);
        }
    }

    @NotNull
    private static <T extends InspectionToolWrapper<?, ?>> List<T> getWrappersFromTools(@NotNull List<? extends Tools> localTools, @NotNull PsiFile file2, boolean includeDoNotShow, @NotNull Predicate<? super T> filter2) {
        return ContainerUtil.mapNotNull(localTools, tool -> {
            InspectionToolWrapper unwrapped = tool.getEnabledTool((PsiElement)file2, includeDoNotShow);
            if (unwrapped == null) {
                return null;
            }
            return filter2.test(unwrapped) ? unwrapped : null;
        });
    }

    @NotNull
    private ProblemDescriptionsProcessor getProblemDescriptionProcessor(final @NotNull GlobalInspectionToolWrapper toolWrapper, final @NotNull Map<String, InspectionToolWrapper<?, ?>> wrappersMap) {
        return new ProblemDescriptionsProcessor(){

            public void addProblemElement(@Nullable RefEntity refEntity, CommonProblemDescriptor ... commonProblemDescriptors) {
                for (CommonProblemDescriptor problemDescriptor : commonProblemDescriptors) {
                    GlobalInspectionToolWrapper targetWrapper;
                    if (!(problemDescriptor instanceof ProblemDescriptor) || SuppressionUtil.inspectionResultSuppressed(((ProblemDescriptor)problemDescriptor).getPsiElement(), toolWrapper.getTool())) continue;
                    ProblemGroup problemGroup = ((ProblemDescriptor)problemDescriptor).getProblemGroup();
                    GlobalInspectionToolWrapper globalInspectionToolWrapper = targetWrapper = problemGroup == null ? toolWrapper : (InspectionToolWrapper)wrappersMap.get(problemGroup.getProblemName());
                    if (targetWrapper == null) continue;
                    InspectionToolPresentation toolPresentation = GlobalInspectionContextImpl.this.getPresentation(targetWrapper);
                    toolPresentation.addProblemElement(refEntity, new CommonProblemDescriptor[]{problemDescriptor});
                }
            }
        };
    }

    @NotNull
    private static Map<String, InspectionToolWrapper<?, ?>> getInspectionWrappersMap(@NotNull List<? extends Tools> tools) {
        HashMap name2Inspection = new HashMap(tools.size());
        for (Tools tools2 : tools) {
            InspectionToolWrapper toolWrapper = tools2.getTool();
            name2Inspection.put(toolWrapper.getShortName(), toolWrapper);
        }
        return name2Inspection;
    }

    @Override
    public void close(boolean noSuspiciousCodeFound) {
        if (!noSuspiciousCodeFound) {
            if (this.myView.isRerun()) {
                this.myViewClosed = true;
                this.myView = null;
            }
            if (this.myView == null) {
                return;
            }
        }
        if (this.myContent != null) {
            ContentManager contentManager2 = this.getContentManager();
            contentManager2.removeContent(this.myContent, true);
        }
        this.myViewClosed = true;
        this.myView = null;
        ((InspectionManagerEx)InspectionManager.getInstance((Project)this.getProject())).closeRunningContext(this);
        this.myPresentationMap.clear();
        super.close(noSuspiciousCodeFound);
    }

    @Override
    public void cleanup() {
        if (this.myView != null) {
            this.myView.setUpdating(false);
        } else {
            this.myPresentationMap.clear();
            super.cleanup();
        }
    }

    public void refreshViews() {
        if (this.myView != null) {
            this.myView.getTree().getInspectionTreeModel().reload();
        }
    }

    @Nullable
    private InspectionToolResultExporter getPresentationOrNull(@NotNull InspectionToolWrapper<?, ?> toolWrapper) {
        return (InspectionToolResultExporter)this.myPresentationMap.get(toolWrapper);
    }

    @Override
    public void codeCleanup(final @NotNull AnalysisScope scope, final @NotNull InspectionProfile profile, final @Nullable String commandName, final @Nullable Runnable postRunnable, boolean modal, final @NotNull Predicate<? super ProblemDescriptor> shouldApplyFix) {
        String title = LangBundle.message((String)"progress.title.inspect.code", (Object[])new Object[0]);
        Object task2 = modal ? new Task.Modal(this.getProject(), title, true){

            public void run(@NotNull ProgressIndicator indicator) {
                GlobalInspectionContextImpl.this.cleanup(scope, profile, postRunnable, commandName, indicator, shouldApplyFix);
            }
        } : new Task.Backgroundable(this.getProject(), title, true){

            public void run(@NotNull ProgressIndicator indicator) {
                GlobalInspectionContextImpl.this.cleanup(scope, profile, postRunnable, commandName, indicator, shouldApplyFix);
            }
        };
        ProgressManager.getInstance().run((Task)task2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void cleanup(@NotNull AnalysisScope scope, final @NotNull InspectionProfile profile, @Nullable Runnable postRunnable, @Nullable String commandName, final @NotNull ProgressIndicator progressIndicator2, final @NotNull Predicate<? super ProblemDescriptor> shouldApplyFix) {
        PsiElement[] elements2;
        this.setCurrentScope(scope);
        final int fileCount = scope.getFileCount();
        progressIndicator2.setIndeterminate(false);
        final SearchScope searchScope = (SearchScope)ReadAction.compute(() -> ((AnalysisScope)scope).toSearchScope());
        final TextRange range2 = searchScope instanceof LocalSearchScope ? ((elements2 = ((LocalSearchScope)searchScope).getScope()).length == 1 ? (TextRange)ReadAction.compute(() -> ((PsiElement)elements2[0]).getTextRange()) : null) : null;
        final List inspectionTools = ContainerUtil.filter((Collection)profile.getAllEnabledInspectionTools(this.getProject()), tools -> {
            assert (tools != null);
            return tools.getTool().isCleanupTool();
        });
        final boolean includeDoNotShow = this.includeDoNotShow(profile);
        RefManagerImpl refManager = (RefManagerImpl)this.getRefManager();
        refManager.inspectionReadActionStarted();
        final ArrayList descriptors = new ArrayList();
        final HashSet files2 = new HashSet();
        try {
            scope.accept(new PsiElementVisitor(){
                private int myCount;

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void visitFile(@NotNull PsiFile file2) {
                    progressIndicator2.setFraction((double)(++this.myCount) / (double)fileCount);
                    if (GlobalInspectionContextImpl.isBinary(file2)) {
                        return;
                    }
                    ArrayList<LocalInspectionToolWrapper> lTools = new ArrayList<LocalInspectionToolWrapper>();
                    for (Tools tools : inspectionTools) {
                        InspectionToolWrapper tool = tools.getEnabledTool((PsiElement)file2, includeDoNotShow);
                        if (tool instanceof GlobalInspectionToolWrapper) {
                            tool = ((GlobalInspectionToolWrapper)tool).getSharedLocalInspectionToolWrapper();
                        }
                        if (tool == null) continue;
                        lTools.add((LocalInspectionToolWrapper)tool);
                        tool.initialize((GlobalInspectionContext)GlobalInspectionContextImpl.this);
                    }
                    if (!lTools.isEmpty()) {
                        try {
                            file2.putUserData(InspectionProfileWrapper.CUSTOMIZATION_KEY, p -> new InspectionProfileWrapper(profile, p.getProfileManager()));
                            LocalInspectionsPass pass = new LocalInspectionsPass(file2, file2.getViewProvider().getDocument(), range2 != null ? range2.getStartOffset() : 0, range2 != null ? range2.getEndOffset() : file2.getTextLength(), LocalInspectionsPass.EMPTY_PRIORITY_RANGE, true, HighlightInfoProcessor.getEmpty(), true);
                            Runnable runnable2 = () -> pass.doInspectInBatch(GlobalInspectionContextImpl.this, InspectionManager.getInstance((Project)GlobalInspectionContextImpl.this.getProject()), lTools);
                            ApplicationManager.getApplication().runReadAction(runnable2);
                            TreeSet<ProblemDescriptor> localDescriptors = new TreeSet<ProblemDescriptor>(CommonProblemDescriptor.DESCRIPTOR_COMPARATOR);
                            for (LocalInspectionToolWrapper tool : lTools) {
                                InspectionToolPresentation toolPresentation = GlobalInspectionContextImpl.this.getPresentation(tool);
                                for (CommonProblemDescriptor descriptor2 : toolPresentation.getProblemDescriptors()) {
                                    if (!(descriptor2 instanceof ProblemDescriptor)) continue;
                                    localDescriptors.add((ProblemDescriptor)descriptor2);
                                }
                            }
                            if (searchScope instanceof LocalSearchScope) {
                                Iterator iterator2 = localDescriptors.iterator();
                                while (iterator2.hasNext()) {
                                    ProblemDescriptor descriptor3 = (ProblemDescriptor)iterator2.next();
                                    TextRange infoRange = descriptor3 instanceof ProblemDescriptorBase ? ((ProblemDescriptorBase)descriptor3).getTextRange() : null;
                                    if (infoRange == null || ((LocalSearchScope)searchScope).containsRange(file2, infoRange)) continue;
                                    iterator2.remove();
                                }
                            }
                            if (!localDescriptors.isEmpty()) {
                                for (ProblemDescriptor descriptor3 : localDescriptors) {
                                    if (!shouldApplyFix.test(descriptor3)) continue;
                                    descriptors.add(descriptor3);
                                }
                                files2.add(file2);
                            }
                        }
                        finally {
                            file2.putUserData(InspectionProfileWrapper.CUSTOMIZATION_KEY, null);
                            GlobalInspectionContextImpl.this.myPresentationMap.clear();
                        }
                    }
                }
            });
        }
        finally {
            refManager.inspectionReadActionFinished();
        }
        if (files2.isEmpty()) {
            GuiUtils.invokeLaterIfNeeded(() -> {
                if (commandName != null) {
                    NOTIFICATION_GROUP.createNotification(InspectionsBundle.message((String)"inspection.no.problems.message", (Object[])new Object[]{scope.getFileCount(), scope.getDisplayName()}), MessageType.INFO).notify(this.getProject());
                }
                if (postRunnable != null) {
                    postRunnable.run();
                }
            }, (ModalityState)ModalityState.defaultModalityState());
            return;
        }
        Runnable runnable2 = () -> {
            if (!FileModificationService.getInstance().preparePsiElementsForWrite((Collection)files2)) {
                return;
            }
            CleanupInspectionUtil.getInstance().applyFixesNoSort(this.getProject(), "Code Cleanup", descriptors, null, false, searchScope instanceof GlobalSearchScope);
            if (postRunnable != null) {
                postRunnable.run();
            }
        };
        TransactionGuard.submitTransaction((Disposable)this.getProject(), (Runnable)runnable2);
    }

    private static boolean isBinary(@NotNull PsiFile file2) {
        return file2 instanceof PsiBinaryFile || file2.getFileType().isBinary();
    }

    public boolean isViewClosed() {
        return this.myViewClosed;
    }

    private void addProblemsToView(List<? extends Tools> tools) {
        if (ApplicationManager.getApplication().isHeadlessEnvironment() && !TESTING_VIEW) {
            return;
        }
        if (this.myView == null && !((Boolean)ReadAction.compute(() -> InspectionResultsView.hasProblems(tools, this, new InspectionRVContentProviderImpl()))).booleanValue()) {
            return;
        }
        this.initializeViewIfNeeded().doWhenDone(() -> this.myView.addTools(tools));
    }

    @NotNull
    public InspectionToolPresentation getPresentation(@NotNull InspectionToolWrapper toolWrapper) {
        return this.myPresentationMap.computeIfAbsent(toolWrapper, __ -> {
            String presentationClass;
            String string = presentationClass = toolWrapper.myEP == null ? null : toolWrapper.myEP.presentation;
            if (StringUtil.isEmpty((String)presentationClass)) {
                presentationClass = DefaultInspectionToolPresentation.class.getName();
            }
            try {
                InspectionEP extension = toolWrapper.getExtension();
                ClassLoader classLoader = extension == null ? ((Object)((Object)this)).getClass().getClassLoader() : extension.getPluginDescriptor().getPluginClassLoader();
                Constructor<?> constructor = Class.forName(presentationClass, true, classLoader).getConstructor(InspectionToolWrapper.class, GlobalInspectionContextImpl.class);
                constructor.setAccessible(true);
                return (InspectionToolPresentation)constructor.newInstance(new Object[]{toolWrapper, this});
            }
            catch (Exception e) {
                LOG.error((Throwable)e);
                throw new RuntimeException(e);
            }
        });
    }

    static {
        NOTIFICATION_GROUP = NotificationGroup.toolWindowGroup((String)"Inspection Results", (String)"Inspection Results");
        TOMBSTONE = new LightVirtualFile("TOMBSTONE");
        CONVERT = (tool, elt, context) -> {
            PsiNamedElement problemElement = (PsiNamedElement)PsiTreeUtil.getNonStrictParentOfType((PsiElement)elt, (Class[])new Class[]{PsiFile.class});
            RefElement refElement = context.getRefManager().getReference((PsiElement)problemElement);
            if (refElement == null && problemElement != null) {
                refElement = GlobalInspectionContextUtil.retrieveRefElement(elt, context);
            }
            return refElement;
        };
    }
}

