/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.actions;

import com.intellij.analysis.AnalysisScope;
import com.intellij.analysis.PerformAnalysisInBackgroundOption;
import com.intellij.codeHighlighting.HighlightDisplayLevel;
import com.intellij.codeInsight.daemon.HighlightDisplayKey;
import com.intellij.codeInspection.InspectionManager;
import com.intellij.codeInspection.InspectionsBundle;
import com.intellij.codeInspection.ex.GlobalInspectionContextImpl;
import com.intellij.codeInspection.ex.InspectionManagerEx;
import com.intellij.codeInspection.ex.InspectionProfileImpl;
import com.intellij.codeInspection.ex.Tools;
import com.intellij.codeInspection.ex.ToolsImpl;
import com.intellij.codeInspection.offline.OfflineProblemDescriptor;
import com.intellij.codeInspection.offlineViewer.OfflineInspectionRVContentProvider;
import com.intellij.codeInspection.offlineViewer.OfflineViewParseUtil;
import com.intellij.codeInspection.reference.RefManagerImpl;
import com.intellij.codeInspection.ui.InspectionResultsView;
import com.intellij.icons.AllIcons;
import com.intellij.openapi.actionSystem.ActionPlaces;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.fileChooser.FileChooser;
import com.intellij.openapi.fileChooser.FileChooserDescriptor;
import com.intellij.openapi.fileTypes.StdFileTypes;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.profile.codeInspection.InspectionProfileManager;
import com.intellij.profile.codeInspection.InspectionProjectProfileManager;
import com.intellij.psi.PsiElement;
import com.intellij.util.ExceptionUtil;
import com.intellij.util.PlatformUtils;
import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ViewOfflineResultsAction
extends AnAction {
    private static final Logger LOG = Logger.getInstance(ViewOfflineResultsAction.class);

    public void update(@NotNull AnActionEvent event) {
        Presentation presentation2 = event.getPresentation();
        Project project = event.getProject();
        presentation2.setEnabled(project != null);
        presentation2.setVisible(ActionPlaces.isMainMenuOrActionSearch((String)event.getPlace()) && !PlatformUtils.isCidr());
    }

    public void actionPerformed(@NotNull AnActionEvent event) {
        final Project project = event.getProject();
        LOG.assertTrue(project != null);
        FileChooserDescriptor descriptor2 = new FileChooserDescriptor(true, true, false, false, false, false){

            public Icon getIcon(VirtualFile file2) {
                if (file2.isDirectory() && file2.findChild(".descriptions." + StdFileTypes.XML.getDefaultExtension()) != null) {
                    return AllIcons.Nodes.InspectionResults;
                }
                return super.getIcon(file2);
            }
        }.withFileFilter(f -> f.isDirectory() || StdFileTypes.XML.getDefaultExtension().equals(f.getExtension())).withTitle(InspectionsBundle.message((String)"view.offline.inspections.select.path.title", (Object[])new Object[0])).withDescription(InspectionsBundle.message((String)"view.offline.inspections.select.path.description", (Object[])new Object[0]));
        final VirtualFile virtualFile = FileChooser.chooseFile((FileChooserDescriptor)descriptor2, (Project)project, null);
        if (virtualFile == null) {
            return;
        }
        final HashMap resMap = new HashMap();
        final String[] profileName = new String[1];
        ProgressManager.getInstance().run((Task)new Task.Backgroundable(project, InspectionsBundle.message((String)"parsing.inspections.dump.progress.title", (Object[])new Object[0]), true, new PerformAnalysisInBackgroundOption(project)){

            public void run(@NotNull ProgressIndicator indicator) {
                VirtualFile[] virtualFileArray;
                VfsUtil.markDirtyAndRefresh((boolean)false, (boolean)true, (boolean)true, (VirtualFile[])new VirtualFile[]{virtualFile});
                if (virtualFile.isDirectory()) {
                    virtualFileArray = virtualFile.getChildren();
                } else {
                    VirtualFile[] virtualFileArray2 = new VirtualFile[1];
                    virtualFileArray = virtualFileArray2;
                    virtualFileArray2[0] = virtualFile;
                }
                VirtualFile[] files2 = virtualFileArray;
                try {
                    for (VirtualFile inspectionFile : files2) {
                        if (inspectionFile.isDirectory()) continue;
                        String shortName = inspectionFile.getNameWithoutExtension();
                        String extension = inspectionFile.getExtension();
                        File inspectionIoFile = VfsUtilCore.virtualToIoFile((VirtualFile)inspectionFile);
                        try {
                            if (shortName.equals(".descriptions")) {
                                profileName[0] = (String)ReadAction.compute(() -> OfflineViewParseUtil.parseProfileName(inspectionIoFile));
                                continue;
                            }
                            if (!StdFileTypes.XML.getDefaultExtension().equals(extension)) continue;
                            resMap.put(shortName, ReadAction.compute(() -> OfflineViewParseUtil.parse(inspectionIoFile)));
                        }
                        catch (Exception e) {
                            throw new RuntimeException("Can't read file: " + inspectionFile.getName(), e);
                        }
                    }
                    if (profileName[0] == null) {
                        profileName[0] = virtualFile.getNameWithoutExtension();
                    }
                }
                catch (Exception e) {
                    ApplicationManager.getApplication().invokeLater(() -> Messages.showInfoMessage((String)ExceptionUtil.getThrowableText((Throwable)e), (String)InspectionsBundle.message((String)"offline.view.parse.exception.title", (Object[])new Object[0])));
                    throw new ProcessCanceledException((Throwable)e);
                }
            }

            public void onSuccess() {
                if (resMap.isEmpty()) {
                    return;
                }
                DumbService.getInstance((Project)project).smartInvokeLater(() -> {
                    String name = profileName[0];
                    LOG.assertTrue(name != null);
                    ViewOfflineResultsAction.showOfflineView(project, name, resMap, InspectionsBundle.message((String)"offline.view.title", (Object[])new Object[0]) + " (" + name + ")");
                });
            }
        });
    }

    public static InspectionResultsView showOfflineView(@NotNull Project project, @Nullable String profileName, @NotNull Map<String, Map<String, Set<OfflineProblemDescriptor>>> resMap, @NotNull String title) {
        InspectionProfileImpl profile;
        if (profileName != null) {
            profile = InspectionProjectProfileManager.getInstance(project).getProfile(profileName, false);
            if (profile == null) {
                profile = InspectionProfileManager.getInstance().getProfile(profileName, false);
            }
        } else {
            profile = null;
        }
        InspectionProfileImpl inspectionProfile = new InspectionProfileImpl(profileName != null ? profileName : "Server Side"){

            @Override
            @NotNull
            public HighlightDisplayLevel getErrorLevel(@NotNull HighlightDisplayKey key, PsiElement element2) {
                return InspectionProfileManager.getInstance().getCurrentProfile().getErrorLevel(key, element2);
            }
        };
        if (profile != null) {
            inspectionProfile.copyFrom(profile);
        }
        for (Tools tool : inspectionProfile.getAllEnabledInspectionTools(project)) {
            String id2 = tool.getShortName();
            if (resMap.containsKey(id2)) continue;
            ((ToolsImpl)tool).setEnabled(false);
        }
        for (String id3 : resMap.keySet()) {
            if (inspectionProfile.getToolsOrNull(id3, project) == null) continue;
            inspectionProfile.enableTool(id3, project);
        }
        return ViewOfflineResultsAction.showOfflineView(project, resMap, inspectionProfile, title);
    }

    @NotNull
    public static InspectionResultsView showOfflineView(@NotNull Project project, @NotNull Map<String, Map<String, Set<OfflineProblemDescriptor>>> resMap, @NotNull InspectionProfileImpl inspectionProfile, @NotNull String title) {
        AnalysisScope scope = new AnalysisScope(project);
        InspectionManagerEx managerEx = (InspectionManagerEx)InspectionManager.getInstance((Project)project);
        GlobalInspectionContextImpl context = managerEx.createNewGlobalContext();
        context.setExternalProfile(inspectionProfile);
        context.setCurrentScope(scope);
        context.initializeTools(new ArrayList<Tools>(), new ArrayList<Tools>(), new ArrayList());
        InspectionResultsView view = new InspectionResultsView(context, new OfflineInspectionRVContentProvider(resMap));
        ((RefManagerImpl)context.getRefManager()).startOfflineView();
        context.addView(view, title, true);
        view.update();
        return view;
    }
}

