/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.actions;

import com.intellij.analysis.AnalysisScope;
import com.intellij.application.options.schemes.SchemesCombo;
import com.intellij.codeInspection.InspectionManager;
import com.intellij.codeInspection.actions.CodeInspectionAction;
import com.intellij.codeInspection.ex.GlobalInspectionContextBase;
import com.intellij.codeInspection.ex.InspectionProfileImpl;
import com.intellij.codeInspection.ex.InspectionToolWrapper;
import com.intellij.openapi.project.Project;
import com.intellij.profile.codeInspection.InspectionProjectProfileManager;
import com.intellij.profile.codeInspection.ProjectInspectionProfileManager;
import org.jetbrains.annotations.NotNull;

public class CodeCleanupAction
extends CodeInspectionAction {
    public static final String CODE_CLEANUP_INSPECTIONS_DISPLAY_NAME = "Code Cleanup Inspections";

    public CodeCleanupAction() {
        super("Code Cleanup", "Code Cleanup");
    }

    @Override
    protected void runInspections(@NotNull Project project, @NotNull AnalysisScope scope) {
        InspectionProfileImpl profile = this.myExternalProfile != null ? this.myExternalProfile : InspectionProjectProfileManager.getInstance(project).getCurrentProfile();
        InspectionManager managerEx = InspectionManager.getInstance((Project)project);
        GlobalInspectionContextBase globalContext = (GlobalInspectionContextBase)managerEx.createNewGlobalContext();
        globalContext.codeCleanup(scope, profile, this.getTemplatePresentation().getText(), null, false);
    }

    @Override
    protected String getHelpTopic() {
        return "reference.dialogs.cleanup.scope";
    }

    @Override
    protected CodeInspectionAction.ExternalProfilesComboboxAwareInspectionToolsConfigurable createConfigurable(ProjectInspectionProfileManager projectProfileManager, SchemesCombo<InspectionProfileImpl> profilesCombo) {
        return new CodeInspectionAction.ExternalProfilesComboboxAwareInspectionToolsConfigurable(projectProfileManager, profilesCombo){

            @Override
            protected boolean acceptTool(InspectionToolWrapper entry) {
                return super.acceptTool(entry) && entry.isCleanupTool();
            }

            @Override
            public String getDisplayName() {
                return CodeCleanupAction.CODE_CLEANUP_INSPECTIONS_DISPLAY_NAME;
            }
        };
    }
}

