/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection;

import com.intellij.analysis.AnalysisScope;
import com.intellij.codeInsight.daemon.impl.Divider;
import com.intellij.codeInspection.CommonProblemDescriptor;
import com.intellij.codeInspection.GlobalInspectionContext;
import com.intellij.codeInspection.GlobalInspectionTool;
import com.intellij.codeInspection.GlobalSimpleInspectionTool;
import com.intellij.codeInspection.InspectionManager;
import com.intellij.codeInspection.LocalInspectionTool;
import com.intellij.codeInspection.LocalInspectionToolSession;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptionsProcessor;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemDescriptorBase;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.codeInspection.SuppressionUtil;
import com.intellij.codeInspection.ex.GlobalInspectionToolWrapper;
import com.intellij.codeInspection.ex.InspectionToolWrapper;
import com.intellij.codeInspection.ex.LocalInspectionToolWrapper;
import com.intellij.codeInspection.reference.RefElement;
import com.intellij.codeInspection.reference.RefEntity;
import com.intellij.codeInspection.reference.RefManagerImpl;
import com.intellij.codeInspection.reference.RefVisitor;
import com.intellij.concurrency.JobLauncher;
import com.intellij.lang.Language;
import com.intellij.lang.MetaLanguage;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.EmptyProgressIndicator;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiRecursiveVisitor;
import com.intellij.util.CommonProcessors;
import com.intellij.util.Processor;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.SmartHashSet;
import gnu.trove.THashSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class InspectionEngine {
    private static final Logger LOG = Logger.getInstance(InspectionEngine.class);
    private static final Set<Class<? extends LocalInspectionTool>> RECURSIVE_VISITOR_TOOL_CLASSES = ContainerUtil.newConcurrentSet();

    @NotNull
    public static PsiElementVisitor createVisitorAndAcceptElements(@NotNull LocalInspectionTool tool, @NotNull ProblemsHolder holder, boolean isOnTheFly, @NotNull LocalInspectionToolSession session2, @NotNull List<? extends PsiElement> elements2) {
        PsiElementVisitor visitor = tool.buildVisitor(holder, isOnTheFly, session2);
        if (visitor == null) {
            LOG.error("Tool " + tool + " (" + tool.getClass() + ") must not return null from the buildVisitor() method");
        } else if (visitor instanceof PsiRecursiveVisitor && RECURSIVE_VISITOR_TOOL_CLASSES.add(tool.getClass())) {
            LOG.error("The visitor returned from LocalInspectionTool.buildVisitor() must not be recursive: " + tool);
        }
        if (visitor != PsiElementVisitor.EMPTY_VISITOR) {
            tool.inspectionStarted(session2, isOnTheFly);
            InspectionEngine.acceptElements(elements2, visitor);
        }
        return visitor;
    }

    public static void acceptElements(@NotNull List<? extends PsiElement> elements2, @NotNull PsiElementVisitor elementVisitor) {
        int elementsSize = elements2.size();
        for (int i2 = 0; i2 < elementsSize; ++i2) {
            PsiElement element2 = elements2.get(i2);
            element2.accept(elementVisitor);
            ProgressManager.checkCanceled();
        }
    }

    @NotNull
    private static List<ProblemDescriptor> inspect(@NotNull List<? extends LocalInspectionToolWrapper> toolWrappers, @NotNull PsiFile file2, @NotNull InspectionManager iManager, @NotNull ProgressIndicator indicator) {
        Map<String, List<ProblemDescriptor>> problemDescriptors = InspectionEngine.inspectEx(toolWrappers, file2, iManager, false, indicator);
        ArrayList<ProblemDescriptor> result2 = new ArrayList<ProblemDescriptor>();
        for (List<ProblemDescriptor> group : problemDescriptors.values()) {
            result2.addAll(group);
        }
        return result2;
    }

    @NotNull
    public static Map<String, List<ProblemDescriptor>> inspectEx(@NotNull List<? extends LocalInspectionToolWrapper> toolWrappers, @NotNull PsiFile file2, @NotNull InspectionManager iManager, boolean isOnTheFly, @NotNull ProgressIndicator indicator) {
        if (toolWrappers.isEmpty()) {
            return Collections.emptyMap();
        }
        TextRange range2 = file2.getTextRange();
        ArrayList allDivided = new ArrayList();
        Divider.divideInsideAndOutsideAllRoots(file2, range2, range2, __ -> true, (Processor<? super Divider.DividedElements>)new CommonProcessors.CollectProcessor(allDivided));
        List elements2 = ContainerUtil.concat((Iterable)ContainerUtil.map(allDivided, d -> ContainerUtil.concat((List[])new List[]{d.inside, d.outside, d.parents})));
        return InspectionEngine.inspectElements(toolWrappers, file2, iManager, isOnTheFly, indicator, elements2, InspectionEngine.calcElementDialectIds(elements2));
    }

    @NotNull
    static Map<String, List<ProblemDescriptor>> inspectElements(@NotNull List<? extends LocalInspectionToolWrapper> toolWrappers, @NotNull PsiFile file2, @NotNull InspectionManager iManager, boolean isOnTheFly, @NotNull ProgressIndicator indicator, @NotNull List<? extends PsiElement> elements2, @NotNull Set<String> elementDialectIds) {
        TextRange range2 = file2.getTextRange();
        LocalInspectionToolSession session2 = new LocalInspectionToolSession(file2, range2.getStartOffset(), range2.getEndOffset());
        toolWrappers = InspectionEngine.filterToolsApplicableByLanguage(toolWrappers, elementDialectIds);
        ConcurrentHashMap<String, List<ProblemDescriptor>> resultDescriptors = new ConcurrentHashMap<String, List<ProblemDescriptor>>();
        Processor processor2 = wrapper2 -> {
            ProblemsHolder holder = new ProblemsHolder(iManager, file2, isOnTheFly);
            LocalInspectionTool tool = (LocalInspectionTool)wrapper2.getTool();
            InspectionEngine.createVisitorAndAcceptElements(tool, holder, isOnTheFly, session2, elements2);
            tool.inspectionFinished(session2, holder);
            if (holder.hasResults()) {
                resultDescriptors.put(tool.getShortName(), ContainerUtil.filter((Collection)holder.getResults(), descriptor2 -> {
                    PsiElement element2 = descriptor2.getPsiElement();
                    return element2 == null || !SuppressionUtil.inspectionResultSuppressed(element2, tool);
                }));
            }
            return true;
        };
        JobLauncher.getInstance().invokeConcurrentlyUnderProgress(toolWrappers, indicator, processor2);
        return resultDescriptors;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public static List<ProblemDescriptor> runInspectionOnFile(final @NotNull PsiFile file2, @NotNull InspectionToolWrapper<?, ?> toolWrapper, final @NotNull GlobalInspectionContext inspectionContext) {
        final InspectionManager inspectionManager = InspectionManager.getInstance((Project)file2.getProject());
        toolWrapper.initialize(inspectionContext);
        RefManagerImpl refManager = (RefManagerImpl)inspectionContext.getRefManager();
        refManager.inspectionReadActionStarted();
        try {
            if (toolWrapper instanceof LocalInspectionToolWrapper) {
                List<ProblemDescriptor> list2 = InspectionEngine.inspect(Collections.singletonList((LocalInspectionToolWrapper)toolWrapper), file2, inspectionManager, (ProgressIndicator)new EmptyProgressIndicator());
                return list2;
            }
            if (toolWrapper instanceof GlobalInspectionToolWrapper) {
                final GlobalInspectionTool globalTool = (GlobalInspectionTool)((GlobalInspectionToolWrapper)toolWrapper).getTool();
                final ArrayList<ProblemDescriptor> descriptors = new ArrayList<ProblemDescriptor>();
                if (globalTool instanceof GlobalSimpleInspectionTool) {
                    GlobalSimpleInspectionTool simpleTool = (GlobalSimpleInspectionTool)globalTool;
                    ProblemsHolder problemsHolder = new ProblemsHolder(inspectionManager, file2, false);
                    ProblemDescriptionsProcessor collectProcessor = new ProblemDescriptionsProcessor(){

                        public CommonProblemDescriptor[] getDescriptions(@NotNull RefEntity refEntity) {
                            return descriptors.toArray(CommonProblemDescriptor.EMPTY_ARRAY);
                        }

                        public void ignoreElement(@NotNull RefEntity refEntity) {
                            throw new UnsupportedOperationException();
                        }

                        public void resolveProblem(@NotNull CommonProblemDescriptor descriptor2) {
                            throw new UnsupportedOperationException();
                        }

                        public void addProblemElement(@Nullable RefEntity refEntity, CommonProblemDescriptor ... commonProblemDescriptors) {
                            if (!(refEntity instanceof RefElement)) {
                                return;
                            }
                            PsiElement element2 = ((RefElement)refEntity).getPsiElement();
                            InspectionEngine.convertToProblemDescriptors(element2, commonProblemDescriptors, descriptors);
                        }

                        public RefEntity getElement(@NotNull CommonProblemDescriptor descriptor2) {
                            throw new RuntimeException();
                        }
                    };
                    simpleTool.checkFile(file2, inspectionManager, problemsHolder, inspectionContext, collectProcessor);
                    ArrayList<ProblemDescriptor> arrayList = descriptors;
                    return arrayList;
                }
                RefElement fileRef = refManager.getReference((PsiElement)file2);
                final AnalysisScope scope = new AnalysisScope(file2);
                assert (fileRef != null);
                fileRef.accept(new RefVisitor(){

                    public void visitElement(@NotNull RefEntity elem) {
                        CommonProblemDescriptor[] elemDescriptors = globalTool.checkElement(elem, scope, inspectionManager, inspectionContext);
                        if (elemDescriptors != null) {
                            InspectionEngine.convertToProblemDescriptors((PsiElement)file2, elemDescriptors, descriptors);
                        }
                        for (RefEntity child2 : elem.getChildren()) {
                            child2.accept((RefVisitor)this);
                        }
                    }
                });
                ArrayList<ProblemDescriptor> arrayList = descriptors;
                return arrayList;
            }
        }
        finally {
            refManager.inspectionReadActionFinished();
            toolWrapper.cleanup(file2.getProject());
            inspectionContext.cleanup();
        }
        return Collections.emptyList();
    }

    private static void convertToProblemDescriptors(@NotNull PsiElement element2, CommonProblemDescriptor @NotNull [] commonProblemDescriptors, @NotNull List<? super ProblemDescriptor> descriptors) {
        for (CommonProblemDescriptor common : commonProblemDescriptors) {
            if (common instanceof ProblemDescriptor) {
                descriptors.add((ProblemDescriptor)((ProblemDescriptor)common));
                continue;
            }
            ProblemDescriptorBase base = new ProblemDescriptorBase(element2, element2, common.getDescriptionTemplate(), (LocalQuickFix[])common.getFixes(), ProblemHighlightType.GENERIC_ERROR_OR_WARNING, false, null, false, false);
            descriptors.add(base);
        }
    }

    @NotNull
    public static List<LocalInspectionToolWrapper> filterToolsApplicableByLanguage(@NotNull Collection<? extends LocalInspectionToolWrapper> tools, @NotNull Set<String> elementDialectIds) {
        HashMap resultsWithDialects = new HashMap();
        HashMap resultsNoDialects = new HashMap();
        return ContainerUtil.filter(tools, tool -> {
            String language = tool.getLanguage();
            if (language == null) {
                return true;
            }
            boolean applyToDialects = tool.applyToDialects();
            Map map2 = applyToDialects ? resultsWithDialects : resultsNoDialects;
            return map2.computeIfAbsent(language, __ -> ContainerUtil.intersects((Collection)elementDialectIds, InspectionEngine.getDialectIdsSpecifiedForTool(language, applyToDialects)));
        });
    }

    @NotNull
    private static Set<String> getDialectIdsSpecifiedForTool(String langId, boolean applyToDialects) {
        THashSet result2;
        Language language = Language.findLanguageByID((String)langId);
        if (language == null) {
            result2 = Collections.singleton(langId);
        } else if (language instanceof MetaLanguage) {
            Collection matchingLanguages = ((MetaLanguage)language).getMatchingLanguages();
            result2 = new THashSet();
            for (Language matchingLanguage : matchingLanguages) {
                result2.addAll(InspectionEngine.getLanguageWithDialects(matchingLanguage, applyToDialects));
            }
        } else {
            result2 = InspectionEngine.getLanguageWithDialects(language, applyToDialects);
        }
        return result2;
    }

    @NotNull
    private static Set<String> getLanguageWithDialects(@NotNull Language language, boolean applyToDialects) {
        List dialects = language.getDialects();
        if (!applyToDialects || dialects.isEmpty()) {
            return Collections.singleton(language.getID());
        }
        THashSet result2 = new THashSet(1 + dialects.size());
        result2.add(language.getID());
        InspectionEngine.addDialects(language, (Set<? super String>)result2);
        return result2;
    }

    private static void addDialects(@NotNull Language language, @NotNull Set<? super String> result2) {
        for (Language dialect : language.getDialects()) {
            if (!result2.add(dialect.getID())) continue;
            InspectionEngine.addDialects(dialect, result2);
        }
    }

    @NotNull
    public static Set<String> calcElementDialectIds(@NotNull List<? extends PsiElement> inside, @NotNull List<? extends PsiElement> outside) {
        SmartHashSet dialectIds = new SmartHashSet();
        SmartHashSet processedLanguages = new SmartHashSet();
        InspectionEngine.addDialects(inside, (Set<? super Language>)processedLanguages, (Set<? super String>)dialectIds);
        InspectionEngine.addDialects(outside, (Set<? super Language>)processedLanguages, (Set<? super String>)dialectIds);
        return dialectIds;
    }

    @NotNull
    public static Set<String> calcElementDialectIds(@NotNull List<? extends PsiElement> elements2) {
        SmartHashSet dialectIds = new SmartHashSet();
        SmartHashSet processedLanguages = new SmartHashSet();
        InspectionEngine.addDialects(elements2, (Set<? super Language>)processedLanguages, (Set<? super String>)dialectIds);
        return dialectIds;
    }

    private static void addDialects(@NotNull List<? extends PsiElement> elements2, @NotNull Set<? super Language> outProcessedLanguages, @NotNull Set<? super String> outDialectIds) {
        for (PsiElement psiElement : elements2) {
            Language language = psiElement.getLanguage();
            outDialectIds.add(language.getID());
            InspectionEngine.addDialects(language, outProcessedLanguages, outDialectIds);
        }
    }

    private static void addDialects(@NotNull Language language, @NotNull Set<? super Language> outProcessedLanguages, @NotNull Set<? super String> outDialectIds) {
        if (outProcessedLanguages.add((Language)language)) {
            for (Language dialect : language.getDialects()) {
                outDialectIds.add(dialect.getID());
                InspectionEngine.addDialects(dialect, outProcessedLanguages, outDialectIds);
            }
        }
    }
}

