/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.template.postfix.settings;

import com.intellij.codeInsight.template.postfix.templates.LanguagePostfixTemplate;
import com.intellij.codeInsight.template.postfix.templates.PostfixTemplate;
import com.intellij.codeInsight.template.postfix.templates.PostfixTemplateProvider;
import com.intellij.configurationStore.XmlSerializer;
import com.intellij.lang.Language;
import com.intellij.lang.LanguageExtensionPoint;
import com.intellij.openapi.components.PersistentStateComponent;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.components.State;
import com.intellij.openapi.components.Storage;
import com.intellij.openapi.util.Factory;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.MultiMap;
import com.intellij.util.xmlb.annotations.MapAnnotation;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.jdom.Element;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@State(name="PostfixTemplatesSettings", storages={@Storage(value="postfixTemplates.xml")})
public class PostfixTemplatesSettings
implements PersistentStateComponent<Element> {
    public static final Factory<Set<String>> SET_FACTORY = () -> new HashSet();
    private Map<String, Set<String>> myProviderToDisabledTemplates = new HashMap<String, Set<String>>();
    @Deprecated
    private Map<String, Set<String>> myLangToDisabledTemplates = new HashMap<String, Set<String>>();
    private boolean postfixTemplatesEnabled = true;
    private boolean templatesCompletionEnabled = true;
    private int myShortcut = 9;

    public boolean isTemplateEnabled(@NotNull PostfixTemplate template, @NotNull PostfixTemplateProvider provider) {
        Set<String> result2 = this.myProviderToDisabledTemplates.get(provider.getId());
        return result2 == null || !result2.contains(template.getId());
    }

    public void disableTemplate(@NotNull PostfixTemplate template, @NotNull PostfixTemplateProvider provider) {
        this.disableTemplate(template, provider.getId());
    }

    public void disableTemplate(@NotNull PostfixTemplate template, @NotNull String providerId) {
        Set state = (Set)ContainerUtil.getOrCreate(this.myProviderToDisabledTemplates, (Object)providerId, SET_FACTORY);
        state.add(template.getId());
    }

    public boolean isPostfixTemplatesEnabled() {
        return this.postfixTemplatesEnabled;
    }

    public void setPostfixTemplatesEnabled(boolean postfixTemplatesEnabled) {
        this.postfixTemplatesEnabled = postfixTemplatesEnabled;
    }

    public boolean isTemplatesCompletionEnabled() {
        return this.templatesCompletionEnabled;
    }

    public void setTemplatesCompletionEnabled(boolean templatesCompletionEnabled) {
        this.templatesCompletionEnabled = templatesCompletionEnabled;
    }

    @Deprecated
    @MapAnnotation(entryTagName="disabled-postfix-templates", keyAttributeName="lang", surroundWithTag=false)
    @NotNull
    public Map<String, Set<String>> getLangDisabledTemplates() {
        return this.myLangToDisabledTemplates;
    }

    @Deprecated
    public void setLangDisabledTemplates(@NotNull Map<String, Set<String>> templatesState) {
        this.myLangToDisabledTemplates = templatesState;
    }

    @MapAnnotation(entryTagName="disabled-templates", keyAttributeName="provider", surroundWithTag=false)
    @NotNull
    public Map<String, Set<String>> getProviderToDisabledTemplates() {
        return this.myProviderToDisabledTemplates;
    }

    public void setProviderToDisabledTemplates(@NotNull Map<String, Set<String>> templatesState) {
        this.myProviderToDisabledTemplates = templatesState;
    }

    public int getShortcut() {
        return this.myShortcut;
    }

    public void setShortcut(int shortcut) {
        this.myShortcut = shortcut;
    }

    @NotNull
    public static PostfixTemplatesSettings getInstance() {
        return (PostfixTemplatesSettings)ServiceManager.getService(PostfixTemplatesSettings.class);
    }

    @Nullable
    public Element getState() {
        Element result2 = new Element("state");
        XmlSerializer.serializeObjectInto((Object)this, (Element)result2);
        return result2;
    }

    public void loadState(@NotNull Element settings) {
        this.myLangToDisabledTemplates.clear();
        XmlSerializer.deserializeInto((Element)settings, (Object)this);
        if (!this.myLangToDisabledTemplates.isEmpty()) {
            MultiMap<String, Language> importedLanguages = PostfixTemplatesSettings.getLanguagesToImport();
            for (Map.Entry<String, Set<String>> entry : this.myLangToDisabledTemplates.entrySet()) {
                for (Language language : importedLanguages.get((Object)entry.getKey())) {
                    for (PostfixTemplateProvider provider : LanguagePostfixTemplate.LANG_EP.allForLanguage(language)) {
                        for (PostfixTemplate template : provider.getTemplates()) {
                            if (!entry.getValue().contains(template.getKey())) continue;
                            this.disableTemplate(template, provider);
                        }
                    }
                }
            }
            for (String language : importedLanguages.keySet()) {
                this.myLangToDisabledTemplates.remove(language);
            }
        }
    }

    @NotNull
    private static MultiMap<String, Language> getLanguagesToImport() {
        MultiMap importedLanguages = MultiMap.create();
        for (LanguageExtensionPoint extension : LanguagePostfixTemplate.EP_NAME.getExtensionList()) {
            Language language = Language.findLanguageByID((String)extension.getKey());
            if (language == null) continue;
            importedLanguages.putValue((Object)language.getDisplayName(), (Object)language);
        }
        return importedLanguages;
    }
}

