/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.template.postfix.settings;

import com.intellij.codeInsight.CodeInsightBundle;
import com.intellij.codeInsight.template.impl.TemplateEditorUtil;
import com.intellij.codeInsight.template.postfix.templates.PostfixTemplate;
import com.intellij.codeInsight.template.postfix.templates.PostfixTemplateProvider;
import com.intellij.codeInsight.template.postfix.templates.editable.EditablePostfixTemplateWithMultipleExpressions;
import com.intellij.codeInsight.template.postfix.templates.editable.PostfixTemplateEditor;
import com.intellij.codeInsight.template.postfix.templates.editable.PostfixTemplateExpressionCondition;
import com.intellij.ide.DataManager;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.EditorFactory;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.panel.PanelBuilder;
import com.intellij.openapi.ui.panel.PanelGridBuilder;
import com.intellij.openapi.ui.popup.JBPopupFactory;
import com.intellij.openapi.ui.popup.ListPopup;
import com.intellij.ui.AnActionButton;
import com.intellij.ui.ListUtil;
import com.intellij.ui.SimpleListCellRenderer;
import com.intellij.ui.ToolbarDecorator;
import com.intellij.ui.components.JBCheckBox;
import com.intellij.ui.components.JBList;
import com.intellij.util.ui.DialogUtil;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.UI;
import java.awt.Component;
import java.awt.Dimension;
import java.util.Objects;
import javax.swing.AbstractButton;
import javax.swing.DefaultListModel;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.ListCellRenderer;
import javax.swing.border.Border;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class PostfixTemplateEditorBase<Condition extends PostfixTemplateExpressionCondition>
implements PostfixTemplateEditor {
    @NotNull
    protected final PostfixTemplateProvider myProvider;
    @NotNull
    protected final Editor myTemplateEditor;
    @NotNull
    protected final JBList<Condition> myExpressionTypesList;
    @NotNull
    protected final DefaultListModel<Condition> myExpressionTypesListModel;
    @NotNull
    protected final JBCheckBox myApplyToTheTopmostJBCheckBox;
    @NotNull
    protected final JPanel myEditTemplateAndConditionsPanel;

    public PostfixTemplateEditorBase(@NotNull PostfixTemplateProvider provider, boolean showExpressionTypes) {
        this(provider, PostfixTemplateEditorBase.createSimpleEditor(), showExpressionTypes);
    }

    public PostfixTemplateEditorBase(@NotNull PostfixTemplateProvider provider, @NotNull Editor templateEditor, boolean showExpressionTypes) {
        this.myProvider = provider;
        this.myTemplateEditor = templateEditor;
        this.myApplyToTheTopmostJBCheckBox = new JBCheckBox(CodeInsightBundle.message((String)"checkbox.apply.to.the.&topmost.expression", (Object[])new Object[0]));
        DialogUtil.registerMnemonic((AbstractButton)this.myApplyToTheTopmostJBCheckBox, (char)'&');
        this.myApplyToTheTopmostJBCheckBox.setBorder((Border)JBUI.Borders.emptyBottom((int)4));
        this.myExpressionTypesListModel = JBList.createDefaultListModel((Object[])new PostfixTemplateExpressionCondition[0]);
        this.myExpressionTypesList = new JBList(this.myExpressionTypesListModel);
        this.myExpressionTypesList.setCellRenderer((ListCellRenderer)SimpleListCellRenderer.create((String)"", PostfixTemplateExpressionCondition::getPresentableName));
        PanelGridBuilder grid = UI.PanelFactory.grid().resize();
        if (showExpressionTypes) {
            JPanel expressionTypesPanel = ToolbarDecorator.createDecorator(this.myExpressionTypesList).setAddAction(button2 -> this.showAddExpressionTypePopup((AnActionButton)button2)).setRemoveAction(button2 -> ListUtil.removeSelectedItems(this.myExpressionTypesList)).disableUpDownActions().setMinimumSize((Dimension)JBUI.size((int)-1, (int)300)).createPanel();
            grid.add((PanelBuilder)UI.PanelFactory.panel((JComponent)expressionTypesPanel).withLabel(CodeInsightBundle.message((String)"label.applicable.expression.types", (Object[])new Object[0])).resizeY(true).moveLabelOnTop());
        }
        grid.add((PanelBuilder)UI.PanelFactory.panel((JComponent)this.myApplyToTheTopmostJBCheckBox));
        grid.add((PanelBuilder)UI.PanelFactory.panel((JComponent)this.myTemplateEditor.getComponent()).anchorLabelOn(UI.Anchor.Top).withComment(CodeInsightBundle.message((String)"comment.use.expr.variable.to.refer.target.expression", (Object[])new Object[0])).resizeY(true));
        this.myEditTemplateAndConditionsPanel = grid.createPanel();
    }

    @NotNull
    protected static Editor createEditor(@Nullable Project project, @NotNull Document document) {
        return TemplateEditorUtil.createEditor(false, document, project);
    }

    @NotNull
    private static Editor createSimpleEditor() {
        return PostfixTemplateEditorBase.createEditor(null, EditorFactory.getInstance().createDocument((CharSequence)""));
    }

    protected final void showAddExpressionTypePopup(@NotNull AnActionButton button2) {
        DefaultActionGroup group = new DefaultActionGroup();
        this.fillConditions(group);
        DataContext context = DataManager.getInstance().getDataContext((Component)button2.getContextComponent());
        ListPopup popup2 = JBPopupFactory.getInstance().createActionGroupPopup(null, (ActionGroup)group, context, JBPopupFactory.ActionSelectionAid.ALPHA_NUMBERING, true, null);
        popup2.show(Objects.requireNonNull(button2.getPreferredPopupPoint()));
    }

    protected abstract void fillConditions(@NotNull DefaultActionGroup var1);

    public void setTemplate(@Nullable PostfixTemplate rawTemplate) {
        if (!(rawTemplate instanceof EditablePostfixTemplateWithMultipleExpressions)) {
            return;
        }
        EditablePostfixTemplateWithMultipleExpressions template = (EditablePostfixTemplateWithMultipleExpressions)rawTemplate;
        this.myExpressionTypesListModel.clear();
        for (PostfixTemplateExpressionCondition condition : template.getExpressionConditions()) {
            this.myExpressionTypesListModel.addElement(condition);
        }
        this.myApplyToTheTopmostJBCheckBox.setSelected(template.isUseTopmostExpression());
        ApplicationManager.getApplication().runWriteAction(() -> this.myTemplateEditor.getDocument().setText((CharSequence)template.getLiveTemplate().getString()));
    }

    @Override
    public String getHelpId() {
        return "reference.custom.postfix.templates";
    }

    public void dispose() {
        TemplateEditorUtil.disposeTemplateEditor(this.myTemplateEditor);
    }

    protected static class AddConditionAction
    extends DumbAwareAction {
        @NotNull
        private final Condition myCondition;
        final /* synthetic */ PostfixTemplateEditorBase this$0;

        public AddConditionAction(Condition condition) {
            this.this$0 = this$0;
            super(condition.getPresentableName());
            this.myCondition = condition;
        }

        public void actionPerformed(@NotNull AnActionEvent e) {
            this.this$0.myExpressionTypesListModel.addElement(this.myCondition);
        }
    }
}

