/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.template.impl.editorActions;

import com.intellij.codeInsight.CodeInsightBundle;
import com.intellij.codeInsight.lookup.LookupManager;
import com.intellij.codeInsight.lookup.impl.LookupImpl;
import com.intellij.codeInsight.template.impl.TemplateManagerImpl;
import com.intellij.codeInsight.template.impl.TemplateState;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.command.CommandProcessor;
import com.intellij.openapi.editor.Caret;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.SelectionModel;
import com.intellij.openapi.editor.actionSystem.EditorActionHandler;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class EscapeHandler
extends EditorActionHandler {
    private final EditorActionHandler myOriginalHandler;

    public EscapeHandler(EditorActionHandler originalHandler) {
        this.myOriginalHandler = originalHandler;
    }

    public void doExecute(@NotNull Editor editor, @Nullable Caret caret, DataContext dataContext) {
        TemplateState templateState = TemplateManagerImpl.getTemplateState(editor);
        if (templateState != null && !templateState.isFinished()) {
            boolean lookupIsEmpty;
            SelectionModel selectionModel = editor.getSelectionModel();
            LookupImpl lookup2 = (LookupImpl)LookupManager.getActiveLookup(editor);
            boolean bl = lookupIsEmpty = lookup2 == null || lookup2.getCurrentItem() == null;
            if (!selectionModel.hasSelection() && lookupIsEmpty) {
                CommandProcessor.getInstance().setCurrentCommandName(CodeInsightBundle.message((String)"finish.template.command", (Object[])new Object[0]));
                templateState.gotoEnd(true);
                return;
            }
        }
        if (this.myOriginalHandler.isEnabled(editor, caret, dataContext)) {
            this.myOriginalHandler.execute(editor, caret, dataContext);
        }
    }

    public boolean isEnabledForCaret(@NotNull Editor editor, @NotNull Caret caret, DataContext dataContext) {
        TemplateState templateState = TemplateManagerImpl.getTemplateState(editor);
        if (templateState != null && !templateState.isFinished()) {
            return true;
        }
        return this.myOriginalHandler.isEnabled(editor, caret, dataContext);
    }
}

