/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.template.impl;

import com.google.common.annotations.VisibleForTesting;
import com.intellij.codeInsight.template.TemplateContextType;
import com.intellij.codeInsight.template.impl.TemplateManagerImpl;
import com.intellij.openapi.extensions.ExtensionPoint;
import com.intellij.openapi.extensions.ExtensionPointAdapter;
import com.intellij.openapi.extensions.ExtensionPointListener;
import com.intellij.openapi.extensions.ExtensionsArea;
import com.intellij.openapi.util.ClearableLazyValue;
import com.intellij.util.JdomKt;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.JBIterable;
import gnu.trove.THashMap;
import java.util.ArrayList;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Function;
import java.util.stream.Collectors;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.jvm.functions.Function0;
import org.jdom.Element;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TemplateContext {
    private final Map<String, Boolean> myContextStates = new THashMap();
    private static final ClearableLazyValue<Map<String, String>> INTERN_MAP = new ClearableLazyValue<Map<String, String>>(){
        private final AtomicBoolean isListenerAdded = new AtomicBoolean();

        @NotNull
        protected Map<String, String> compute() {
            if (this.isListenerAdded.compareAndSet(false, true)) {
                ((ExtensionPoint)TemplateManagerImpl.TEMPLATE_CONTEXT_EP.getValue()).addExtensionPointListener((ExtensionPointListener)new ExtensionPointAdapter<TemplateContextType>(){

                    public void areaReplaced(@NotNull ExtensionsArea oldArea) {
                        this.drop();
                    }

                    public void extensionListChanged() {
                        this.drop();
                    }
                }, false, null);
            }
            return TemplateManagerImpl.getAllContextTypes().stream().map(TemplateContextType::getContextId).distinct().collect(Collectors.toMap(Function.identity(), Function.identity()));
        }
    };

    public TemplateContext createCopy() {
        TemplateContext cloneResult = new TemplateContext();
        cloneResult.myContextStates.putAll(this.myContextStates);
        return cloneResult;
    }

    @Nullable
    TemplateContextType getDifference(@NotNull TemplateContext defaultContext) {
        return (TemplateContextType)ContainerUtil.find(TemplateManagerImpl.getAllContextTypes(), type -> this.isEnabled((TemplateContextType)type) != defaultContext.isEnabled((TemplateContextType)type));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isEnabled(@NotNull TemplateContextType contextType) {
        Map<String, Boolean> map2 = this.myContextStates;
        synchronized (map2) {
            Boolean storedValue = this.getOwnValue(contextType);
            if (storedValue == null) {
                // MONITOREXIT @DISABLED, blocks:[0, 1, 3] lbl6 : MonitorExitStatement: MONITOREXIT : var2_2
                TemplateContextType baseContextType = contextType.getBaseContextType();
                return baseContextType != null && this.isEnabled(baseContextType);
            }
            return storedValue;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public Boolean getOwnValue(TemplateContextType contextType) {
        Map<String, Boolean> map2 = this.myContextStates;
        synchronized (map2) {
            return this.myContextStates.get(contextType.getContextId());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setEnabled(TemplateContextType contextType, boolean value2) {
        Map<String, Boolean> map2 = this.myContextStates;
        synchronized (map2) {
            this.myContextStates.put(contextType.getContextId(), value2);
        }
    }

    @VisibleForTesting
    public void setDefaultContext(@NotNull TemplateContext defContext) {
        THashMap copy2 = new THashMap(this.myContextStates);
        this.myContextStates.clear();
        this.myContextStates.putAll(defContext.myContextStates);
        this.myContextStates.putAll((Map<String, Boolean>)copy2);
    }

    @VisibleForTesting
    public void readTemplateContext(@NotNull Element element2) {
        Map internMap = (Map)INTERN_MAP.getValue();
        for (Element option2 : element2.getChildren("option")) {
            String name = option2.getAttributeValue("name");
            String value2 = option2.getAttributeValue("value");
            if (name == null || value2 == null) continue;
            this.myContextStates.put((String)ContainerUtil.getOrElse((Map)internMap, (Object)name, (Object)name), Boolean.parseBoolean(value2));
        }
        this.myContextStates.putAll(this.makeInheritanceExplicit());
    }

    @NotNull
    private Map<String, Boolean> makeInheritanceExplicit() {
        THashMap explicitStates = new THashMap();
        for (TemplateContextType type : ContainerUtil.filter(TemplateManagerImpl.getAllContextTypes(), this::isDisabledByInheritance)) {
            explicitStates.put(type.getContextId(), false);
        }
        return explicitStates;
    }

    private boolean isDisabledByInheritance(TemplateContextType type) {
        return !this.hasOwnValue(type) && !this.isEnabled(type) && JBIterable.generate((Object)type, TemplateContextType::getBaseContextType).filter(this::hasOwnValue).first() != null;
    }

    private boolean hasOwnValue(TemplateContextType t) {
        return this.getOwnValue(t) != null;
    }

    public Element writeTemplateContext(@Nullable TemplateContext defaultContext) {
        return this.writeTemplateContext(defaultContext, TemplateContext.getIdToType());
    }

    @VisibleForTesting
    @Nullable
    public Element writeTemplateContext(@Nullable TemplateContext defaultContext, @NotNull Lazy<? extends Map<String, TemplateContextType>> idToType2) {
        if (this.myContextStates.isEmpty()) {
            return null;
        }
        Element element2 = new Element("context");
        ArrayList<Map.Entry<String, Boolean>> entries = new ArrayList<Map.Entry<String, Boolean>>(this.myContextStates.entrySet());
        entries.sort(Map.Entry.comparingByKey());
        for (Map.Entry entry : entries) {
            Boolean ownValue = (Boolean)entry.getValue();
            if (ownValue == null) continue;
            TemplateContextType type = (TemplateContextType)((Map)idToType2.getValue()).get(entry.getKey());
            if (type == null) {
                JdomKt.addOptionTag((Element)element2, (String)((String)entry.getKey()), (String)ownValue.toString());
                continue;
            }
            if (!this.isValueChanged(ownValue, type, defaultContext)) continue;
            JdomKt.addOptionTag((Element)element2, (String)type.getContextId(), (String)ownValue.toString());
        }
        return element2;
    }

    @NotNull
    public static Lazy<Map<String, TemplateContextType>> getIdToType() {
        return LazyKt.lazy((Function0)new Function0<Map<String, TemplateContextType>>(){

            public Map<String, TemplateContextType> invoke() {
                THashMap idToType2 = new THashMap();
                for (TemplateContextType type : TemplateManagerImpl.getAllContextTypes()) {
                    idToType2.put(type.getContextId(), type);
                }
                return idToType2;
            }
        });
    }

    private boolean isValueChanged(@NotNull Boolean ownValue, @NotNull TemplateContextType type, @Nullable TemplateContext defaultContext) {
        Boolean defaultValue;
        Boolean bl = defaultValue = defaultContext == null ? null : defaultContext.getOwnValue(type);
        if (defaultValue == null) {
            TemplateContextType base = type.getBaseContextType();
            boolean baseEnabled = base != null && this.isEnabled(base);
            return ownValue != baseEnabled;
        }
        return !ownValue.equals(defaultValue);
    }

    public String toString() {
        return this.myContextStates.toString();
    }
}

