/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.template.impl;

import com.intellij.codeInsight.template.impl.LiveTemplateLookupElementImpl;
import com.intellij.codeInsight.template.impl.TemplateImpl;
import com.intellij.codeInsight.template.impl.TemplateSettings;
import com.intellij.lang.documentation.AbstractDocumentationProvider;
import com.intellij.navigation.ItemPresentation;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiManager;
import com.intellij.psi.impl.FakePsiElement;
import com.intellij.psi.impl.source.DummyHolder;
import com.intellij.psi.impl.source.DummyHolderFactory;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class LiveTemplateDocumentationProvider
extends AbstractDocumentationProvider {
    public PsiElement getDocumentationElementForLookupItem(PsiManager psiManager, Object object, PsiElement element2) {
        if (object instanceof LiveTemplateLookupElementImpl) {
            TemplateImpl template = ((LiveTemplateLookupElementImpl)((Object)object)).getTemplate();
            TemplateImpl templateFromSettings = TemplateSettings.getInstance().getTemplate(template.getKey(), template.getGroupName());
            if (templateFromSettings != null) {
                return new LiveTemplateElement(templateFromSettings, psiManager);
            }
        }
        return null;
    }

    public String generateDoc(PsiElement element2, @Nullable PsiElement originalElement) {
        if (!(element2 instanceof LiveTemplateElement)) {
            return null;
        }
        TemplateImpl template = ((LiveTemplateElement)element2).getTemplate();
        return "<div class='definition'><pre>" + StringUtil.escapeXmlEntities((String)template.getString()) + "</pre></div>" + "<div class='content'>" + StringUtil.escapeXmlEntities((String)StringUtil.notNullize((String)template.getDescription())) + "</div>";
    }

    private static class LiveTemplateElement
    extends FakePsiElement {
        @NotNull
        private final TemplateImpl myTemplate;
        @NotNull
        private final PsiManager myPsiManager;
        @NotNull
        private final DummyHolder myDummyHolder;

        LiveTemplateElement(@NotNull TemplateImpl template, @NotNull PsiManager psiManager) {
            this.myTemplate = template;
            this.myPsiManager = psiManager;
            this.myDummyHolder = DummyHolderFactory.createHolder(this.myPsiManager, null);
        }

        @NotNull
        public TemplateImpl getTemplate() {
            return this.myTemplate;
        }

        public PsiElement getParent() {
            return this.myDummyHolder;
        }

        @Override
        public ItemPresentation getPresentation() {
            return new ItemPresentation(){

                @Nullable
                public String getPresentableText() {
                    return myTemplate.getKey();
                }

                @Nullable
                public String getLocationString() {
                    return null;
                }

                @Nullable
                public Icon getIcon(boolean unused) {
                    return null;
                }
            };
        }

        @Override
        public PsiManager getManager() {
            return this.myPsiManager;
        }
    }
}

