/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.preview;

import com.intellij.codeInsight.preview.ElementPreviewProvider;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.event.EditorFactoryEvent;
import com.intellij.openapi.editor.event.EditorFactoryListener;
import com.intellij.openapi.editor.event.EditorMouseEvent;
import com.intellij.openapi.editor.event.EditorMouseMotionListener;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.psi.PsiCompiledElement;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.impl.source.tree.injected.InjectedLanguageUtil;
import com.intellij.util.Alarm;
import com.intellij.util.containers.ContainerUtil;
import java.awt.MouseInfo;
import java.awt.Point;
import java.awt.PointerInfo;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.util.Collection;
import java.util.Collections;
import java.util.Set;
import javax.swing.SwingUtilities;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

final class ImageOrColorPreviewManager
implements Disposable,
EditorMouseMotionListener,
EditorFactoryListener {
    private static final Logger LOG = Logger.getInstance(ImageOrColorPreviewManager.class);
    private static final Key<KeyListener> EDITOR_LISTENER_ADDED = Key.create((String)"previewManagerListenerAdded");
    private final Alarm alarm = new Alarm();
    @Nullable
    private Collection<PsiElement> myElements;

    ImageOrColorPreviewManager() {
    }

    public void editorCreated(@NotNull EditorFactoryEvent event) {
        this.registerListeners(event.getEditor());
    }

    public void editorReleased(@NotNull EditorFactoryEvent event) {
        Editor editor = event.getEditor();
        if (editor.isOneLineMode()) {
            return;
        }
        KeyListener keyListener = (KeyListener)EDITOR_LISTENER_ADDED.get((UserDataHolder)editor);
        if (keyListener != null) {
            EDITOR_LISTENER_ADDED.set((UserDataHolder)editor, null);
            editor.getContentComponent().removeKeyListener(keyListener);
            editor.removeEditorMouseMotionListener((EditorMouseMotionListener)this);
        }
    }

    private void registerListeners(final Editor editor) {
        if (editor.isOneLineMode()) {
            return;
        }
        Project project = editor.getProject();
        if (project == null || project.isDisposed()) {
            return;
        }
        PsiFile psiFile = PsiDocumentManager.getInstance((Project)project).getPsiFile(editor.getDocument());
        if (psiFile == null || psiFile instanceof PsiCompiledElement || !ImageOrColorPreviewManager.isSupportedFile(psiFile)) {
            return;
        }
        editor.addEditorMouseMotionListener((EditorMouseMotionListener)this);
        KeyAdapter keyListener = new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                PointerInfo pointerInfo;
                if (e.getKeyCode() == 16 && !editor.isOneLineMode() && (pointerInfo = MouseInfo.getPointerInfo()) != null) {
                    Point location = pointerInfo.getLocation();
                    SwingUtilities.convertPointFromScreen(location, editor.getContentComponent());
                    int offset = editor.logicalPositionToOffset(editor.xyToLogicalPosition(location));
                    ImageOrColorPreviewManager.this.alarm.cancelAllRequests();
                    ImageOrColorPreviewManager.this.alarm.addRequest((Runnable)new PreviewRequest(editor, offset, true), 100);
                }
            }
        };
        editor.getContentComponent().addKeyListener(keyListener);
        EDITOR_LISTENER_ADDED.set((UserDataHolder)editor, (Object)keyListener);
    }

    private static boolean isSupportedFile(PsiFile psiFile) {
        for (PsiFile file2 : psiFile.getViewProvider().getAllFiles()) {
            for (ElementPreviewProvider provider : ElementPreviewProvider.EP_NAME.getExtensionList()) {
                if (!provider.isSupportedFile(file2)) continue;
                return true;
            }
        }
        return false;
    }

    @NotNull
    private static Collection<PsiElement> getPsiElementsAt(Editor editor, int offset) {
        Document document;
        if (editor.isDisposed()) {
            return Collections.emptySet();
        }
        Project project = editor.getProject();
        if (project == null || project.isDisposed()) {
            return Collections.emptySet();
        }
        PsiDocumentManager documentManager = PsiDocumentManager.getInstance((Project)project);
        PsiFile psiFile = documentManager.getPsiFile(document = editor.getDocument());
        if (psiFile == null || psiFile instanceof PsiCompiledElement || !psiFile.isValid()) {
            return Collections.emptySet();
        }
        Set elements2 = ContainerUtil.createWeakSet();
        if (documentManager.isCommitted(document)) {
            ContainerUtil.addIfNotNull((Collection)elements2, (Object)InjectedLanguageUtil.findElementAtNoCommit(psiFile, offset));
        }
        for (PsiFile file2 : psiFile.getViewProvider().getAllFiles()) {
            ContainerUtil.addIfNotNull((Collection)elements2, (Object)file2.findElementAt(offset));
        }
        return elements2;
    }

    public void dispose() {
        this.alarm.cancelAllRequests();
        this.myElements = null;
    }

    public void mouseMoved(@NotNull EditorMouseEvent event) {
        Editor editor = event.getEditor();
        if (editor.isOneLineMode()) {
            return;
        }
        this.alarm.cancelAllRequests();
        Collection<PsiElement> elements2 = this.myElements;
        if (elements2 == null && event.getMouseEvent().isShiftDown()) {
            this.alarm.addRequest((Runnable)new PreviewRequest(editor, event.getOffset(), false), 100);
        } else if (elements2 != null && !ImageOrColorPreviewManager.getPsiElementsAt(editor, event.getOffset()).equals(elements2)) {
            this.myElements = null;
            for (ElementPreviewProvider provider : ElementPreviewProvider.EP_NAME.getExtensionList()) {
                try {
                    for (PsiElement element2 : elements2) {
                        provider.hide(element2, editor);
                    }
                }
                catch (Exception e) {
                    LOG.error((Throwable)e);
                }
            }
        }
    }

    private final class PreviewRequest
    implements Runnable {
        private final Editor editor;
        private final int offset;
        private final boolean keyTriggered;

        PreviewRequest(Editor editor, int offset, boolean keyTriggered) {
            this.editor = editor;
            this.offset = offset;
            this.keyTriggered = keyTriggered;
        }

        @Override
        public void run() {
            Collection elements2 = ImageOrColorPreviewManager.getPsiElementsAt(this.editor, this.offset);
            if (elements2.equals(ImageOrColorPreviewManager.this.myElements)) {
                return;
            }
            for (PsiElement element2 : elements2) {
                if (element2 == null || !element2.isValid()) {
                    return;
                }
                if (PsiDocumentManager.getInstance((Project)element2.getProject()).isUncommited(this.editor.getDocument()) || DumbService.getInstance((Project)element2.getProject()).isDumb()) {
                    return;
                }
                for (ElementPreviewProvider provider : (ElementPreviewProvider[])ElementPreviewProvider.EP_NAME.getExtensions()) {
                    if (!provider.isSupportedFile(element2.getContainingFile())) continue;
                    try {
                        provider.show(element2, this.editor, this.editor.offsetToXY(this.offset), this.keyTriggered);
                    }
                    catch (ProcessCanceledException e) {
                        throw e;
                    }
                    catch (Exception e) {
                        LOG.error((Throwable)e);
                    }
                }
            }
            ImageOrColorPreviewManager.this.myElements = elements2;
        }
    }
}

