/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.preview;

import com.intellij.codeInsight.hint.HintManagerImpl;
import com.intellij.codeInsight.preview.ElementPreviewProvider;
import com.intellij.codeInsight.preview.PreviewHintProvider;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.ui.LightweightHint;
import java.awt.Point;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ElementPreviewHintProvider
implements ElementPreviewProvider {
    private static final Logger LOG = Logger.getInstance(ElementPreviewHintProvider.class);
    private static final int HINT_HIDE_FLAGS = 122;
    @Nullable
    private LightweightHint hint;

    public boolean isSupportedFile(@NotNull PsiFile psiFile) {
        for (PreviewHintProvider hintProvider : PreviewHintProvider.EP_NAME.getExtensionList()) {
            if (!hintProvider.isSupportedFile(psiFile)) continue;
            return true;
        }
        return false;
    }

    public void show(@NotNull PsiElement element2, @NotNull Editor editor, @NotNull Point point, boolean keyTriggered) {
        LightweightHint newHint = ElementPreviewHintProvider.getHint(element2);
        this.hideCurrentHintIfAny();
        if (newHint == null) {
            return;
        }
        this.hint = newHint;
        HintManagerImpl.getInstanceImpl().showEditorHint(newHint, editor, HintManagerImpl.getHintPosition(newHint, editor, editor.xyToLogicalPosition(point), (short)5), 122, 0, false);
    }

    private void hideCurrentHintIfAny() {
        if (this.hint != null) {
            this.hint.hide();
            this.hint = null;
        }
    }

    public void hide(@Nullable PsiElement element2, @NotNull Editor editor) {
        this.hideCurrentHintIfAny();
    }

    @Nullable
    private static LightweightHint getHint(@NotNull PsiElement element2) {
        for (PreviewHintProvider hintProvider : PreviewHintProvider.EP_NAME.getExtensionList()) {
            JComponent preview;
            try {
                preview = hintProvider.getPreviewComponent(element2);
            }
            catch (ProcessCanceledException e) {
                throw e;
            }
            catch (Exception e) {
                LOG.error((Throwable)e);
                continue;
            }
            if (preview == null) continue;
            return new LightweightHint(preview);
        }
        return null;
    }
}

