/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.navigation;

import com.intellij.ide.util.DefaultPsiElementCellRenderer;
import com.intellij.ide.util.EditSourceUtil;
import com.intellij.ide.util.PsiElementListCellRenderer;
import com.intellij.navigation.GotoRelatedItem;
import com.intellij.navigation.GotoRelatedProvider;
import com.intellij.navigation.NavigationItem;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.command.CommandProcessor;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.ex.MarkupModelEx;
import com.intellij.openapi.editor.ex.RangeHighlighterEx;
import com.intellij.openapi.editor.ex.util.EditorUtil;
import com.intellij.openapi.editor.impl.DocumentMarkupModel;
import com.intellij.openapi.editor.markup.HighlighterTargetArea;
import com.intellij.openapi.editor.markup.MarkupModel;
import com.intellij.openapi.editor.markup.TextAttributes;
import com.intellij.openapi.fileEditor.FileEditor;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.fileEditor.TextEditor;
import com.intellij.openapi.fileEditor.impl.EditorHistoryManager;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.INativeFileType;
import com.intellij.openapi.fileTypes.UnknownFileType;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.popup.IPopupChooserBuilder;
import com.intellij.openapi.ui.popup.JBPopup;
import com.intellij.openapi.ui.popup.JBPopupFactory;
import com.intellij.openapi.ui.popup.ListPopupStep;
import com.intellij.openapi.ui.popup.ListSeparator;
import com.intellij.openapi.ui.popup.PopupChooserBuilder;
import com.intellij.openapi.ui.popup.PopupStep;
import com.intellij.openapi.ui.popup.util.BaseListPopupStep;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.pom.Navigatable;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.search.PsiElementProcessor;
import com.intellij.ui.ColoredListCellRenderer;
import com.intellij.ui.JBColor;
import com.intellij.ui.SeparatorWithText;
import com.intellij.ui.SimpleTextAttributes;
import com.intellij.ui.popup.list.ListPopupImpl;
import com.intellij.ui.popup.list.PopupListElementRenderer;
import com.intellij.util.Processor;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.ui.JBUI;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.DefaultListCellRenderer;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.KeyStroke;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class NavigationUtil {
    private NavigationUtil() {
    }

    @NotNull
    public static JBPopup getPsiElementPopup(PsiElement @NotNull [] elements2, @NlsContexts.PopupTitle String title) {
        return NavigationUtil.getPsiElementPopup(elements2, new DefaultPsiElementCellRenderer(), title);
    }

    @NotNull
    public static JBPopup getPsiElementPopup(PsiElement @NotNull [] elements2, @NotNull PsiElementListCellRenderer<? super PsiElement> renderer, @NlsContexts.PopupTitle String title) {
        return NavigationUtil.getPsiElementPopup((PsiElement[])elements2, renderer, (String)title, element2 -> {
            Navigatable descriptor2 = EditSourceUtil.getDescriptor((PsiElement)element2);
            if (descriptor2 != null && descriptor2.canNavigate()) {
                descriptor2.navigate(true);
            }
            return true;
        });
    }

    @NotNull
    public static <T extends PsiElement> JBPopup getPsiElementPopup(T @NotNull [] elements2, @NotNull PsiElementListCellRenderer<? super T> renderer, @NlsContexts.PopupTitle String title, @NotNull PsiElementProcessor<? super T> processor2) {
        return NavigationUtil.getPsiElementPopup(elements2, renderer, (String)title, processor2, null);
    }

    @NotNull
    public static <T extends PsiElement> JBPopup getPsiElementPopup(T @NotNull [] elements2, @NotNull PsiElementListCellRenderer<? super T> renderer, @Nullable @NlsContexts.PopupTitle String title, @NotNull PsiElementProcessor<? super T> processor2, @Nullable T initialSelection) {
        assert (elements2.length > 0) : "Attempted to show a navigation popup with zero elements";
        IPopupChooserBuilder builder2 = JBPopupFactory.getInstance().createPopupChooserBuilder((List)ContainerUtil.newArrayList((Object[])elements2)).setRenderer(renderer).setFont(EditorUtil.getEditorFont()).withHintUpdateSupply();
        if (initialSelection != null) {
            builder2.setSelectedValue(initialSelection, true);
        }
        if (title != null) {
            builder2.setTitle(title);
        }
        renderer.installSpeedSearch(builder2, true);
        JBPopup popup2 = builder2.setItemsChosenCallback(selectedValues -> {
            for (PsiElement element2 : selectedValues) {
                if (element2 == null) continue;
                processor2.execute(element2);
            }
        }).createPopup();
        if (builder2 instanceof PopupChooserBuilder) {
            JScrollPane pane2 = ((PopupChooserBuilder)builder2).getScrollPane();
            pane2.setBorder(null);
            pane2.setViewportBorder(null);
        }
        NavigationUtil.hidePopupIfDumbModeStarts(popup2, elements2[0].getProject());
        return popup2;
    }

    public static void hidePopupIfDumbModeStarts(final @NotNull JBPopup popup2, @NotNull Project project) {
        if (!DumbService.isDumb((Project)project)) {
            project.getMessageBus().connect((Disposable)popup2).subscribe(DumbService.DUMB_MODE, (Object)new DumbService.DumbModeListener(){

                public void enteredDumbMode() {
                    popup2.cancel();
                }
            });
        }
    }

    public static boolean activateFileWithPsiElement(@NotNull PsiElement elt) {
        return NavigationUtil.activateFileWithPsiElement(elt, true);
    }

    public static boolean activateFileWithPsiElement(@NotNull PsiElement elt, boolean searchForOpen) {
        return NavigationUtil.openFileWithPsiElement(elt, searchForOpen, true);
    }

    public static boolean openFileWithPsiElement(PsiElement element2, boolean searchForOpen, boolean requestFocus) {
        VirtualFile virtualFile;
        boolean openAsNative = false;
        if (element2 instanceof PsiFile && (virtualFile = ((PsiFile)element2).getVirtualFile()) != null) {
            FileType type = virtualFile.getFileType();
            boolean bl = openAsNative = type instanceof INativeFileType || type instanceof UnknownFileType;
        }
        if (searchForOpen) {
            element2.putUserData(FileEditorManager.USE_CURRENT_WINDOW, null);
        } else {
            element2.putUserData(FileEditorManager.USE_CURRENT_WINDOW, (Object)true);
        }
        Ref resultRef = new Ref();
        boolean openAsNativeFinal = openAsNative;
        CommandProcessor.getInstance().executeCommand(element2.getProject(), () -> {
            if (openAsNativeFinal || !NavigationUtil.activatePsiElementIfOpen(element2, searchForOpen, requestFocus)) {
                NavigationItem navigationItem = (NavigationItem)element2;
                if (!navigationItem.canNavigate()) {
                    resultRef.set((Object)Boolean.FALSE);
                } else {
                    navigationItem.navigate(requestFocus);
                    resultRef.set((Object)Boolean.TRUE);
                }
            }
        }, "", null);
        if (!resultRef.isNull()) {
            return (Boolean)resultRef.get();
        }
        element2.putUserData(FileEditorManager.USE_CURRENT_WINDOW, null);
        return false;
    }

    private static boolean activatePsiElementIfOpen(@NotNull PsiElement elt, boolean searchForOpen, boolean requestFocus) {
        FileEditor[] editors;
        TextRange range2;
        if (!elt.isValid()) {
            return false;
        }
        PsiFile file2 = (elt = elt.getNavigationElement()).getContainingFile();
        if (file2 == null || !file2.isValid()) {
            return false;
        }
        VirtualFile vFile = file2.getVirtualFile();
        if (vFile == null) {
            return false;
        }
        if (!EditorHistoryManager.getInstance(elt.getProject()).hasBeenOpen(vFile)) {
            return false;
        }
        FileEditorManager fem = FileEditorManager.getInstance((Project)elt.getProject());
        if (!fem.isFileOpen(vFile)) {
            fem.openFile(vFile, requestFocus, searchForOpen);
        }
        if ((range2 = elt.getTextRange()) == null) {
            return false;
        }
        for (FileEditor editor : editors = fem.getEditors(vFile)) {
            Editor text;
            int offset;
            if (!(editor instanceof TextEditor) || !range2.containsOffset(offset = (text = ((TextEditor)editor).getEditor()).getCaretModel().getOffset())) continue;
            fem.openFile(vFile, requestFocus, searchForOpen);
            return true;
        }
        return false;
    }

    public static TextAttributes patchAttributesColor(TextAttributes attributes, @NotNull TextRange range2, @NotNull Editor editor) {
        if (attributes.getForegroundColor() == null && attributes.getEffectColor() == null) {
            return attributes;
        }
        MarkupModel model = DocumentMarkupModel.forDocument(editor.getDocument(), editor.getProject(), false);
        if (model != null && !((MarkupModelEx)model).processRangeHighlightersOverlappingWith(range2.getStartOffset(), range2.getEndOffset(), (Processor<? super RangeHighlighterEx>)((Processor)highlighter -> {
            TextAttributes textAttributes;
            if (highlighter.isValid() && highlighter.getTargetArea() == HighlighterTargetArea.LINES_IN_RANGE && (textAttributes = highlighter.getTextAttributes(editor.getColorsScheme())) != null) {
                Color color = textAttributes.getBackgroundColor();
                return color == null || color.getBlue() <= 128 || color.getRed() >= 128 || color.getGreen() >= 128;
            }
            return true;
        }))) {
            TextAttributes clone = attributes.clone();
            clone.setForegroundColor(Color.orange);
            clone.setEffectColor(Color.orange);
            return clone;
        }
        return attributes;
    }

    @NotNull
    public static JBPopup getRelatedItemsPopup(List<? extends GotoRelatedItem> items, @NlsContexts.PopupTitle String title) {
        return NavigationUtil.getRelatedItemsPopup(items, title, false);
    }

    @NotNull
    public static JBPopup getRelatedItemsPopup(List<? extends GotoRelatedItem> items, @NlsContexts.PopupTitle String title, boolean showContainingModules) {
        ArrayList<Object> elements2 = new ArrayList<Object>(items.size());
        HashMap<PsiElement, GotoRelatedItem> itemsMap = new HashMap<PsiElement, GotoRelatedItem>();
        for (GotoRelatedItem gotoRelatedItem : items) {
            if (gotoRelatedItem.getElement() != null) {
                if (itemsMap.putIfAbsent(gotoRelatedItem.getElement(), gotoRelatedItem) != null) continue;
                elements2.add(gotoRelatedItem.getElement());
                continue;
            }
            elements2.add(gotoRelatedItem);
        }
        return NavigationUtil.getPsiElementPopup(elements2, itemsMap, title, showContainingModules, (Processor<Object>)((Processor)element2 -> {
            if (element2 instanceof PsiElement) {
                ((GotoRelatedItem)itemsMap.get(element2)).navigate();
            } else {
                ((GotoRelatedItem)element2).navigate();
            }
            return true;
        }));
    }

    private static JBPopup getPsiElementPopup(final List<Object> elements2, final Map<PsiElement, GotoRelatedItem> itemsMap, String title, final boolean showContainingModules, final Processor<Object> processor2) {
        final Ref hasMnemonic = Ref.create((Object)false);
        final DefaultPsiElementCellRenderer renderer = new DefaultPsiElementCellRenderer(){
            {
                this.setFocusBorderEnabled(false);
            }

            @Override
            public String getElementText(PsiElement element2) {
                String customName = ((GotoRelatedItem)itemsMap.get(element2)).getCustomName();
                return customName != null ? customName : super.getElementText(element2);
            }

            @Override
            protected Icon getIcon(PsiElement element2) {
                Icon customIcon = ((GotoRelatedItem)itemsMap.get(element2)).getCustomIcon();
                return customIcon != null ? customIcon : super.getIcon(element2);
            }

            @Override
            public String getContainerText(PsiElement element2, String name) {
                String customContainerName = ((GotoRelatedItem)itemsMap.get(element2)).getCustomContainerName();
                if (customContainerName != null) {
                    return customContainerName;
                }
                PsiFile file2 = element2.getContainingFile();
                return file2 != null && !this.getElementText(element2).equals(file2.getName()) ? "(" + file2.getName() + ")" : null;
            }

            @Override
            protected DefaultListCellRenderer getRightCellRenderer(Object value2) {
                return showContainingModules ? super.getRightCellRenderer(value2) : null;
            }

            @Override
            protected boolean customizeNonPsiElementLeftRenderer(ColoredListCellRenderer renderer, JList list2, Object value2, int index, boolean selected2, boolean hasFocus) {
                GotoRelatedItem item = (GotoRelatedItem)value2;
                Color color = list2.getForeground();
                SimpleTextAttributes nameAttributes = new SimpleTextAttributes(0, color);
                String name = item.getCustomName();
                if (name == null) {
                    return false;
                }
                renderer.append(name, nameAttributes);
                renderer.setIcon(item.getCustomIcon());
                return true;
            }

            @Override
            public Component getListCellRendererComponent(JList list2, Object value2, int index, boolean isSelected, boolean cellHasFocus) {
                JPanel component2 = (JPanel)super.getListCellRendererComponent(list2, value2, index, isSelected, cellHasFocus);
                if (!((Boolean)hasMnemonic.get()).booleanValue()) {
                    return component2;
                }
                JPanel panelWithMnemonic = new JPanel(new BorderLayout());
                int mnemonic = NavigationUtil.getMnemonic(value2, itemsMap);
                JLabel label2 = new JLabel("");
                if (mnemonic != -1) {
                    label2.setText(mnemonic + ".");
                    label2.setDisplayedMnemonicIndex(0);
                }
                label2.setPreferredSize(new JLabel("8.").getPreferredSize());
                JComponent leftRenderer = (JComponent)component2.getComponents()[0];
                component2.remove(leftRenderer);
                panelWithMnemonic.setBorder(BorderFactory.createEmptyBorder(0, 7, 0, 0));
                panelWithMnemonic.setBackground(leftRenderer.getBackground());
                label2.setBackground(leftRenderer.getBackground());
                panelWithMnemonic.add((Component)label2, "West");
                panelWithMnemonic.add((Component)leftRenderer, "Center");
                component2.add(panelWithMnemonic);
                return component2;
            }
        };
        ListPopupImpl popup2 = new ListPopupImpl((ListPopupStep)new BaseListPopupStep<Object>(title, elements2){
            final Map<Object, ListSeparator> separators;
            {
                super(x0, x1);
                this.separators = new HashMap<Object, ListSeparator>();
                String current2 = null;
                boolean hasTitle = false;
                for (Object element2 : elements2) {
                    GotoRelatedItem item = (GotoRelatedItem)itemsMap.get(element2);
                    if (item == null || StringUtil.equals(current2, (CharSequence)item.getGroup())) continue;
                    current2 = item.getGroup();
                    this.separators.put(element2, new ListSeparator(hasTitle && StringUtil.isEmpty((String)current2) ? "Other" : current2));
                    if (hasTitle || StringUtil.isEmpty((String)current2)) continue;
                    hasTitle = true;
                }
                if (!hasTitle) {
                    this.separators.remove(elements2.get(0));
                }
            }

            public boolean isSpeedSearchEnabled() {
                return true;
            }

            public String getIndexedString(Object value2) {
                if (value2 instanceof GotoRelatedItem) {
                    return ((GotoRelatedItem)value2).getCustomName();
                }
                PsiElement element2 = (PsiElement)value2;
                if (!element2.isValid()) {
                    return "INVALID";
                }
                return renderer.getElementText(element2) + " " + renderer.getContainerText(element2, (String)null);
            }

            public PopupStep onChosen(Object selectedValue, boolean finalChoice) {
                processor2.process(selectedValue);
                return super.onChosen(selectedValue, finalChoice);
            }

            @Nullable
            public ListSeparator getSeparatorAbove(Object value2) {
                return this.separators.get(value2);
            }
        }){};
        popup2.getList().setCellRenderer(new PopupListElementRenderer<Object>(popup2){

            @Override
            public Component getListCellRendererComponent(JList list2, Object value2, int index, boolean isSelected, boolean cellHasFocus) {
                Component component2 = renderer.getListCellRendererComponent(list2, value2, index, isSelected, cellHasFocus);
                if (this.myDescriptor.hasSeparatorAboveOf(value2)) {
                    JPanel panel2 = new JPanel(new BorderLayout());
                    panel2.add(component2, "Center");
                    SeparatorWithText sep = new SeparatorWithText(){

                        protected void paintComponent(Graphics g) {
                            g.setColor((Color)new JBColor(Color.WHITE, JBUI.CurrentTheme.CustomFrameDecorations.separatorForeground()));
                            g.fillRect(0, 0, this.getWidth(), this.getHeight());
                            super.paintComponent(g);
                        }
                    };
                    sep.setCaption(this.myDescriptor.getCaptionAboveOf(value2));
                    panel2.add((Component)sep, "North");
                    return panel2;
                }
                return component2;
            }
        });
        popup2.setMinimumSize(new Dimension(200, -1));
        for (Object item : elements2) {
            int mnemonic = NavigationUtil.getMnemonic(item, itemsMap);
            if (mnemonic == -1) continue;
            Action action2 = NavigationUtil.createNumberAction(mnemonic, popup2, itemsMap, processor2);
            popup2.registerAction(mnemonic + "Action", KeyStroke.getKeyStroke(String.valueOf(mnemonic)), action2);
            popup2.registerAction(mnemonic + "Action", KeyStroke.getKeyStroke("NUMPAD" + mnemonic), action2);
            hasMnemonic.set((Object)true);
        }
        return popup2;
    }

    private static Action createNumberAction(final int mnemonic, final ListPopupImpl listPopup, final Map<PsiElement, GotoRelatedItem> itemsMap, final Processor<Object> processor2) {
        return new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                for (Object item : listPopup.getListStep().getValues()) {
                    if (NavigationUtil.getMnemonic(item, itemsMap) != mnemonic) continue;
                    listPopup.setFinalRunnable(() -> processor2.process(item));
                    listPopup.closeOk(null);
                }
            }
        };
    }

    private static int getMnemonic(Object item, Map<PsiElement, GotoRelatedItem> itemsMap) {
        return (item instanceof GotoRelatedItem ? (GotoRelatedItem)item : itemsMap.get((PsiElement)item)).getMnemonic();
    }

    @NotNull
    public static List<GotoRelatedItem> collectRelatedItems(@NotNull PsiElement contextElement, @Nullable DataContext dataContext) {
        LinkedHashSet items = new LinkedHashSet();
        for (GotoRelatedProvider provider : GotoRelatedProvider.EP_NAME.getExtensionList()) {
            items.addAll(provider.getItems(contextElement));
            if (dataContext == null) continue;
            items.addAll(provider.getItems(dataContext));
        }
        GotoRelatedItem[] result2 = items.toArray(new GotoRelatedItem[0]);
        Arrays.sort(result2, (i1, i2) -> {
            String o1 = i1.getGroup();
            String o2 = i2.getGroup();
            return StringUtil.isEmpty((String)o1) ? 1 : (StringUtil.isEmpty((String)o2) ? -1 : o1.compareTo(o2));
        });
        return Arrays.asList(result2);
    }
}

