/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.lookup.impl;

import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.codeInsight.lookup.LookupElementPresentation;
import com.intellij.codeInsight.lookup.LookupElementRenderer;
import com.intellij.codeInsight.lookup.impl.LookupImpl;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.Ref;
import com.intellij.util.SingleAlarm;
import com.intellij.util.concurrency.SequentialTaskExecutor;
import com.intellij.util.indexing.DumbModeAccessType;
import com.intellij.util.indexing.FileBasedIndex;
import java.util.Objects;
import java.util.concurrent.Executor;
import java.util.concurrent.atomic.AtomicBoolean;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.concurrency.CancellablePromise;

@ApiStatus.Internal
public class AsyncRendering {
    private static final Key<LookupElementPresentation> LAST_COMPUTED_PRESENTATION = Key.create((String)"LAST_COMPUTED_PRESENTATION");
    private static final Key<CancellablePromise<?>> LAST_COMPUTATION = Key.create((String)"LAST_COMPUTATION");
    private static final Executor ourExecutor = SequentialTaskExecutor.createSequentialApplicationPoolExecutor((String)"ExpensiveRendering");
    private final LookupImpl myLookup;
    private final SingleAlarm myAlarm;
    private final AtomicBoolean myToResize = new AtomicBoolean();

    AsyncRendering(LookupImpl lookup2) {
        this.myLookup = lookup2;
        this.myAlarm = new SingleAlarm(() -> {
            if (this.myToResize.compareAndSet(true, false)) {
                this.myLookup.requestResize();
            }
            this.myLookup.refreshUi(false, false);
        }, 50);
        Disposer.register((Disposable)lookup2, () -> {
            SingleAlarm singleAlarm = this.myAlarm;
            synchronized (singleAlarm) {
                Disposer.dispose((Disposable)this.myAlarm);
            }
        });
    }

    @NotNull
    LookupElementPresentation getLastComputed(@NotNull LookupElement element2) {
        return (LookupElementPresentation)Objects.requireNonNull(element2.getUserData(LAST_COMPUTED_PRESENTATION));
    }

    static void rememberPresentation(LookupElement element2, LookupElementPresentation presentation2) {
        element2.putUserData(LAST_COMPUTED_PRESENTATION, (Object)presentation2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void scheduleRendering(@NotNull LookupElement element2, @NotNull LookupElementRenderer<?> renderer) {
        Key<CancellablePromise<?>> key = LAST_COMPUTATION;
        synchronized (key) {
            AsyncRendering.cancelRendering(element2);
            Ref promiseRef = Ref.create();
            CancellablePromise promise = ReadAction.nonBlocking(() -> {
                if (element2.isValid()) {
                    this.renderInBackground(element2, renderer);
                }
                Key<CancellablePromise<?>> key = LAST_COMPUTATION;
                synchronized (key) {
                    element2.replace(LAST_COMPUTATION, promiseRef.get(), null);
                }
            }).expireWith((Disposable)this.myLookup).submit(ourExecutor);
            element2.putUserData(LAST_COMPUTATION, (Object)promise);
            promiseRef.set((Object)promise);
        }
    }

    private void renderInBackground(LookupElement element2, LookupElementRenderer renderer) {
        LookupElementPresentation presentation2 = new LookupElementPresentation();
        FileBasedIndex.getInstance().ignoreDumbMode(() -> renderer.renderElement(element2, presentation2), DumbModeAccessType.RELIABLE_DATA_ONLY);
        AsyncRendering.rememberPresentation(element2, presentation2);
        this.scheduleLookupUpdate(element2, presentation2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void scheduleLookupUpdate(LookupElement element2, LookupElementPresentation presentation2) {
        if (this.myLookup.myCellRenderer.updateLookupWidth(element2, presentation2)) {
            this.myToResize.set(true);
        }
        SingleAlarm singleAlarm = this.myAlarm;
        synchronized (singleAlarm) {
            if (!this.myAlarm.isDisposed()) {
                this.myAlarm.request();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void cancelRendering(@NotNull LookupElement item) {
        Key<CancellablePromise<?>> key = LAST_COMPUTATION;
        synchronized (key) {
            CancellablePromise promise = (CancellablePromise)item.getUserData(LAST_COMPUTATION);
            if (promise != null) {
                promise.cancel();
                item.putUserData(LAST_COMPUTATION, null);
            }
        }
    }
}

