/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.intention.impl.config;

import com.intellij.codeInsight.daemon.HighlightDisplayKey;
import com.intellij.codeInsight.daemon.impl.CleanupOnScopeIntention;
import com.intellij.codeInsight.daemon.impl.EditCleanupProfileIntentionAction;
import com.intellij.codeInsight.intention.FileModifier;
import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.codeInsight.intention.IntentionActionBean;
import com.intellij.codeInsight.intention.IntentionActionDelegate;
import com.intellij.codeInsight.intention.IntentionManager;
import com.intellij.codeInsight.intention.impl.config.IntentionActionWrapper;
import com.intellij.codeInsight.intention.impl.config.IntentionManagerSettings;
import com.intellij.codeInsight.intention.impl.config.LazyEditor;
import com.intellij.codeInspection.GlobalInspectionTool;
import com.intellij.codeInspection.GlobalSimpleInspectionTool;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.actions.CleanupAllIntention;
import com.intellij.codeInspection.actions.CleanupInspectionIntention;
import com.intellij.codeInspection.actions.RunInspectionIntention;
import com.intellij.codeInspection.ex.DisableInspectionToolAction;
import com.intellij.codeInspection.ex.EditInspectionToolsSettingsAction;
import com.intellij.codeInspection.ex.EditInspectionToolsSettingsInSuppressedPlaceIntention;
import com.intellij.codeInspection.ex.GlobalInspectionToolWrapper;
import com.intellij.codeInspection.ex.InspectionToolWrapper;
import com.intellij.codeInspection.ex.LocalInspectionToolWrapper;
import com.intellij.codeInspection.ex.QuickFixWrapper;
import com.intellij.ide.plugins.PluginManager;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.extensions.ExtensionPointListener;
import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.openapi.extensions.PluginDescriptor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.SmartList;
import com.intellij.util.ThrowableRunnable;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.atomic.AtomicReference;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class IntentionManagerImpl
extends IntentionManager
implements Disposable {
    private static final Logger LOG = Logger.getInstance(IntentionManagerImpl.class);
    public static final ExtensionPointName<IntentionActionBean> EP_INTENTION_ACTIONS = new ExtensionPointName("com.intellij.intentionAction");
    private final List<IntentionAction> myActions;
    private final AtomicReference<ScheduledFuture<?>> myScheduledFuture = new AtomicReference();
    private boolean myIntentionsDisabled;
    private boolean checkedForDuplicates;

    public IntentionManagerImpl() {
        ArrayList<EditInspectionToolsSettingsInSuppressedPlaceIntention> actions = new ArrayList<EditInspectionToolsSettingsInSuppressedPlaceIntention>(EP_INTENTION_ACTIONS.getPoint().size() + 1);
        actions.add(new EditInspectionToolsSettingsInSuppressedPlaceIntention());
        EP_INTENTION_ACTIONS.forEachExtensionSafe(extension -> actions.add((EditInspectionToolsSettingsInSuppressedPlaceIntention)((Object)new IntentionActionWrapper((IntentionActionBean)extension))));
        this.myActions = ContainerUtil.createLockFreeCopyOnWriteList(actions);
        EP_INTENTION_ACTIONS.addExtensionPointListener((ExtensionPointListener)new ExtensionPointListener<IntentionActionBean>(){

            public void extensionAdded(@NotNull IntentionActionBean extension, @NotNull PluginDescriptor pluginDescriptor) {
                IntentionManagerImpl.this.myActions.add(new IntentionActionWrapper(extension));
            }

            public void extensionRemoved(@NotNull IntentionActionBean extension, @NotNull PluginDescriptor pluginDescriptor) {
                IntentionManagerImpl.this.myActions.removeIf(wrapper2 -> wrapper2 instanceof IntentionActionWrapper && ((IntentionActionWrapper)wrapper2).getImplementationClassName().equals(extension.className));
            }
        }, (Disposable)this);
    }

    public void registerIntentionAndMetaData(@NotNull IntentionAction action2, String ... category) {
        this.addAction(action2);
        String descriptionDirectoryName = action2 instanceof IntentionActionWrapper ? ((IntentionActionWrapper)action2).getDescriptionDirectoryName() : IntentionActionWrapper.getDescriptionDirectoryName(action2.getClass().getName());
        IntentionManagerSettings settings = IntentionManagerSettings.getInstance();
        settings.registerIntentionMetaData(action2, category, descriptionDirectoryName);
    }

    public void unregisterIntention(@NotNull IntentionAction intentionAction) {
        this.myActions.remove(intentionAction);
        IntentionManagerSettings settings = IntentionManagerSettings.getInstance();
        settings.unregisterMetaData(intentionAction);
    }

    @NotNull
    public List<IntentionAction> getStandardIntentionOptions(@NotNull HighlightDisplayKey displayKey, @NotNull PsiElement context) {
        this.checkForDuplicates();
        ArrayList<IntentionAction> options2 = new ArrayList<IntentionAction>(9);
        options2.add(new EditInspectionToolsSettingsAction(displayKey));
        options2.add(new RunInspectionIntention(displayKey));
        options2.add((IntentionAction)new DisableInspectionToolAction(displayKey));
        return options2;
    }

    @Nullable
    public IntentionAction createFixAllIntention(@NotNull InspectionToolWrapper<?, ?> toolWrapper, @NotNull IntentionAction action2) {
        LocalInspectionToolWrapper localWrapper;
        this.checkForDuplicates();
        if (toolWrapper instanceof GlobalInspectionToolWrapper && (localWrapper = ((GlobalInspectionToolWrapper)((Object)toolWrapper)).getSharedLocalInspectionToolWrapper()) != null) {
            toolWrapper = localWrapper;
        }
        if (toolWrapper instanceof LocalInspectionToolWrapper) {
            return IntentionManagerImpl.createFixAllIntentionInternal(toolWrapper, action2);
        }
        if (toolWrapper instanceof GlobalInspectionToolWrapper) {
            GlobalInspectionTool wrappedTool = (GlobalInspectionTool)((GlobalInspectionToolWrapper)((Object)toolWrapper)).getTool();
            if (wrappedTool instanceof GlobalSimpleInspectionTool && (action2 instanceof LocalQuickFix || action2 instanceof QuickFixWrapper)) {
                return IntentionManagerImpl.createFixAllIntentionInternal(toolWrapper, action2);
            }
        } else {
            throw new AssertionError((Object)("unknown tool: " + (Object)((Object)toolWrapper)));
        }
        return null;
    }

    public void dispose() {
    }

    private static IntentionAction createFixAllIntentionInternal(@NotNull InspectionToolWrapper<?, ?> toolWrapper, @NotNull IntentionAction action2) {
        PsiFile file2 = null;
        IntentionAction fix = action2;
        if (action2 instanceof QuickFixWrapper) {
            fix = ((QuickFixWrapper)action2).getFix();
            file2 = ((QuickFixWrapper)action2).getFile();
        }
        return new CleanupInspectionIntention(toolWrapper, (FileModifier)fix, file2, action2.getText());
    }

    @NotNull
    public IntentionAction createCleanupAllIntention() {
        return CleanupAllIntention.INSTANCE;
    }

    @NotNull
    public List<IntentionAction> getCleanupIntentionOptions() {
        ArrayList<IntentionAction> options2 = new ArrayList<IntentionAction>();
        options2.add(EditCleanupProfileIntentionAction.INSTANCE);
        options2.add(CleanupOnScopeIntention.INSTANCE);
        return options2;
    }

    @NotNull
    public LocalQuickFix convertToFix(final @NotNull IntentionAction action2) {
        if (action2 instanceof LocalQuickFix) {
            return (LocalQuickFix)action2;
        }
        return new LocalQuickFix(){

            @NotNull
            public String getName() {
                return action2.getText();
            }

            @NotNull
            public String getFamilyName() {
                return action2.getFamilyName();
            }

            public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor2) {
                PsiFile psiFile = descriptor2.getPsiElement().getContainingFile();
                try {
                    action2.invoke(project, (Editor)new LazyEditor(psiFile), psiFile);
                }
                catch (IncorrectOperationException e) {
                    LOG.error((Throwable)e);
                }
            }
        };
    }

    public void addAction(@NotNull IntentionAction action2) {
        this.myActions.add(action2);
    }

    public IntentionAction @NotNull [] getIntentionActions() {
        if (this.myIntentionsDisabled) {
            return IntentionAction.EMPTY_ARRAY;
        }
        return this.myActions.toArray(IntentionAction.EMPTY_ARRAY);
    }

    @NotNull
    public List<IntentionAction> getAvailableIntentions() {
        if (this.myIntentionsDisabled) {
            return Collections.emptyList();
        }
        this.checkForDuplicates();
        ArrayList<IntentionAction> list2 = new ArrayList<IntentionAction>(this.myActions.size());
        IntentionManagerSettings settings = IntentionManagerSettings.getInstance();
        for (IntentionAction action2 : this.myActions) {
            if (!settings.isEnabled(action2)) continue;
            list2.add(action2);
        }
        return list2;
    }

    public void checkForDuplicates() {
        if (this.checkedForDuplicates) {
            return;
        }
        this.checkedForDuplicates = true;
        HashMap<String, List> map2 = new HashMap<String, List>(this.myActions.size());
        for (IntentionAction action2 : this.myActions) {
            map2.computeIfAbsent(action2 instanceof IntentionActionDelegate ? ((IntentionActionDelegate)action2).getImplementationClassName() : action2.getClass().getName(), k -> new SmartList()).add(action2);
        }
        ArrayList<String> duplicates = new ArrayList<String>();
        for (List list2 : map2.values()) {
            if (list2.size() <= 1) continue;
            duplicates.add(list2.size() + " intention duplicates found for " + IntentionActionDelegate.unwrap((IntentionAction)((IntentionAction)list2.get(0))) + " (" + ((IntentionAction)list2.get(0)).getClass() + "; plugin " + PluginManager.getInstance().getPluginOrPlatformByClassName(((IntentionAction)list2.get(0)).getClass().getName()) + ")");
        }
        if (!duplicates.isEmpty()) {
            throw new IllegalStateException(((Object)duplicates).toString());
        }
    }

    public boolean hasActiveRequests() {
        return this.myScheduledFuture.get() != null;
    }

    public <T extends Throwable> void withDisabledIntentions(ThrowableRunnable<T> runnable2) throws T {
        boolean oldIntentionsDisabled = this.myIntentionsDisabled;
        this.myIntentionsDisabled = true;
        try {
            runnable2.run();
        }
        finally {
            this.myIntentionsDisabled = oldIntentionsDisabled;
        }
    }
}

