/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.intention.impl;

import com.intellij.codeInsight.daemon.GutterMark;
import com.intellij.codeInsight.daemon.impl.HighlightInfo;
import com.intellij.codeInsight.daemon.impl.SeverityRegistrar;
import com.intellij.codeInsight.daemon.impl.ShowIntentionsPass;
import com.intellij.codeInsight.intention.EmptyIntentionAction;
import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.codeInsight.intention.impl.CachedIntentions;
import com.intellij.codeInsight.intention.impl.IntentionActionWithTextCaching;
import com.intellij.codeInsight.intention.impl.IntentionListStep;
import com.intellij.codeInsight.intention.impl.ShowIntentionActionsHandler;
import com.intellij.icons.AllIcons;
import com.intellij.lang.annotation.HighlightSeverity;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.popup.JBPopupFactory;
import com.intellij.openapi.ui.popup.ListPopup;
import com.intellij.openapi.ui.popup.ListPopupStep;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.SmartPointerManager;
import com.intellij.psi.SmartPsiElementPointer;
import com.intellij.ui.ClickListener;
import com.intellij.ui.EditorNotificationPanel;
import com.intellij.ui.LightColors;
import com.intellij.ui.awt.RelativePoint;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.event.MouseEvent;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class FileLevelIntentionComponent
extends EditorNotificationPanel {
    private final Project myProject;

    public FileLevelIntentionComponent(String description, @NotNull HighlightSeverity severity, @Nullable GutterMark gutterMark, final @Nullable List<Pair<HighlightInfo.IntentionActionDescriptor, TextRange>> intentions, final @NotNull Project project, @NotNull PsiFile psiFile, final @NotNull Editor editor, @Nullable String tooltip) {
        super(FileLevelIntentionComponent.getColor(project, severity));
        this.myProject = project;
        ShowIntentionsPass.IntentionsInfo info = new ShowIntentionsPass.IntentionsInfo();
        if (intentions != null) {
            for (Pair<HighlightInfo.IntentionActionDescriptor, TextRange> intention : intentions) {
                HighlightInfo.IntentionActionDescriptor descriptor2 = (HighlightInfo.IntentionActionDescriptor)intention.getFirst();
                info.intentionsToShow.add(descriptor2);
                IntentionAction action2 = descriptor2.getAction();
                if (action2 instanceof EmptyIntentionAction) continue;
                String text = action2.getText();
                this.createActionLabel(text, () -> {
                    PsiDocumentManager.getInstance((Project)this.myProject).commitAllDocuments();
                    ShowIntentionActionsHandler.chooseActionAndInvoke(psiFile, editor, action2, text);
                });
            }
        }
        this.myLabel.setText(description);
        this.myLabel.setToolTipText(tooltip);
        if (gutterMark != null) {
            this.myLabel.setIcon(gutterMark.getIcon());
        }
        if (intentions != null && !intentions.isEmpty()) {
            this.myGearLabel.setIcon(AllIcons.General.GearPlain);
            final SmartPsiElementPointer filePointer = SmartPointerManager.createPointer((PsiElement)psiFile);
            new ClickListener(){

                public boolean onClick(@NotNull MouseEvent e, int clickCount) {
                    PsiFile psiFile = (PsiFile)filePointer.getElement();
                    if (psiFile == null) {
                        return true;
                    }
                    CachedIntentions cachedIntentions = new CachedIntentions(project, psiFile, editor);
                    IntentionListStep step = new IntentionListStep(null, editor, psiFile, project, cachedIntentions);
                    HighlightInfo.IntentionActionDescriptor descriptor2 = (HighlightInfo.IntentionActionDescriptor)((Pair)intentions.get(0)).getFirst();
                    IntentionActionWithTextCaching actionWithTextCaching = cachedIntentions.wrapAction(descriptor2, (PsiElement)psiFile, psiFile, editor);
                    if (step.hasSubstep(actionWithTextCaching)) {
                        step = step.getSubStep(actionWithTextCaching, null);
                    }
                    ListPopup popup2 = JBPopupFactory.getInstance().createListPopup((ListPopupStep)step);
                    Dimension dimension = popup2.getContent().getPreferredSize();
                    Point at = new Point(-dimension.width + FileLevelIntentionComponent.this.myGearLabel.getWidth(), FileLevelIntentionComponent.this.getHeight());
                    popup2.show(new RelativePoint(e.getComponent(), at));
                    return true;
                }
            }.installOn((Component)this.myGearLabel);
        }
    }

    @NotNull
    private static Color getColor(@NotNull Project project, @NotNull HighlightSeverity severity) {
        if (SeverityRegistrar.getSeverityRegistrar(project).compare(severity, HighlightSeverity.ERROR) >= 0) {
            return LightColors.RED;
        }
        if (SeverityRegistrar.getSeverityRegistrar(project).compare(severity, HighlightSeverity.WARNING) >= 0) {
            return LightColors.YELLOW;
        }
        return LightColors.GREEN;
    }
}

