/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.hints;

import com.intellij.codeHighlighting.TextEditorHighlightingPass;
import com.intellij.codeHighlighting.TextEditorHighlightingPassFactory;
import com.intellij.codeHighlighting.TextEditorHighlightingPassFactoryRegistrar;
import com.intellij.codeHighlighting.TextEditorHighlightingPassRegistrar;
import com.intellij.codeInsight.hints.InlayParameterHintsExtension;
import com.intellij.codeInsight.hints.InlayParameterHintsProvider;
import com.intellij.codeInsight.hints.MethodInfoBlacklistFilter;
import com.intellij.codeInsight.hints.ParameterHintsPass;
import com.intellij.lang.Language;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.EditorFactory;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ParameterHintsPassFactory
implements TextEditorHighlightingPassFactory,
TextEditorHighlightingPassFactoryRegistrar {
    protected static final Key<Long> PSI_MODIFICATION_STAMP = Key.create((String)"psi.modification.stamp");

    @Override
    public void registerHighlightingPassFactory(@NotNull TextEditorHighlightingPassRegistrar registrar, @NotNull Project project) {
        registrar.registerTextEditorHighlightingPass((TextEditorHighlightingPassFactory)this, null, null, false, -1);
    }

    @Override
    @Nullable
    public TextEditorHighlightingPass createHighlightingPass(@NotNull PsiFile file2, @NotNull Editor editor) {
        if (editor.isOneLineMode()) {
            return null;
        }
        long currentStamp = ParameterHintsPassFactory.getCurrentModificationStamp(file2);
        Long savedStamp = (Long)editor.getUserData(PSI_MODIFICATION_STAMP);
        if (savedStamp != null && savedStamp == currentStamp) {
            return null;
        }
        Language language = file2.getLanguage();
        InlayParameterHintsProvider provider = (InlayParameterHintsProvider)InlayParameterHintsExtension.INSTANCE.forLanguage(language);
        if (provider == null) {
            return null;
        }
        return new ParameterHintsPass((PsiElement)file2, editor, MethodInfoBlacklistFilter.forLanguage(language), false);
    }

    public static long getCurrentModificationStamp(@NotNull PsiFile file2) {
        return file2.getManager().getModificationTracker().getModificationCount();
    }

    public static void forceHintsUpdateOnNextPass() {
        for (Editor editor : EditorFactory.getInstance().getAllEditors()) {
            ParameterHintsPassFactory.forceHintsUpdateOnNextPass(editor);
        }
    }

    public static void forceHintsUpdateOnNextPass(@NotNull Editor editor) {
        editor.putUserData(PSI_MODIFICATION_STAMP, null);
    }

    protected static void putCurrentPsiModificationStamp(@NotNull Editor editor, @NotNull PsiFile file2) {
        editor.putUserData(PSI_MODIFICATION_STAMP, (Object)ParameterHintsPassFactory.getCurrentModificationStamp(file2));
    }
}

