/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.highlighting;

import com.intellij.codeInsight.highlighting.BraceHighlightingHandler;
import com.intellij.codeInsight.highlighting.BraceMatcher;
import com.intellij.codeInsight.highlighting.FileTypeBraceMather;
import com.intellij.codeInsight.highlighting.PairedBraceMatcherAdapter;
import com.intellij.codeInsight.highlighting.XmlAwareBraceMatcher;
import com.intellij.ide.highlighter.custom.SyntaxTable;
import com.intellij.ide.highlighter.custom.impl.CustomFileTypeBraceMatcher;
import com.intellij.lang.Language;
import com.intellij.lang.LanguageBraceMatching;
import com.intellij.lang.PairedBraceMatcher;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.highlighter.EditorHighlighter;
import com.intellij.openapi.editor.highlighter.HighlighterIterator;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.LanguageFileType;
import com.intellij.openapi.fileTypes.impl.AbstractFileType;
import com.intellij.openapi.util.Comparing;
import com.intellij.psi.PsiFile;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.PsiUtilBase;
import com.intellij.util.containers.Stack;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class BraceMatchingUtil {
    public static final int UNDEFINED_TOKEN_GROUP = -1;

    private BraceMatchingUtil() {
    }

    public static boolean isPairedBracesAllowedBeforeTypeInFileType(@NotNull IElementType lbraceType, IElementType tokenType, @NotNull FileType fileType) {
        try {
            return BraceMatchingUtil.getBraceMatcher(fileType, lbraceType).isPairedBracesAllowedBeforeType(lbraceType, tokenType);
        }
        catch (AbstractMethodError abstractMethodError) {
            return true;
        }
    }

    public static int getMatchedBraceOffset(@NotNull Editor editor, boolean forward, @NotNull PsiFile file2) {
        Document document = editor.getDocument();
        int offset = editor.getCaretModel().getOffset();
        EditorHighlighter editorHighlighter = BraceHighlightingHandler.getLazyParsableHighlighterIfAny(file2.getProject(), editor, file2);
        HighlighterIterator iterator2 = editorHighlighter.createIterator(offset);
        boolean matched = BraceMatchingUtil.matchBrace(document.getCharsSequence(), file2.getFileType(), iterator2, forward);
        if (!matched) {
            throw new AssertionError();
        }
        return iterator2.getStart();
    }

    @Nullable
    public static BraceHighlightingAndNavigationContext computeHighlightingAndNavigationContext(@NotNull Editor editor, @NotNull PsiFile file2) {
        return BraceMatchingUtil.computeHighlightingAndNavigationContext(editor, file2, editor.getCaretModel().getOffset());
    }

    @Nullable
    public static BraceHighlightingAndNavigationContext computeHighlightingAndNavigationContext(@NotNull Editor editor, @NotNull PsiFile file2, int offset) {
        int preOffsetTokenStart;
        EditorHighlighter highlighter = BraceHighlightingHandler.getLazyParsableHighlighterIfAny(file2.getProject(), editor, file2);
        CharSequence text = editor.getDocument().getCharsSequence();
        HighlighterIterator iterator2 = highlighter.createIterator(offset);
        FileType fileType = iterator2.atEnd() ? null : BraceMatchingUtil.getFileType(file2, iterator2.getStart());
        boolean isBeforeOrInsideLeftBrace = fileType != null && BraceMatchingUtil.isLBraceToken(iterator2, text, fileType);
        boolean isBeforeOrInsideRightBrace = !isBeforeOrInsideLeftBrace && fileType != null && BraceMatchingUtil.isRBraceToken(iterator2, text, fileType);
        boolean isInsideBrace = (isBeforeOrInsideLeftBrace || isBeforeOrInsideRightBrace) && iterator2.getStart() < offset;
        HighlighterIterator preOffsetIterator = offset > 0 && !isInsideBrace ? highlighter.createIterator(offset - 1) : null;
        FileType preOffsetFileType = preOffsetIterator != null ? BraceMatchingUtil.getFileType(file2, preOffsetIterator.getStart()) : null;
        boolean isAfterLeftBrace = preOffsetIterator != null && BraceMatchingUtil.isLBraceToken(preOffsetIterator, text, preOffsetFileType);
        boolean isAfterRightBrace = !isAfterLeftBrace && preOffsetIterator != null && BraceMatchingUtil.isRBraceToken(preOffsetIterator, text, preOffsetFileType);
        int offsetTokenStart = iterator2.atEnd() ? -1 : iterator2.getStart();
        int n = preOffsetTokenStart = preOffsetIterator == null || preOffsetIterator.atEnd() ? -1 : preOffsetIterator.getStart();
        if (editor.getSettings().isBlockCursor()) {
            if (isBeforeOrInsideLeftBrace && BraceMatchingUtil.matchBrace(text, fileType, iterator2, true)) {
                return new BraceHighlightingAndNavigationContext(offsetTokenStart, iterator2.getStart(), isInsideBrace);
            }
            if (isBeforeOrInsideRightBrace && BraceMatchingUtil.matchBrace(text, fileType, iterator2, false)) {
                return new BraceHighlightingAndNavigationContext(offsetTokenStart, iterator2.getStart(), isInsideBrace);
            }
            if (isAfterRightBrace && BraceMatchingUtil.matchBrace(text, preOffsetFileType, preOffsetIterator, false)) {
                return new BraceHighlightingAndNavigationContext(preOffsetTokenStart, preOffsetIterator.getStart(), true);
            }
            if (isAfterLeftBrace && BraceMatchingUtil.matchBrace(text, preOffsetFileType, preOffsetIterator, true)) {
                return new BraceHighlightingAndNavigationContext(preOffsetTokenStart, preOffsetIterator.getStart(), true);
            }
        } else {
            if (isAfterRightBrace && BraceMatchingUtil.matchBrace(text, preOffsetFileType, preOffsetIterator, false)) {
                return new BraceHighlightingAndNavigationContext(preOffsetTokenStart, preOffsetIterator.getStart(), true);
            }
            if (isBeforeOrInsideLeftBrace && BraceMatchingUtil.matchBrace(text, fileType, iterator2, true)) {
                return new BraceHighlightingAndNavigationContext(offsetTokenStart, iterator2.getEnd(), isInsideBrace);
            }
            if (isAfterLeftBrace && BraceMatchingUtil.matchBrace(text, preOffsetFileType, preOffsetIterator, true)) {
                return new BraceHighlightingAndNavigationContext(preOffsetTokenStart, preOffsetIterator.getEnd(), true);
            }
            if (isBeforeOrInsideRightBrace && BraceMatchingUtil.matchBrace(text, fileType, iterator2, false)) {
                return new BraceHighlightingAndNavigationContext(offsetTokenStart, iterator2.getStart(), isInsideBrace);
            }
        }
        return null;
    }

    @NotNull
    public static FileType getFileType(PsiFile file2, int offset) {
        return PsiUtilBase.getPsiFileAtOffset((PsiFile)file2, (int)offset).getFileType();
    }

    public static synchronized boolean matchBrace(@NotNull CharSequence fileText, @NotNull FileType fileType, @NotNull HighlighterIterator iterator2, boolean forward) {
        return new MatchBraceContext(fileText, fileType, iterator2, forward).doBraceMatch();
    }

    public static synchronized boolean matchBrace(@NotNull CharSequence fileText, @NotNull FileType fileType, @NotNull HighlighterIterator iterator2, boolean forward, boolean isStrict) {
        return new MatchBraceContext(fileText, fileType, iterator2, forward, isStrict).doBraceMatch();
    }

    public static boolean findStructuralLeftBrace(@NotNull FileType fileType, @NotNull HighlighterIterator iterator2, @NotNull CharSequence fileText) {
        Stack braceStack = new Stack();
        Stack tagNameStack = new Stack();
        BraceMatcher matcher = BraceMatchingUtil.getBraceMatcher(fileType, iterator2);
        while (!iterator2.atEnd()) {
            if (BraceMatchingUtil.isStructuralBraceToken(fileType, iterator2, fileText)) {
                if (BraceMatchingUtil.isRBraceToken(iterator2, fileText, fileType)) {
                    braceStack.push((Object)iterator2.getTokenType());
                    tagNameStack.push((Object)BraceMatchingUtil.getTagName(matcher, fileText, iterator2));
                }
                if (BraceMatchingUtil.isLBraceToken(iterator2, fileText, fileType)) {
                    if (braceStack.isEmpty()) {
                        return true;
                    }
                    int group = matcher.getBraceTokenGroupId(iterator2.getTokenType());
                    IElementType topTokenType = (IElementType)braceStack.pop();
                    IElementType tokenType = iterator2.getTokenType();
                    boolean isStrict = BraceMatchingUtil.isStrictTagMatching(matcher, fileType, group);
                    boolean isCaseSensitive = BraceMatchingUtil.areTagsCaseSensitive(matcher, fileType, group);
                    String topTagName = null;
                    String tagName = null;
                    if (isStrict) {
                        topTagName = (String)tagNameStack.pop();
                        tagName = BraceMatchingUtil.getTagName(matcher, fileText, iterator2);
                    }
                    if (!BraceMatchingUtil.isPairBraces(topTokenType, tokenType, fileType) || isStrict && !Comparing.equal((String)topTagName, (String)tagName, (boolean)isCaseSensitive)) {
                        return false;
                    }
                }
            }
            iterator2.retreat();
        }
        return false;
    }

    public static boolean isStructuralBraceToken(@NotNull FileType fileType, @NotNull HighlighterIterator iterator2, @NotNull CharSequence text) {
        BraceMatcher matcher = BraceMatchingUtil.getBraceMatcher(fileType, iterator2);
        return matcher.isStructuralBrace(iterator2, text, fileType);
    }

    public static boolean isLBraceToken(@NotNull HighlighterIterator iterator2, @NotNull CharSequence fileText, @NotNull FileType fileType) {
        BraceMatcher braceMatcher = BraceMatchingUtil.getBraceMatcher(fileType, iterator2);
        return braceMatcher.isLBraceToken(iterator2, fileText, fileType);
    }

    public static boolean isRBraceToken(@NotNull HighlighterIterator iterator2, @NotNull CharSequence fileText, @NotNull FileType fileType) {
        BraceMatcher braceMatcher = BraceMatchingUtil.getBraceMatcher(fileType, iterator2);
        return braceMatcher.isRBraceToken(iterator2, fileText, fileType);
    }

    public static boolean isPairBraces(@NotNull IElementType tokenType1, @NotNull IElementType tokenType2, @NotNull FileType fileType) {
        BraceMatcher matcher = BraceMatchingUtil.getBraceMatcher(fileType, tokenType1);
        return matcher.isPairBraces(tokenType1, tokenType2);
    }

    private static int getTokenGroup(@Nullable IElementType tokenType, FileType fileType) {
        return tokenType == null ? -1 : BraceMatchingUtil.getBraceMatcher(fileType, tokenType).getBraceTokenGroupId(tokenType);
    }

    public static int findLeftmostLParen(@NotNull HighlighterIterator iterator2, @NotNull IElementType lparenTokenType, @NotNull CharSequence fileText, @NotNull FileType fileType) {
        return BraceMatchingUtil.findLeftOrRightParenth(iterator2, lparenTokenType, fileText, fileType, false, false);
    }

    public static int findLeftLParen(@NotNull HighlighterIterator iterator2, @NotNull IElementType lparenTokenType, @NotNull CharSequence fileText, @NotNull FileType fileType) {
        return BraceMatchingUtil.findLeftOrRightParenth(iterator2, lparenTokenType, fileText, fileType, false, true);
    }

    public static int findRightmostRParen(@NotNull HighlighterIterator iterator2, @NotNull IElementType rparenTokenType, @NotNull CharSequence fileText, @NotNull FileType fileType) {
        return BraceMatchingUtil.findLeftOrRightParenth(iterator2, rparenTokenType, fileText, fileType, true, false);
    }

    private static int findLeftOrRightParenth(@NotNull HighlighterIterator iterator2, @NotNull IElementType targetParenTokenType, @NotNull CharSequence fileText, @NotNull FileType fileType, boolean searchingForRight, boolean stopOnFirstFinishedGroup) {
        int lastBraceOffset = -1;
        Stack braceStack = new Stack();
        while (!iterator2.atEnd()) {
            IElementType tokenType = iterator2.getTokenType();
            if (BraceMatchingUtil.isBraceToken(iterator2, fileText, fileType, searchingForRight)) {
                if (braceStack.isEmpty()) {
                    if (tokenType != targetParenTokenType) break;
                    lastBraceOffset = iterator2.getStart();
                    if (stopOnFirstFinishedGroup) {
                        break;
                    }
                } else {
                    IElementType topToken = (IElementType)braceStack.pop();
                    if (!BraceMatchingUtil.isPairBraces(tokenType, topToken, fileType)) {
                        break;
                    }
                }
            } else if (BraceMatchingUtil.isBraceToken(iterator2, fileText, fileType, !searchingForRight)) {
                braceStack.push((Object)iterator2.getTokenType());
            }
            BraceMatchingUtil.advance(iterator2, searchingForRight);
        }
        return lastBraceOffset;
    }

    private static boolean isBraceToken(@NotNull HighlighterIterator iterator2, @NotNull CharSequence fileText, @NotNull FileType fileType, boolean searchingForRight) {
        return searchingForRight ? BraceMatchingUtil.isRBraceToken(iterator2, fileText, fileType) : BraceMatchingUtil.isLBraceToken(iterator2, fileText, fileType);
    }

    private static void advance(@NotNull HighlighterIterator iterator2, boolean forward) {
        if (forward) {
            iterator2.advance();
        } else {
            iterator2.retreat();
        }
    }

    @NotNull
    public static BraceMatcher getBraceMatcher(@NotNull FileType fileType, @NotNull HighlighterIterator iterator2) {
        IElementType tokenType = iterator2.getTokenType();
        return tokenType == null ? BraceMatcherHolder.ourDefaultBraceMatcher : BraceMatchingUtil.getBraceMatcher(fileType, tokenType);
    }

    @NotNull
    public static BraceMatcher getBraceMatcher(@NotNull FileType fileType, @NotNull IElementType type) {
        return BraceMatchingUtil.getBraceMatcher(fileType, type.getLanguage());
    }

    @NotNull
    public static BraceMatcher getBraceMatcher(@NotNull FileType fileType, @NotNull Language lang) {
        Language language;
        PairedBraceMatcher matcher = (PairedBraceMatcher)LanguageBraceMatching.INSTANCE.forLanguage(lang);
        if (matcher != null) {
            if (matcher instanceof XmlAwareBraceMatcher) {
                return (XmlAwareBraceMatcher)matcher;
            }
            if (matcher instanceof PairedBraceMatcherAdapter) {
                return (BraceMatcher)matcher;
            }
            return new PairedBraceMatcherAdapter(matcher, lang);
        }
        BraceMatcher byFileType = BraceMatchingUtil.getBraceMatcherByFileType(fileType);
        if (byFileType != null) {
            return byFileType;
        }
        if (fileType instanceof LanguageFileType && lang != (language = ((LanguageFileType)fileType).getLanguage())) {
            BraceMatcher braceMatcher;
            LanguageFileType type1 = lang.getAssociatedFileType();
            if (type1 != null && (braceMatcher = BraceMatchingUtil.getBraceMatcherByFileType((FileType)type1)) != null) {
                return braceMatcher;
            }
            matcher = (PairedBraceMatcher)LanguageBraceMatching.INSTANCE.forLanguage(language);
            if (matcher != null) {
                return new PairedBraceMatcherAdapter(matcher, language);
            }
        }
        return BraceMatcherHolder.ourDefaultBraceMatcher;
    }

    @Nullable
    private static BraceMatcher getBraceMatcherByFileType(@NotNull FileType fileType) {
        SyntaxTable table;
        BraceMatcher matcher = (BraceMatcher)FileTypeBraceMather.getInstance().forFileType(fileType);
        if (matcher != null) {
            return matcher;
        }
        if (fileType instanceof AbstractFileType && ((table = ((AbstractFileType)fileType).getSyntaxTable()).isHasBraces() || table.isHasBrackets() || table.isHasParens())) {
            return CustomFileTypeBraceMatcher.INSTANCE;
        }
        return null;
    }

    private static boolean isStrictTagMatching(@NotNull BraceMatcher matcher, @NotNull FileType fileType, int group) {
        return matcher instanceof XmlAwareBraceMatcher && ((XmlAwareBraceMatcher)matcher).isStrictTagMatching(fileType, group);
    }

    private static boolean areTagsCaseSensitive(@NotNull BraceMatcher matcher, @NotNull FileType fileType, int tokenGroup) {
        return matcher instanceof XmlAwareBraceMatcher && ((XmlAwareBraceMatcher)matcher).areTagsCaseSensitive(fileType, tokenGroup);
    }

    @Nullable
    private static String getTagName(@NotNull BraceMatcher matcher, @NotNull CharSequence fileText, @NotNull HighlighterIterator iterator2) {
        if (matcher instanceof XmlAwareBraceMatcher) {
            return ((XmlAwareBraceMatcher)matcher).getTagName(fileText, iterator2);
        }
        return null;
    }

    public static final class BraceHighlightingAndNavigationContext {
        public final int currentBraceOffset;
        public final int navigationOffset;
        public final boolean isCaretAfterBrace;

        public BraceHighlightingAndNavigationContext(int currentBraceOffset, int navigationOffset, boolean isCaretAfterBrace) {
            this.currentBraceOffset = currentBraceOffset;
            this.navigationOffset = navigationOffset;
            this.isCaretAfterBrace = isCaretAfterBrace;
        }
    }

    private static class DefaultBraceMatcher
    implements BraceMatcher {
        private DefaultBraceMatcher() {
        }

        @Override
        public int getBraceTokenGroupId(IElementType tokenType) {
            return -1;
        }

        @Override
        public boolean isLBraceToken(HighlighterIterator iterator2, CharSequence fileText, FileType fileType) {
            return false;
        }

        @Override
        public boolean isRBraceToken(HighlighterIterator iterator2, CharSequence fileText, FileType fileType) {
            return false;
        }

        @Override
        public boolean isPairBraces(IElementType tokenType, IElementType tokenType2) {
            return false;
        }

        @Override
        public boolean isStructuralBrace(HighlighterIterator iterator2, CharSequence text, FileType fileType) {
            return false;
        }

        @Override
        public IElementType getOppositeBraceTokenType(@NotNull IElementType type) {
            return null;
        }

        @Override
        public boolean isPairedBracesAllowedBeforeType(@NotNull IElementType lbraceType, @Nullable IElementType contextType) {
            return true;
        }

        @Override
        public int getCodeConstructStart(PsiFile file2, int openingBraceOffset) {
            return openingBraceOffset;
        }
    }

    private static class BraceMatcherHolder {
        private static final BraceMatcher ourDefaultBraceMatcher = new DefaultBraceMatcher();
        private static final BraceMatcher nullBraceMatcher = new DefaultBraceMatcher();

        private BraceMatcherHolder() {
        }
    }

    private static class MatchBraceContext {
        private final CharSequence fileText;
        private final FileType fileType;
        private final HighlighterIterator iterator;
        private final boolean forward;
        private final IElementType brace1Token;
        private final int group;
        private final String brace1TagName;
        private final boolean isStrict;
        private final boolean isCaseSensitive;
        @NotNull
        private final BraceMatcher myMatcher;
        private final Stack<IElementType> myBraceStack = new Stack();
        private final Stack<String> myTagNameStack = new Stack();

        MatchBraceContext(@NotNull CharSequence fileText, @NotNull FileType fileType, @NotNull HighlighterIterator iterator2, boolean forward) {
            this(fileText, fileType, iterator2, forward, BraceMatchingUtil.isStrictTagMatching(BraceMatchingUtil.getBraceMatcher(fileType, iterator2), fileType, BraceMatchingUtil.getTokenGroup(iterator2.getTokenType(), fileType)));
        }

        MatchBraceContext(@NotNull CharSequence fileText, @NotNull FileType fileType, @NotNull HighlighterIterator iterator2, boolean forward, boolean strict) {
            this.fileText = fileText;
            this.fileType = fileType;
            this.iterator = iterator2;
            this.forward = forward;
            this.myMatcher = BraceMatchingUtil.getBraceMatcher(fileType, iterator2);
            this.brace1Token = this.iterator.getTokenType();
            this.group = BraceMatchingUtil.getTokenGroup(this.brace1Token, this.fileType);
            this.brace1TagName = BraceMatchingUtil.getTagName(this.myMatcher, this.fileText, this.iterator);
            this.isCaseSensitive = BraceMatchingUtil.areTagsCaseSensitive(this.myMatcher, this.fileType, this.group);
            this.isStrict = strict;
        }

        boolean doBraceMatch() {
            boolean matched;
            block10: {
                this.myBraceStack.clear();
                this.myTagNameStack.clear();
                this.myBraceStack.push((Object)this.brace1Token);
                if (this.isStrict) {
                    this.myTagNameStack.push((Object)this.brace1TagName);
                }
                matched = false;
                while (true) {
                    BraceMatchingUtil.advance(this.iterator, this.forward);
                    if (this.iterator.atEnd()) break block10;
                    IElementType tokenType = this.iterator.getTokenType();
                    if (BraceMatchingUtil.getTokenGroup(tokenType, this.fileType) != this.group) continue;
                    String tagName = BraceMatchingUtil.getTagName(this.myMatcher, this.fileText, this.iterator);
                    if (!this.isStrict && !Comparing.equal((String)this.brace1TagName, (String)tagName, (boolean)this.isCaseSensitive)) continue;
                    if (BraceMatchingUtil.isBraceToken(this.iterator, this.fileText, this.fileType, !this.forward)) {
                        this.myBraceStack.push((Object)tokenType);
                        if (!this.isStrict) continue;
                        this.myTagNameStack.push((Object)tagName);
                        continue;
                    }
                    if (!BraceMatchingUtil.isBraceToken(this.iterator, this.fileText, this.fileType, this.forward)) continue;
                    IElementType topTokenType = (IElementType)this.myBraceStack.pop();
                    String topTagName = null;
                    if (this.isStrict) {
                        topTagName = (String)this.myTagNameStack.pop();
                    }
                    if (!this.isStrict) {
                        IElementType baseType = this.myMatcher.getOppositeBraceTokenType(tokenType);
                        if (this.myBraceStack.contains((Object)baseType)) {
                            while (!BraceMatchingUtil.isPairBraces(topTokenType, tokenType, this.fileType) && !this.myBraceStack.empty()) {
                                topTokenType = (IElementType)this.myBraceStack.pop();
                            }
                        } else if (!(this.brace1TagName != null && this.brace1TagName.equals(tagName) || BraceMatchingUtil.isPairBraces(topTokenType, tokenType, this.fileType))) {
                            this.myBraceStack.push((Object)topTokenType);
                            continue;
                        }
                    }
                    if (!BraceMatchingUtil.isPairBraces(topTokenType, tokenType, this.fileType) || this.isStrict && !Comparing.equal((String)topTagName, (String)tagName, (boolean)this.isCaseSensitive)) {
                        matched = false;
                        break block10;
                    }
                    if (this.myBraceStack.isEmpty()) break;
                }
                matched = true;
            }
            return matched;
        }
    }
}

