/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.folding.impl.actions;

import com.intellij.codeInsight.folding.impl.FoldingUtil;
import com.intellij.codeInsight.folding.impl.actions.BaseFoldingHandler;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.editor.Caret;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.FoldRegion;
import com.intellij.openapi.editor.actionSystem.EditorAction;
import com.intellij.openapi.editor.actionSystem.EditorActionHandler;
import com.intellij.openapi.project.Project;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ExpandRegionAction
extends EditorAction {
    public ExpandRegionAction() {
        super((EditorActionHandler)new BaseFoldingHandler(){

            public void doExecute(@NotNull Editor editor, @Nullable Caret caret, DataContext dataContext) {
                ExpandRegionAction.expandRegionAtCaret(editor.getProject(), editor);
            }
        });
    }

    private static void expandRegionAtCaret(Project project, @Nullable Editor editor) {
        if (editor == null) {
            return;
        }
        ExpandRegionAction.expandRegionAtOffset(project, editor, editor.getCaretModel().getOffset());
    }

    public static void expandRegionAtOffset(@NotNull Project project, @NotNull Editor editor, int offset) {
        int line = editor.getDocument().getLineNumber(offset);
        Runnable processor2 = () -> {
            FoldRegion region = FoldingUtil.findFoldRegionStartingAtLine(editor, line);
            if (region != null && !region.isExpanded()) {
                region.setExpanded(true);
            } else {
                FoldRegion[] regions = FoldingUtil.getFoldRegionsAtOffset(editor, offset);
                for (int i2 = regions.length - 1; i2 >= 0; --i2) {
                    region = regions[i2];
                    if (region.isExpanded()) continue;
                    region.setExpanded(true);
                    break;
                }
            }
        };
        editor.getFoldingModel().runBatchFoldingOperation(processor2);
    }
}

