/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.documentation.render;

import com.intellij.codeInsight.documentation.render.DocRenderer;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.event.CaretEvent;
import com.intellij.openapi.editor.event.CaretListener;
import com.intellij.openapi.editor.event.SelectionEvent;
import com.intellij.openapi.editor.event.SelectionListener;
import com.intellij.openapi.util.Key;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class DocRenderSelectionManager
implements CaretListener,
SelectionListener,
Disposable {
    private static final Key<DocRenderSelectionManager> OUR_KEY = Key.create((String)"DocRenderSelectionManager");
    private final Editor myEditor;
    private DocRenderer.EditorPane myPaneWithSelection;
    private boolean mySkipSelectionEvents;

    DocRenderSelectionManager(Editor editor) {
        this.myEditor = editor;
        editor.getCaretModel().addCaretListener((CaretListener)this, (Disposable)this);
        editor.getSelectionModel().addSelectionListener((SelectionListener)this, (Disposable)this);
        editor.putUserData(OUR_KEY, (Object)this);
    }

    public void dispose() {
        this.myEditor.putUserData(OUR_KEY, null);
    }

    void setPaneWithSelection(DocRenderer.EditorPane pane2) {
        if (pane2 != this.myPaneWithSelection) {
            if (this.myPaneWithSelection != null) {
                this.myPaneWithSelection.removeSelection();
            }
            this.myPaneWithSelection = pane2;
            if (this.myPaneWithSelection != null) {
                this.mySkipSelectionEvents = true;
                try {
                    this.myEditor.getSelectionModel().removeSelection(true);
                }
                finally {
                    this.mySkipSelectionEvents = false;
                }
            }
        }
    }

    public void caretPositionChanged(@NotNull CaretEvent event) {
        this.setPaneWithSelection(null);
    }

    public void caretAdded(@NotNull CaretEvent event) {
        this.setPaneWithSelection(null);
    }

    public void caretRemoved(@NotNull CaretEvent event) {
        this.setPaneWithSelection(null);
    }

    public void selectionChanged(@NotNull SelectionEvent e) {
        if (!this.mySkipSelectionEvents) {
            this.setPaneWithSelection(null);
        }
    }

    @Nullable
    public static DocRenderer.EditorPane getPaneWithSelection(@NotNull Editor editor) {
        DocRenderSelectionManager selectionManager = (DocRenderSelectionManager)editor.getUserData(OUR_KEY);
        return selectionManager == null ? null : selectionManager.myPaneWithSelection;
    }
}

