/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.documentation.render;

import com.intellij.codeInsight.documentation.render.DocRenderer;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.components.Service;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.Inlay;
import com.intellij.openapi.editor.ex.util.EditorScrollingPositionKeeper;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Map;
import javax.swing.SwingUtilities;
import org.jetbrains.annotations.NotNull;

@Service
public final class DocRenderItemUpdater
implements Runnable {
    private static final long MAX_UPDATE_DURATION_MS = 50L;
    private final Map<Inlay<DocRenderer>, Boolean> myQueue = new HashMap<Inlay<DocRenderer>, Boolean>();

    static DocRenderItemUpdater getInstance() {
        return (DocRenderItemUpdater)ApplicationManager.getApplication().getService(DocRenderItemUpdater.class);
    }

    void updateInlays(@NotNull Collection<Inlay<DocRenderer>> inlays, boolean recreateContent) {
        if (inlays.isEmpty()) {
            return;
        }
        boolean wasEmpty = this.myQueue.isEmpty();
        for (Inlay<DocRenderer> inlay : inlays) {
            this.myQueue.merge(inlay, recreateContent, (oldValue, newValue2) -> newValue2 | oldValue);
        }
        if (wasEmpty) {
            this.processChunk();
        }
    }

    @Override
    public void run() {
        this.processChunk();
    }

    private void processChunk() {
        long deadline = System.currentTimeMillis() + 50L;
        HashMap<Editor, EditorScrollingPositionKeeper> keepers = new HashMap<Editor, EditorScrollingPositionKeeper>();
        ArrayList<Inlay<DocRenderer>> toProcess2 = new ArrayList<Inlay<DocRenderer>>(this.myQueue.keySet());
        toProcess2.sort(Comparator.comparingInt(i2 -> -Math.abs(i2.getOffset() - i2.getEditor().getCaretModel().getOffset())));
        do {
            Inlay inlay = (Inlay)toProcess2.remove(toProcess2.size() - 1);
            boolean updateContent = this.myQueue.remove(inlay);
            if (!inlay.isValid()) continue;
            Editor editor = inlay.getEditor();
            keepers.computeIfAbsent(editor, e -> {
                EditorScrollingPositionKeeper keeper = new EditorScrollingPositionKeeper(editor);
                keeper.savePosition();
                return keeper;
            });
            if (updateContent) {
                ((DocRenderer)inlay.getRenderer()).updateContent();
                continue;
            }
            inlay.update();
        } while (!toProcess2.isEmpty() && System.currentTimeMillis() < deadline);
        keepers.values().forEach(k -> k.restorePosition(false));
        if (!this.myQueue.isEmpty()) {
            SwingUtilities.invokeLater(this);
        }
    }
}

