/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.documentation.render;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.PathManager;
import com.intellij.openapi.components.Service;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.io.FileUtilRt;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.atomic.AtomicInteger;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Service
public final class CachingDataReader
implements Disposable {
    private static final Logger LOG = Logger.getInstance(CachingDataReader.class);
    private static final int MAX_DATA_SIZE = 1000000;
    private final ConcurrentMap<URL, File> myCache = new ConcurrentHashMap<URL, File>();
    private final AtomicInteger myFileNameCounter = new AtomicInteger();

    public static CachingDataReader getInstance() {
        return (CachingDataReader)ApplicationManager.getApplication().getService(CachingDataReader.class);
    }

    @Nullable
    public InputStream getInputStream(@NotNull URL url) {
        File cachedResult = (File)this.myCache.get(url);
        if (cachedResult != null) {
            try {
                return new FileInputStream(cachedResult);
            }
            catch (FileNotFoundException e) {
                LOG.warn("Couldn't open " + cachedResult, (Throwable)e);
            }
        }
        try {
            return CachingDataReader.shouldCache(url) ? new CachingInputStream(url) : url.openStream();
        }
        catch (IOException e) {
            LOG.debug("Couldn't open " + url, (Throwable)e);
            return null;
        }
    }

    private static boolean shouldCache(@NotNull URL url) {
        String protocol = url.getProtocol();
        return "ftp".equals(protocol) || "http".equals(protocol) || "https".equals(protocol);
    }

    private void cacheResult(@NotNull URL url, byte @NotNull [] data2) {
        File folder = CachingDataReader.getCacheFolder();
        if (!folder.exists() && !folder.mkdirs()) {
            LOG.warn("Couldn't create " + folder);
            return;
        }
        File file2 = new File(folder, this.generateFileName());
        try {
            Files.write(file2.toPath(), data2, new OpenOption[0]);
            this.myCache.put(url, file2);
        }
        catch (IOException e) {
            LOG.warn("Error writing to " + file2, (Throwable)e);
        }
    }

    private static File getCacheFolder() {
        return new File(PathManager.getTempPath(), "imageCache");
    }

    private String generateFileName() {
        return Integer.toString(this.myFileNameCounter.incrementAndGet());
    }

    public void dispose() {
        File folder = CachingDataReader.getCacheFolder();
        if (folder.exists() && !FileUtilRt.delete((File)folder)) {
            LOG.warn("Error deleting folder " + folder);
        }
    }

    private class CachingInputStream
    extends InputStream {
        private final URL myURL;
        private final InputStream myDelegate;
        private ByteArrayOutputStream myStreamCopy;

        private CachingInputStream(URL url) throws IOException {
            this.myURL = url;
            this.myDelegate = url.openStream();
            this.myStreamCopy = new ByteArrayOutputStream();
        }

        @Override
        public int read() throws IOException {
            int data2;
            try {
                data2 = this.myDelegate.read();
            }
            catch (IOException e) {
                this.myStreamCopy = null;
                throw e;
            }
            if (this.myStreamCopy != null) {
                if (data2 < 0) {
                    CachingDataReader.this.cacheResult(this.myURL, this.myStreamCopy.toByteArray());
                    this.myStreamCopy = null;
                } else if (this.myStreamCopy.size() + 1 > 1000000) {
                    this.myStreamCopy = null;
                } else {
                    this.myStreamCopy.write(data2);
                }
            }
            return data2;
        }

        @Override
        public int read(byte[] b, int off, int len) throws IOException {
            int result2;
            try {
                result2 = this.myDelegate.read(b, off, len);
            }
            catch (IOException e) {
                this.myStreamCopy = null;
                throw e;
            }
            if (this.myStreamCopy != null) {
                if (result2 < 0) {
                    CachingDataReader.this.cacheResult(this.myURL, this.myStreamCopy.toByteArray());
                    this.myStreamCopy = null;
                } else if (this.myStreamCopy.size() + result2 > 1000000) {
                    this.myStreamCopy = null;
                } else {
                    this.myStreamCopy.write(b, off, result2);
                }
            }
            return result2;
        }

        @Override
        public long skip(long n) throws IOException {
            this.myStreamCopy = null;
            return this.myDelegate.skip(n);
        }

        @Override
        public int available() throws IOException {
            return this.myDelegate.available();
        }

        @Override
        public void close() throws IOException {
            this.myDelegate.close();
        }
    }
}

