/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.documentation.actions;

import com.intellij.codeInsight.CodeInsightActionHandler;
import com.intellij.codeInsight.actions.BaseCodeInsightAction;
import com.intellij.codeInsight.documentation.DocumentationManager;
import com.intellij.codeInsight.hint.HintManagerImpl;
import com.intellij.codeInsight.lookup.LookupManager;
import com.intellij.codeInsight.lookup.impl.LookupImpl;
import com.intellij.featureStatistics.FeatureUsageTracker;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.PopupAction;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.command.CommandProcessor;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.EditorGutter;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.popup.JBPopup;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import org.jetbrains.annotations.NotNull;

public class ShowQuickDocInfoAction
extends BaseCodeInsightAction
implements HintManagerImpl.ActionToIgnore,
DumbAware,
PopupAction {
    public static final String CODEASSISTS_QUICKJAVADOC_FEATURE = "codeassists.quickjavadoc";
    public static final String CODEASSISTS_QUICKJAVADOC_LOOKUP_FEATURE = "codeassists.quickjavadoc.lookup";
    public static final String CODEASSISTS_QUICKJAVADOC_CTRLN_FEATURE = "codeassists.quickjavadoc.ctrln";

    public ShowQuickDocInfoAction() {
        this.setEnabledInModalContext(true);
        this.setInjectedContext(true);
    }

    @NotNull
    protected CodeInsightActionHandler getHandler() {
        return new CodeInsightActionHandler(){

            public void invoke(@NotNull Project project, @NotNull Editor editor, @NotNull PsiFile file2) {
                DocumentationManager documentationManager;
                JBPopup hint = (documentationManager = DocumentationManager.getInstance(project)).getDocInfoHint();
                documentationManager.showJavaDocInfo(editor, file2, hint != null || LookupManager.getActiveLookup(editor) == null);
            }

            public boolean startInWriteAction() {
                return false;
            }
        };
    }

    @Override
    protected boolean isValidForLookup() {
        return true;
    }

    @Override
    public void update(@NotNull AnActionEvent event) {
        Presentation presentation2 = event.getPresentation();
        DataContext dataContext = event.getDataContext();
        presentation2.setEnabled(false);
        Project project = (Project)CommonDataKeys.PROJECT.getData(dataContext);
        if (project == null) {
            return;
        }
        Editor editor = (Editor)CommonDataKeys.EDITOR.getData(dataContext);
        PsiElement element2 = (PsiElement)CommonDataKeys.PSI_ELEMENT.getData(dataContext);
        if (editor == null && element2 == null) {
            return;
        }
        if (LookupManager.getInstance(project).getActiveLookup() != null) {
            if (this.isValidForLookup()) {
                presentation2.setEnabled(true);
            }
        } else {
            if (editor != null) {
                if (event.getData(EditorGutter.KEY) != null) {
                    return;
                }
                PsiFile file2 = PsiDocumentManager.getInstance((Project)project).getPsiFile(editor.getDocument());
                if (file2 == null && element2 == null) {
                    return;
                }
            }
            presentation2.setEnabled(true);
        }
    }

    public void actionPerformed(@NotNull AnActionEvent e) {
        DataContext dataContext = e.getDataContext();
        Project project = (Project)CommonDataKeys.PROJECT.getData(dataContext);
        Editor editor = (Editor)CommonDataKeys.EDITOR.getData(dataContext);
        PsiElement element2 = (PsiElement)CommonDataKeys.PSI_ELEMENT.getData(dataContext);
        if (project != null && editor != null) {
            FeatureUsageTracker.getInstance().triggerFeatureUsed(CODEASSISTS_QUICKJAVADOC_FEATURE);
            LookupImpl lookup2 = (LookupImpl)LookupManager.getInstance(project).getActiveLookup();
            if (lookup2 != null) {
                FeatureUsageTracker.getInstance().triggerFeatureUsed(CODEASSISTS_QUICKJAVADOC_LOOKUP_FEATURE);
            }
            this.actionPerformedImpl(project, editor);
        } else if (project != null && element2 != null) {
            FeatureUsageTracker.getInstance().triggerFeatureUsed(CODEASSISTS_QUICKJAVADOC_CTRLN_FEATURE);
            CommandProcessor.getInstance().executeCommand(project, () -> {
                DocumentationManager documentationManager;
                JBPopup hint = (documentationManager = DocumentationManager.getInstance(project)).getDocInfoHint();
                documentationManager.showJavaDocInfo(element2, null, hint != null, null);
            }, this.getCommandName(), null);
        }
    }
}

