/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.daemon.impl.actions;

import com.intellij.codeInsight.CodeInsightActionHandler;
import com.intellij.codeInsight.actions.BaseCodeInsightAction;
import com.intellij.codeInsight.daemon.impl.DaemonCodeAnalyzerEx;
import com.intellij.codeInsight.daemon.impl.HighlightInfo;
import com.intellij.codeInsight.daemon.impl.HighlightInfoType;
import com.intellij.openapi.editor.Caret;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.FoldRegion;
import com.intellij.openapi.editor.FoldingModel;
import com.intellij.openapi.editor.ScrollType;
import com.intellij.openapi.editor.ex.MarkupModelEx;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Ref;
import com.intellij.psi.PsiFile;
import com.intellij.util.Processor;
import java.util.Comparator;
import org.jetbrains.annotations.NotNull;

abstract class GotoElementUnderCaretUsageBase
extends BaseCodeInsightAction
implements CodeInsightActionHandler {
    @NotNull
    private final Direction myDirection;

    GotoElementUnderCaretUsageBase(@NotNull Direction direction) {
        this.myDirection = direction;
    }

    @NotNull
    protected CodeInsightActionHandler getHandler() {
        return this;
    }

    public void invoke(@NotNull Project project, @NotNull Editor editor, @NotNull PsiFile file2) {
        Comparator<Integer> ordering = this.myDirection.ordering;
        int caretOffset = editor.getCaretModel().getOffset();
        int startOffset = file2.getTextRange().getStartOffset();
        int endOffset = file2.getTextRange().getEndOffset();
        Ref first = new Ref();
        Ref next = new Ref();
        DaemonCodeAnalyzerEx.processHighlights((MarkupModelEx)editor.getMarkupModel(), project, null, startOffset, endOffset, (Processor<? super HighlightInfo>)((Processor)info -> {
            if (HighlightInfoType.ELEMENT_UNDER_CARET_READ.equals(info.type) || HighlightInfoType.ELEMENT_UNDER_CARET_WRITE.equals(info.type)) {
                if (ordering.compare(info.startOffset, caretOffset) > 0 && ordering.compare(info.endOffset, caretOffset) > 0 && (next.isNull() || ordering.compare((Integer)next.get(), info.startOffset) > 0)) {
                    next.set((Object)info.startOffset);
                }
                if (first.isNull() || ordering.compare((Integer)first.get(), info.startOffset) > 0) {
                    first.set((Object)info.startOffset);
                }
            }
            return true;
        }));
        if (!next.isNull()) {
            GotoElementUnderCaretUsageBase.moveCaret(editor, (Integer)next.get());
        } else if (!first.isNull()) {
            GotoElementUnderCaretUsageBase.moveCaret(editor, (Integer)first.get());
        }
    }

    public boolean startInWriteAction() {
        return false;
    }

    private static void moveCaret(Editor editor, int toOffset) {
        Caret caret = editor.getCaretModel().getCurrentCaret();
        caret.removeSelection();
        caret.moveToOffset(toOffset);
        FoldingModel foldingModel = editor.getFoldingModel();
        FoldRegion region = foldingModel.getCollapsedRegionAtOffset(toOffset);
        if (region != null) {
            foldingModel.runBatchFoldingOperation(() -> region.setExpanded(true));
        }
        if (caret == editor.getCaretModel().getPrimaryCaret()) {
            editor.getScrollingModel().scrollToCaret(ScrollType.MAKE_VISIBLE);
        }
    }

    protected static enum Direction {
        FORWARD(Comparator.naturalOrder()),
        BACKWARD(Comparator.reverseOrder());

        public final Comparator<Integer> ordering;

        private Direction(Comparator<Integer> ordering) {
            this.ordering = ordering;
        }
    }
}

