/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.daemon.impl;

import com.intellij.codeHighlighting.TextEditorHighlightingPass;
import com.intellij.codeHighlighting.TextEditorHighlightingPassFactory;
import com.intellij.codeHighlighting.TextEditorHighlightingPassFactoryRegistrar;
import com.intellij.codeHighlighting.TextEditorHighlightingPassRegistrar;
import com.intellij.codeInsight.daemon.DaemonBundle;
import com.intellij.codeInsight.daemon.ProblemHighlightFilter;
import com.intellij.codeInsight.daemon.impl.DefaultHighlightInfoProcessor;
import com.intellij.codeInsight.daemon.impl.LocalInspectionsPass;
import com.intellij.codeInsight.daemon.impl.VisibleHighlightingPassFactory;
import com.intellij.codeInspection.InspectionProfile;
import com.intellij.codeInspection.ex.InspectionProfileWrapper;
import com.intellij.codeInspection.ex.LocalInspectionToolWrapper;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.ProperTextRange;
import com.intellij.openapi.util.TextRange;
import com.intellij.profile.ProfileChangeAdapter;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.ObjectIntMap;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

final class WholeFileLocalInspectionsPassFactory
implements TextEditorHighlightingPassFactory,
Disposable {
    private final Set<PsiFile> mySkipWholeInspectionsCache = ContainerUtil.createWeakSet();
    private final ObjectIntMap<PsiFile> myPsiModificationCount = ContainerUtil.createWeakKeyIntValueMap();
    private final Project myProject;

    private WholeFileLocalInspectionsPassFactory(@NotNull Project project, @NotNull TextEditorHighlightingPassRegistrar registrar) {
        this.myProject = project;
        registrar.registerTextEditorHighlightingPass((TextEditorHighlightingPassFactory)this, null, new int[]{7}, true, 12);
        this.myProject.getMessageBus().connect((Disposable)this).subscribe(ProfileChangeAdapter.TOPIC, (Object)new ProfileChangeAdapter(){

            public void profileChanged(InspectionProfile profile) {
                WholeFileLocalInspectionsPassFactory.this.clearCaches();
            }

            public void profileActivated(InspectionProfile oldProfile, @Nullable InspectionProfile profile) {
                WholeFileLocalInspectionsPassFactory.this.clearCaches();
            }
        });
    }

    public void dispose() {
        this.clearCaches();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void clearCaches() {
        Set<PsiFile> set = this.mySkipWholeInspectionsCache;
        synchronized (set) {
            this.mySkipWholeInspectionsCache.clear();
        }
        set = this.myPsiModificationCount;
        synchronized (set) {
            this.myPsiModificationCount.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Nullable
    public TextEditorHighlightingPass createHighlightingPass(final @NotNull PsiFile file2, @NotNull Editor editor) {
        long actualCount = PsiManager.getInstance((Project)this.myProject).getModificationTracker().getModificationCount();
        Object object = this.myPsiModificationCount;
        synchronized (object) {
            if (this.myPsiModificationCount.get((Object)file2) == (int)actualCount) {
                return null;
            }
        }
        if (!ProblemHighlightFilter.shouldHighlightFile((PsiFile)file2)) {
            return null;
        }
        object = this.mySkipWholeInspectionsCache;
        synchronized (object) {
            if (this.mySkipWholeInspectionsCache.contains(file2)) {
                return null;
            }
        }
        ProperTextRange visibleRange = VisibleHighlightingPassFactory.calculateVisibleRange(editor);
        return new LocalInspectionsPass(file2, editor.getDocument(), 0, file2.getTextLength(), (TextRange)visibleRange, true, new DefaultHighlightInfoProcessor(), false){

            @Override
            protected boolean isAcceptableLocalTool(@NotNull LocalInspectionToolWrapper wrapper2) {
                return wrapper2.runForWholeFile();
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            @NotNull
            List<LocalInspectionToolWrapper> getInspectionTools(@NotNull InspectionProfileWrapper profile) {
                List<LocalInspectionToolWrapper> result2 = super.getInspectionTools(profile);
                if (result2.isEmpty()) {
                    Set set = WholeFileLocalInspectionsPassFactory.this.mySkipWholeInspectionsCache;
                    synchronized (set) {
                        WholeFileLocalInspectionsPassFactory.this.mySkipWholeInspectionsCache.add(file2);
                    }
                }
                return result2;
            }

            @Override
            protected String getPresentableName() {
                return DaemonBundle.message((String)"pass.whole.inspections", (Object[])new Object[0]);
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            protected void applyInformationWithProgress() {
                super.applyInformationWithProgress();
                long modificationCount = PsiManager.getInstance((Project)this.myProject).getModificationTracker().getModificationCount();
                ObjectIntMap objectIntMap = WholeFileLocalInspectionsPassFactory.this.myPsiModificationCount;
                synchronized (objectIntMap) {
                    WholeFileLocalInspectionsPassFactory.this.myPsiModificationCount.put((Object)file2, (int)modificationCount);
                }
            }
        };
    }

    static final class MyRegistrar
    implements TextEditorHighlightingPassFactoryRegistrar {
        MyRegistrar() {
        }

        @Override
        public void registerHighlightingPassFactory(@NotNull TextEditorHighlightingPassRegistrar registrar, @NotNull Project project) {
            WholeFileLocalInspectionsPassFactory factory2 = new WholeFileLocalInspectionsPassFactory(project, registrar);
            Disposer.register((Disposable)project, (Disposable)factory2);
        }
    }
}

