/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.daemon.impl;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.LogicalPosition;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.ProperTextRange;
import com.intellij.openapi.util.TextRange;
import java.awt.Point;
import java.awt.Rectangle;
import org.jetbrains.annotations.NotNull;

public abstract class VisibleHighlightingPassFactory {
    public static Key<ProperTextRange> HEADLESS_VISIBLE_AREA = Key.create((String)"Editor.headlessVisibleArea");

    @NotNull
    public static ProperTextRange calculateVisibleRange(@NotNull Editor editor) {
        if (ApplicationManager.getApplication().isHeadlessEnvironment() && !ApplicationManager.getApplication().isUnitTestMode()) {
            ProperTextRange textRange = (ProperTextRange)editor.getUserData(HEADLESS_VISIBLE_AREA);
            ProperTextRange entireTextRange = new ProperTextRange(0, editor.getDocument().getTextLength());
            if (textRange != null && entireTextRange.contains((TextRange)textRange)) {
                return textRange;
            }
            return entireTextRange;
        }
        Rectangle rect = editor.getScrollingModel().getVisibleArea();
        LogicalPosition startPosition = editor.xyToLogicalPosition(new Point(rect.x, rect.y));
        int visibleStart = editor.logicalPositionToOffset(startPosition);
        LogicalPosition endPosition = editor.xyToLogicalPosition(new Point(rect.x + rect.width, rect.y + rect.height));
        int visibleEnd = editor.logicalPositionToOffset(new LogicalPosition(endPosition.line + 1, 0));
        return new ProperTextRange(visibleStart, Math.max(visibleEnd, visibleStart));
    }
}

