/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.daemon.impl;

import com.intellij.codeInsight.CodeInsightBundle;
import com.intellij.codeInsight.daemon.DaemonBundle;
import com.intellij.codeInsight.daemon.impl.HighlightInfoProcessor;
import com.intellij.codeInsight.daemon.impl.ProgressableTextEditorHighlightingPass;
import com.intellij.codeInsight.daemon.impl.TrafficLightRenderer;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiFile;
import com.intellij.ui.HintHint;
import com.intellij.ui.components.panels.NonOpaquePanel;
import com.intellij.ui.components.panels.VerticalBox;
import com.intellij.ui.components.panels.Wrapper;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.UIUtil;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Rectangle;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import javax.swing.Box;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.SwingUtilities;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class TrafficProgressPanel
extends JPanel {
    static final String MAX_TEXT = "100%";
    private static final String MIN_TEXT = "0%";
    private final JLabel statistics = new JLabel();
    private final Map<JProgressBar, JLabel> myProgressToText = new HashMap<JProgressBar, JLabel>();
    private final JLabel statusLabel = new JLabel();
    private final JLabel statusExtraLineLabel = new JLabel();
    @NotNull
    private final TrafficLightRenderer myTrafficLightRenderer;
    private final JPanel myPassStatuses = new JPanel();
    private final JPanel myEmptyPassStatuses = new NonOpaquePanel();
    private final Wrapper myPassStatusesContainer = new Wrapper();
    @NotNull
    private final HintHint myHintHint;

    TrafficProgressPanel(@NotNull TrafficLightRenderer trafficLightRenderer, @NotNull Editor editor, @NotNull HintHint hintHint) {
        this.myHintHint = hintHint;
        this.myTrafficLightRenderer = trafficLightRenderer;
        this.setLayout(new BorderLayout());
        VerticalBox center = new VerticalBox();
        this.add((Component)center, "North");
        center.add((Component)this.statusLabel);
        center.add((Component)this.statusExtraLineLabel);
        center.add((Component)((Object)new Separator()));
        center.add(Box.createVerticalStrut(6));
        TrafficLightRenderer.DaemonCodeAnalyzerStatus fakeStatusLargeEnough = new TrafficLightRenderer.DaemonCodeAnalyzerStatus();
        fakeStatusLargeEnough.errorCount = new int[]{1, 1, 1, 1};
        Project project = trafficLightRenderer.getProject();
        PsiFile psiFile = PsiDocumentManager.getInstance((Project)project).getPsiFile(editor.getDocument());
        fakeStatusLargeEnough.passes = new ArrayList<ProgressableTextEditorHighlightingPass>();
        for (int i2 = 0; i2 < 3; ++i2) {
            fakeStatusLargeEnough.passes.add(new ProgressableTextEditorHighlightingPass(project, editor.getDocument(), DaemonBundle.message((String)"pass.wolf", (Object[])new Object[0]), psiFile, editor, TextRange.EMPTY_RANGE, false, HighlightInfoProcessor.getEmpty()){

                @Override
                protected void collectInformationWithProgress(@NotNull ProgressIndicator progress2) {
                }

                @Override
                protected void applyInformationWithProgress() {
                }
            });
        }
        center.add((Component)this.myPassStatusesContainer);
        this.add((Component)this.statistics, "South");
        this.updatePanel(fakeStatusLargeEnough, true);
        hintHint.initStyle(this, true);
        this.statusLabel.setFont(this.statusLabel.getFont().deriveFont(1));
    }

    int getMinWidth() {
        return Math.max(Math.max(Math.max(this.getLabelMinWidth(this.statistics), this.getLabelMinWidth(this.statusExtraLineLabel)), this.getLabelMinWidth(this.statusLabel)), this.getLabelMinWidth(new JLabel(CodeInsightBundle.message((String)"label.slow.inspections.progress.report.long.line", (Object[])new Object[0]))));
    }

    private int getLabelMinWidth(@NotNull JLabel label2) {
        Icon icon2;
        String text = label2.getText();
        Icon icon3 = icon2 = label2.isEnabled() ? label2.getIcon() : label2.getDisabledIcon();
        if (icon2 == null && StringUtil.isEmpty((String)text)) {
            return 0;
        }
        Rectangle paintIconR = new Rectangle();
        Rectangle paintTextR = new Rectangle();
        Rectangle paintViewR = new Rectangle(10000, 10000);
        SwingUtilities.layoutCompoundLabel(label2, this.getFontMetrics(this.getFont()), text, icon2, label2.getVerticalAlignment(), label2.getHorizontalAlignment(), label2.getVerticalTextPosition(), label2.getHorizontalTextPosition(), paintViewR, paintIconR, paintTextR, label2.getIconTextGap());
        return paintTextR.width;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void updatePanel(@NotNull TrafficLightRenderer.DaemonCodeAnalyzerStatus status, boolean isFake) {
        try {
            boolean needRebuild = this.myTrafficLightRenderer.updatePanel(status);
            this.statusLabel.setText(this.myTrafficLightRenderer.statusLabel);
            if (this.myTrafficLightRenderer.statusExtraLine == null) {
                this.statusExtraLineLabel.setVisible(false);
            } else {
                this.statusExtraLineLabel.setText(this.myTrafficLightRenderer.statusExtraLine);
                this.statusExtraLineLabel.setVisible(true);
            }
            this.myPassStatuses.setVisible(this.myTrafficLightRenderer.passStatusesVisible);
            this.statistics.setText(this.myTrafficLightRenderer.statistics);
            this.resetProgressBars(this.myTrafficLightRenderer.progressBarsEnabled, this.myTrafficLightRenderer.progressBarsCompleted);
            if (needRebuild) {
                this.rebuildPassesProgress(status);
            }
            for (ProgressableTextEditorHighlightingPass pass : status.passes) {
                double progress2 = pass.getProgress();
                Pair<JProgressBar, JLabel> pair = this.myTrafficLightRenderer.passes.get(pass);
                JProgressBar progressBar = (JProgressBar)pair.first;
                int percent = (int)Math.round(progress2 * 100.0);
                if (percent == 100 && !pass.isFinished()) {
                    percent = 99;
                }
                progressBar.setValue(percent);
                JLabel percentage = (JLabel)pair.second;
                percentage.setText(percent + "%");
            }
        }
        finally {
            if (isFake) {
                this.myEmptyPassStatuses.setPreferredSize(this.myPassStatuses.getPreferredSize());
                this.myPassStatusesContainer.setContent((JComponent)this.myEmptyPassStatuses);
            } else {
                this.myPassStatusesContainer.setContent((JComponent)this.myPassStatuses);
            }
        }
    }

    private void resetProgressBars(boolean enabled, @Nullable Boolean completed) {
        for (JProgressBar progress2 : UIUtil.uiTraverser((Component)this.myPassStatuses).traverse().filter(JProgressBar.class)) {
            progress2.setEnabled(enabled);
            if (completed == null) continue;
            if (completed.booleanValue()) {
                progress2.setValue(100);
                this.myProgressToText.get(progress2).setText(MAX_TEXT);
                continue;
            }
            progress2.setValue(0);
            this.myProgressToText.get(progress2).setText(MIN_TEXT);
        }
    }

    private void rebuildPassesProgress(@NotNull TrafficLightRenderer.DaemonCodeAnalyzerStatus status) {
        this.myPassStatuses.removeAll();
        this.myPassStatuses.setLayout(new GridBagLayout());
        GridBagConstraints c = new GridBagConstraints();
        c.gridy = 0;
        c.fill = 2;
        for (ProgressableTextEditorHighlightingPass pass : status.passes) {
            JLabel label2 = new JLabel(pass.getPresentableName() + ": ");
            label2.setHorizontalTextPosition(4);
            Pair<JProgressBar, JLabel> pair = this.myTrafficLightRenderer.passes.get(pass);
            JProgressBar progressBar = (JProgressBar)pair.getFirst();
            UIUtil.applyStyle((UIUtil.ComponentStyle)UIUtil.ComponentStyle.MINI, (Component)progressBar);
            JLabel percLabel = (JLabel)pair.getSecond();
            this.myProgressToText.put(progressBar, percLabel);
            c.gridx = 0;
            this.myPassStatuses.add((Component)label2, c);
            c.gridx = 1;
            this.myPassStatuses.add((Component)progressBar, c);
            c.gridx = 2;
            c.weightx = 1.0;
            this.myPassStatuses.add((Component)percLabel, c);
            ++c.gridy;
        }
        this.myHintHint.initStyle(this.myPassStatuses, true);
    }

    private class Separator
    extends NonOpaquePanel {
        private Separator() {
        }

        protected void paintComponent(@NotNull Graphics g) {
            Insets insets = this.getInsets();
            if (insets == null) {
                insets = JBUI.emptyInsets();
            }
            g.setColor(TrafficProgressPanel.this.myHintHint.getTextForeground());
            g.drawLine(insets.left, insets.top, this.getWidth() - insets.left - insets.right, insets.top);
        }

        @NotNull
        public Dimension getPreferredSize() {
            return new Dimension(1, 1);
        }

        @NotNull
        public Dimension getMinimumSize() {
            return new Dimension(1, 1);
        }
    }
}

