/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.daemon.impl;

import com.intellij.codeHighlighting.EditorBoundHighlightingPass;
import com.intellij.codeHighlighting.HighlightingPass;
import com.intellij.codeHighlighting.TextEditorHighlightingPass;
import com.intellij.codeHighlighting.TextEditorHighlightingPassRegistrar;
import com.intellij.codeInsight.daemon.impl.DaemonCodeAnalyzerEx;
import com.intellij.codeInsight.daemon.impl.DaemonProgressIndicator;
import com.intellij.codeInsight.daemon.impl.DefaultHighlightInfoProcessor;
import com.intellij.codeInsight.daemon.impl.FileStatusMap;
import com.intellij.codeInsight.daemon.impl.HighlightingSessionImpl;
import com.intellij.codeInsight.daemon.impl.ShowIntentionsPass;
import com.intellij.codeInsight.daemon.impl.TextEditorHighlightingPassRegistrarImpl;
import com.intellij.concurrency.Job;
import com.intellij.concurrency.JobLauncher;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ex.ApplicationManagerEx;
import com.intellij.openapi.application.ex.ApplicationUtil;
import com.intellij.openapi.application.impl.ApplicationImpl;
import com.intellij.openapi.application.impl.ApplicationInfoImpl;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.EditorActivityManager;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.fileEditor.FileEditor;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.fileEditor.TextEditor;
import com.intellij.openapi.fileEditor.ex.FileEditorManagerEx;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.Function;
import com.intellij.util.Functions;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.MultiMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.objects.ObjectIterator;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CancellationException;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ForkJoinPool;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

final class PassExecutorService
implements Disposable {
    static final Logger LOG = Logger.getInstance(PassExecutorService.class);
    private static final boolean CHECK_CONSISTENCY = ApplicationManager.getApplication().isUnitTestMode();
    private final Map<ScheduledPass, Job<Void>> mySubmittedPasses = new ConcurrentHashMap<ScheduledPass, Job<Void>>();
    private final Project myProject;
    private volatile boolean isDisposed;
    private final AtomicInteger nextAvailablePassId;
    private static final Key<Throwable> THROWABLE_KEY = Key.create((String)"THROWABLE_KEY");

    PassExecutorService(@NotNull Project project) {
        this.myProject = project;
        this.nextAvailablePassId = ((TextEditorHighlightingPassRegistrarImpl)TextEditorHighlightingPassRegistrar.getInstance(this.myProject)).getNextAvailableId();
    }

    public void dispose() {
        this.cancelAll(true);
        ForkJoinPool.commonPool().awaitQuiescence(1L, TimeUnit.SECONDS);
        this.isDisposed = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void cancelAll(boolean waitForTermination) {
        for (Map.Entry<ScheduledPass, Job<Void>> entry : this.mySubmittedPasses.entrySet()) {
            Job<Void> job2 = entry.getValue();
            ScheduledPass pass = entry.getKey();
            pass.myUpdateProgress.cancel();
            job2.cancel();
        }
        try {
            if (waitForTermination) {
                while (!this.waitFor(50)) {
                    boolean bl = false;
                }
            }
        }
        catch (ProcessCanceledException processCanceledException) {
        }
        catch (Error | RuntimeException e) {
            throw e;
        }
        catch (Throwable throwable) {
            LOG.error(throwable);
        }
        finally {
            this.mySubmittedPasses.clear();
        }
    }

    void submitPasses(@NotNull Map<FileEditor, HighlightingPass[]> passesMap, @NotNull DaemonProgressIndicator updateProgress) {
        if (this.isDisposed()) {
            return;
        }
        ApplicationManager.getApplication().assertIsDispatchThread();
        MultiMap documentToEditors = MultiMap.createSet();
        MultiMap documentBoundPasses = new MultiMap();
        MultiMap editorBoundPasses = new MultiMap();
        Object2ObjectOpenHashMap id2Pass = new Object2ObjectOpenHashMap();
        ArrayList<ScheduledPass> freePasses = new ArrayList<ScheduledPass>(documentToEditors.size() * 5);
        AtomicInteger threadsToStartCountdown = new AtomicInteger(0);
        for (Map.Entry<FileEditor, HighlightingPass[]> entry : passesMap.entrySet()) {
            HighlightingPass[] passes;
            FileEditor fileEditor = entry.getKey();
            for (HighlightingPass pass : passes = entry.getValue()) {
                Int2ObjectMap thisEditorId2Pass = id2Pass.computeIfAbsent(fileEditor, __ -> new Int2ObjectOpenHashMap(20));
                if (pass instanceof EditorBoundHighlightingPass) {
                    EditorBoundHighlightingPass editorPass = (EditorBoundHighlightingPass)pass;
                    int id2 = this.nextAvailablePassId.incrementAndGet();
                    editorPass.setId(id2);
                    PassExecutorService.checkUniquePassId(id2, editorPass, (Int2ObjectMap<TextEditorHighlightingPass>)thisEditorId2Pass);
                    editorBoundPasses.putValue((Object)fileEditor, (Object)editorPass);
                    continue;
                }
                if (pass instanceof TextEditorHighlightingPass) {
                    TextEditorHighlightingPass tePass = (TextEditorHighlightingPass)pass;
                    PassExecutorService.checkUniquePassId(tePass.getId(), tePass, (Int2ObjectMap<TextEditorHighlightingPass>)thisEditorId2Pass);
                    documentBoundPasses.putValue((Object)fileEditor, (Object)tePass);
                    documentToEditors.putValue((Object)tePass.getDocument(), (Object)fileEditor);
                    continue;
                }
                freePasses.add(new ScheduledPass(fileEditor, pass, updateProgress, threadsToStartCountdown));
            }
        }
        ArrayList<ScheduledPass> dependentPasses = new ArrayList<ScheduledPass>(documentToEditors.size() * 10);
        Object2ObjectOpenHashMap toBeSubmitted = new Object2ObjectOpenHashMap(passesMap.size());
        for (Map.Entry entry : documentToEditors.entrySet()) {
            Collection fileEditors = (Collection)entry.getValue();
            Document document = (Document)entry.getKey();
            FileEditor preferredFileEditor = this.getPreferredFileEditor(document, fileEditors);
            List passes = (List)documentBoundPasses.get((Object)preferredFileEditor);
            if (passes.isEmpty()) continue;
            PassExecutorService.sortById(passes);
            for (TextEditorHighlightingPass currentPass : passes) {
                this.createScheduledPass(preferredFileEditor, currentPass, (Map<FileEditor, Int2ObjectMap<ScheduledPass>>)toBeSubmitted, (Map<FileEditor, Int2ObjectMap<TextEditorHighlightingPass>>)id2Pass, freePasses, dependentPasses, updateProgress, threadsToStartCountdown);
            }
        }
        for (Map.Entry entry : editorBoundPasses.entrySet()) {
            FileEditor fileEditor = (FileEditor)entry.getKey();
            Collection createdEditorBoundPasses = (Collection)entry.getValue();
            for (HighlightingPass pass : createdEditorBoundPasses) {
                this.createScheduledPass(fileEditor, (TextEditorHighlightingPass)pass, (Map<FileEditor, Int2ObjectMap<ScheduledPass>>)toBeSubmitted, (Map<FileEditor, Int2ObjectMap<TextEditorHighlightingPass>>)id2Pass, freePasses, dependentPasses, updateProgress, threadsToStartCountdown);
            }
        }
        if (CHECK_CONSISTENCY && !ApplicationInfoImpl.isInStressTest()) {
            this.assertConsistency(freePasses, (Map<FileEditor, Int2ObjectMap<ScheduledPass>>)toBeSubmitted, threadsToStartCountdown);
        }
        if (LOG.isDebugEnabled()) {
            Set vFiles = ContainerUtil.map2Set(passesMap.keySet(), fe -> ((FileEditorManagerEx)FileEditorManager.getInstance((Project)this.myProject)).getFile((FileEditor)fe));
            PassExecutorService.log(updateProgress, null, vFiles + " ----- starting " + threadsToStartCountdown.get(), freePasses);
        }
        for (ScheduledPass dependentPass : dependentPasses) {
            this.mySubmittedPasses.put(dependentPass, Job.nullJob());
        }
        for (ScheduledPass freePass : freePasses) {
            this.submit(freePass);
        }
    }

    private static void checkUniquePassId(int id2, @NotNull TextEditorHighlightingPass pass, @NotNull Int2ObjectMap<TextEditorHighlightingPass> id2Pass) {
        TextEditorHighlightingPass prevPass = (TextEditorHighlightingPass)id2Pass.put(id2, (Object)pass);
        if (prevPass != null) {
            LOG.error("Duplicate pass id found: " + id2 + ". Both passes returned the same getId(): " + prevPass + " (" + prevPass.getClass() + ") and " + pass + " (" + pass.getClass() + ")");
        }
    }

    private void assertConsistency(@NotNull List<ScheduledPass> freePasses, @NotNull Map<FileEditor, Int2ObjectMap<ScheduledPass>> toBeSubmitted, @NotNull AtomicInteger threadsToStartCountdown) {
        assert (threadsToStartCountdown.get() == toBeSubmitted.values().stream().mapToInt(m -> m.size()).sum());
        Int2ObjectOpenHashMap id2Visits = new Int2ObjectOpenHashMap();
        for (ScheduledPass freePass : freePasses) {
            HighlightingPass pass = freePass.myPass;
            if (!(pass instanceof TextEditorHighlightingPass)) continue;
            id2Visits.put(((TextEditorHighlightingPass)pass).getId(), (Object)Pair.create((Object)freePass, (Object)0));
            this.checkConsistency(freePass, (Int2ObjectMap<Pair<ScheduledPass, Integer>>)id2Visits);
        }
        ObjectIterator iterator2 = id2Visits.int2ObjectEntrySet().fastIterator();
        while (iterator2.hasNext()) {
            Int2ObjectMap.Entry entry = (Int2ObjectMap.Entry)iterator2.next();
            int count = (Integer)((Pair)entry.getValue()).second;
            assert (count == 0) : entry.getIntKey();
        }
        assert (id2Visits.size() == threadsToStartCountdown.get());
    }

    private void checkConsistency(@NotNull ScheduledPass pass, @NotNull Int2ObjectMap<Pair<ScheduledPass, Integer>> id2Visits) {
        for (ScheduledPass succ : ContainerUtil.concat((List)pass.mySuccessorsOnCompletion, (List)pass.mySuccessorsOnSubmit)) {
            int succId = ((TextEditorHighlightingPass)succ.myPass).getId();
            Pair succPair = (Pair)id2Visits.get(succId);
            if (succPair == null) {
                succPair = Pair.create((Object)succ, (Object)succ.myRunningPredecessorsCount.get());
                id2Visits.put(succId, (Object)succPair);
            }
            int newPred = (Integer)succPair.second - 1;
            id2Visits.put(succId, (Object)Pair.create((Object)succ, (Object)newPred));
            assert (newPred >= 0);
            if (newPred != 0) continue;
            this.checkConsistency(succ, id2Visits);
        }
    }

    @NotNull
    private FileEditor getPreferredFileEditor(@NotNull Document document, @NotNull Collection<? extends FileEditor> fileEditors) {
        FileEditor selected2;
        assert (!fileEditors.isEmpty());
        FileEditor focusedEditor = (FileEditor)ContainerUtil.find(fileEditors, it -> it instanceof TextEditor && ((TextEditor)it).getEditor().getContentComponent().isFocusOwner());
        if (focusedEditor != null) {
            return focusedEditor;
        }
        VirtualFile file2 = FileDocumentManager.getInstance().getFile(document);
        if (file2 != null && (selected2 = FileEditorManager.getInstance((Project)this.myProject).getSelectedEditor(file2)) != null && fileEditors.contains(selected2)) {
            return selected2;
        }
        return fileEditors.iterator().next();
    }

    @NotNull
    private ScheduledPass createScheduledPass(@NotNull FileEditor fileEditor, @NotNull TextEditorHighlightingPass pass, @NotNull Map<FileEditor, Int2ObjectMap<ScheduledPass>> toBeSubmitted, @NotNull Map<FileEditor, Int2ObjectMap<TextEditorHighlightingPass>> id2Pass, @NotNull List<ScheduledPass> freePasses, @NotNull List<ScheduledPass> dependentPasses, @NotNull DaemonProgressIndicator updateProgress, @NotNull AtomicInteger threadsToStartCountdown) {
        ScheduledPass predecessor;
        Int2ObjectMap thisEditorId2ScheduledPass = toBeSubmitted.computeIfAbsent(fileEditor, __ -> new Int2ObjectOpenHashMap(20));
        Int2ObjectMap thisEditorId2Pass = id2Pass.computeIfAbsent(fileEditor, __ -> new Int2ObjectOpenHashMap(20));
        int passId = pass.getId();
        ScheduledPass scheduledPass = (ScheduledPass)thisEditorId2ScheduledPass.get(passId);
        if (scheduledPass != null) {
            return scheduledPass;
        }
        scheduledPass = new ScheduledPass(fileEditor, pass, updateProgress, threadsToStartCountdown);
        threadsToStartCountdown.incrementAndGet();
        thisEditorId2ScheduledPass.put(passId, (Object)scheduledPass);
        for (int predecessorId : pass.getCompletionPredecessorIds()) {
            predecessor = this.findOrCreatePredecessorPass(fileEditor, toBeSubmitted, id2Pass, freePasses, dependentPasses, updateProgress, threadsToStartCountdown, predecessorId, (Int2ObjectMap<ScheduledPass>)thisEditorId2ScheduledPass, (Int2ObjectMap<TextEditorHighlightingPass>)thisEditorId2Pass);
            if (predecessor == null) continue;
            predecessor.addSuccessorOnCompletion(scheduledPass);
        }
        for (int predecessorId : pass.getStartingPredecessorIds()) {
            predecessor = this.findOrCreatePredecessorPass(fileEditor, toBeSubmitted, id2Pass, freePasses, dependentPasses, updateProgress, threadsToStartCountdown, predecessorId, (Int2ObjectMap<ScheduledPass>)thisEditorId2ScheduledPass, (Int2ObjectMap<TextEditorHighlightingPass>)thisEditorId2Pass);
            if (predecessor == null) continue;
            predecessor.addSuccessorOnSubmit(scheduledPass);
        }
        if (scheduledPass.myRunningPredecessorsCount.get() == 0 && !freePasses.contains(scheduledPass)) {
            freePasses.add(scheduledPass);
        } else if (!dependentPasses.contains(scheduledPass)) {
            dependentPasses.add(scheduledPass);
        }
        if (pass.isRunIntentionPassAfter() && fileEditor instanceof TextEditor) {
            Editor editor = ((TextEditor)fileEditor).getEditor();
            ShowIntentionsPass ip = new ShowIntentionsPass(this.myProject, editor, false);
            int id2 = this.nextAvailablePassId.incrementAndGet();
            ip.setId(id2);
            PassExecutorService.checkUniquePassId(id2, ip, (Int2ObjectMap<TextEditorHighlightingPass>)thisEditorId2Pass);
            ip.setCompletionPredecessorIds(new int[]{passId});
            this.createScheduledPass(fileEditor, ip, toBeSubmitted, id2Pass, freePasses, dependentPasses, updateProgress, threadsToStartCountdown);
        }
        return scheduledPass;
    }

    private ScheduledPass findOrCreatePredecessorPass(@NotNull FileEditor fileEditor, @NotNull Map<FileEditor, Int2ObjectMap<ScheduledPass>> toBeSubmitted, @NotNull Map<FileEditor, Int2ObjectMap<TextEditorHighlightingPass>> id2Pass, @NotNull List<ScheduledPass> freePasses, @NotNull List<ScheduledPass> dependentPasses, @NotNull DaemonProgressIndicator updateProgress, @NotNull AtomicInteger myThreadsToStartCountdown, int predecessorId, @NotNull Int2ObjectMap<ScheduledPass> thisEditorId2ScheduledPass, @NotNull Int2ObjectMap<TextEditorHighlightingPass> thisEditorId2Pass) {
        ScheduledPass predecessor = (ScheduledPass)thisEditorId2ScheduledPass.get(predecessorId);
        if (predecessor == null) {
            TextEditorHighlightingPass textEditorPass = (TextEditorHighlightingPass)thisEditorId2Pass.get(predecessorId);
            predecessor = textEditorPass == null ? null : this.createScheduledPass(fileEditor, textEditorPass, toBeSubmitted, id2Pass, freePasses, dependentPasses, updateProgress, myThreadsToStartCountdown);
        }
        return predecessor;
    }

    private void submit(@NotNull ScheduledPass pass) {
        if (!pass.myUpdateProgress.isCanceled()) {
            Job<Void> job2 = JobLauncher.getInstance().submitToJobThread(pass, future2 -> {
                try {
                    if (!future2.isCancelled()) {
                        future2.get();
                    }
                }
                catch (InterruptedException | CancellationException exception) {
                }
                catch (ExecutionException e) {
                    LOG.error(e.getCause());
                }
            });
            this.mySubmittedPasses.put(pass, job2);
        }
    }

    private void applyInformationToEditorsLater(@NotNull FileEditor fileEditor, @NotNull HighlightingPass pass, @NotNull DaemonProgressIndicator updateProgress, @NotNull AtomicInteger threadsToStartCountdown, @NotNull Runnable callbackOnApplied) {
        ApplicationManager.getApplication().invokeLater(() -> {
            if (this.isDisposed() || !fileEditor.isValid()) {
                updateProgress.cancel();
            }
            if (updateProgress.isCanceled()) {
                PassExecutorService.log(updateProgress, pass, " is canceled during apply, sorry");
                return;
            }
            try {
                if (fileEditor instanceof TextEditor && EditorActivityManager.getInstance().isVisible(((TextEditor)fileEditor).getEditor()) || fileEditor.getComponent().isDisplayable()) {
                    pass.applyInformationToEditor();
                    this.repaintErrorStripeAndIcon(fileEditor);
                    if (pass instanceof TextEditorHighlightingPass) {
                        FileStatusMap fileStatusMap = DaemonCodeAnalyzerEx.getInstanceEx(this.myProject).getFileStatusMap();
                        Document document = ((TextEditorHighlightingPass)pass).getDocument();
                        int passId = ((TextEditorHighlightingPass)pass).getId();
                        fileStatusMap.markFileUpToDate(document, passId);
                    }
                    PassExecutorService.log(updateProgress, pass, " Applied");
                }
            }
            catch (ProcessCanceledException e) {
                PassExecutorService.log(updateProgress, pass, "Error " + (Object)((Object)e));
                throw e;
            }
            catch (RuntimeException e) {
                VirtualFile file2 = FileEditorManagerEx.getInstanceEx(this.myProject).getFile(fileEditor);
                FileType fileType = file2 == null ? null : file2.getFileType();
                String message = "Exception while applying information to " + fileEditor + "(" + fileType + ")";
                PassExecutorService.log(updateProgress, pass, message + e);
                throw new RuntimeException(message, e);
            }
            if (threadsToStartCountdown.decrementAndGet() == 0) {
                HighlightingSessionImpl.waitForAllSessionsHighlightInfosApplied(updateProgress);
                PassExecutorService.log(updateProgress, pass, "Stopping ");
                updateProgress.stopIfRunning();
                this.clearStaleEntries();
            } else {
                PassExecutorService.log(updateProgress, pass, "Finished but there are passes in the queue: " + threadsToStartCountdown.get());
            }
            callbackOnApplied.run();
        }, updateProgress.getModalityState());
    }

    private void clearStaleEntries() {
        this.mySubmittedPasses.keySet().removeIf(pass -> ((ScheduledPass)pass).myUpdateProgress.isCanceled());
    }

    private void repaintErrorStripeAndIcon(@NotNull FileEditor fileEditor) {
        if (fileEditor instanceof TextEditor) {
            DefaultHighlightInfoProcessor.repaintErrorStripeAndIcon(((TextEditor)fileEditor).getEditor(), this.myProject);
        }
    }

    private boolean isDisposed() {
        return this.isDisposed || this.myProject.isDisposed();
    }

    @NotNull
    List<HighlightingPass> getAllSubmittedPasses() {
        ArrayList<HighlightingPass> result2 = new ArrayList<HighlightingPass>(this.mySubmittedPasses.size());
        for (ScheduledPass scheduledPass : this.mySubmittedPasses.keySet()) {
            if (scheduledPass.myUpdateProgress.isCanceled()) continue;
            result2.add(scheduledPass.myPass);
        }
        return result2;
    }

    private static void sortById(@NotNull List<? extends TextEditorHighlightingPass> result2) {
        ContainerUtil.quickSort(result2, Comparator.comparingInt(TextEditorHighlightingPass::getId));
    }

    private static int getThreadNum() {
        Matcher matcher = Pattern.compile("JobScheduler FJ pool (\\d*)/(\\d*)").matcher(Thread.currentThread().getName());
        String num = matcher.matches() ? matcher.group(1) : null;
        return StringUtil.parseInt((String)num, (int)0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    static void log(ProgressIndicator progressIndicator2, HighlightingPass pass, Object ... info) {
        if (!LOG.isDebugEnabled()) return;
        Document document = pass instanceof TextEditorHighlightingPass ? ((TextEditorHighlightingPass)pass).getDocument() : null;
        String docText = document == null ? "" : ": '" + StringUtil.first((CharSequence)document.getCharsSequence(), (int)10, (boolean)true) + "'";
        Class<PassExecutorService> clazz = PassExecutorService.class;
        synchronized (PassExecutorService.class) {
            String infos = StringUtil.join((Object[])info, (Function)Functions.TO_STRING(), (String)" ");
            String message = StringUtil.repeatSymbol((char)' ', (int)(PassExecutorService.getThreadNum() * 4)) + " " + pass + " " + infos + "; progress=" + (progressIndicator2 == null ? null : Integer.valueOf(progressIndicator2.hashCode())) + " " + (progressIndicator2 == null ? "?" : (progressIndicator2.isCanceled() ? "X" : "V")) + docText;
            LOG.debug(message);
            // ** MonitorExit[var5_5] (shouldn't be in output)
            return;
        }
    }

    private static void saveException(@NotNull Throwable e, @NotNull DaemonProgressIndicator indicator) {
        indicator.putUserDataIfAbsent(THROWABLE_KEY, e);
    }

    static Throwable getSavedException(@NotNull DaemonProgressIndicator indicator) {
        return (Throwable)indicator.getUserData(THROWABLE_KEY);
    }

    boolean waitFor(int millis) throws Throwable {
        try {
            for (Job<Void> job2 : this.mySubmittedPasses.values()) {
                job2.waitForCompletion(millis);
            }
            return true;
        }
        catch (TimeoutException ignored) {
            return false;
        }
        catch (InterruptedException e) {
            return true;
        }
        catch (ExecutionException e) {
            throw e.getCause();
        }
    }

    private final class ScheduledPass
    implements Runnable {
        private final FileEditor myFileEditor;
        private final HighlightingPass myPass;
        private final AtomicInteger myThreadsToStartCountdown;
        private final AtomicInteger myRunningPredecessorsCount = new AtomicInteger(0);
        private final List<ScheduledPass> mySuccessorsOnCompletion = new ArrayList<ScheduledPass>();
        private final List<ScheduledPass> mySuccessorsOnSubmit = new ArrayList<ScheduledPass>();
        @NotNull
        private final DaemonProgressIndicator myUpdateProgress;

        private ScheduledPass(@NotNull FileEditor fileEditor, @NotNull HighlightingPass pass, @NotNull DaemonProgressIndicator progressIndicator2, AtomicInteger threadsToStartCountdown) {
            this.myFileEditor = fileEditor;
            this.myPass = pass;
            this.myThreadsToStartCountdown = threadsToStartCountdown;
            this.myUpdateProgress = progressIndicator2;
        }

        @Override
        public void run() {
            ((ApplicationImpl)ApplicationManager.getApplication()).executeByImpatientReader(() -> {
                try {
                    this.doRun();
                }
                catch (ApplicationUtil.CannotRunReadActionException e) {
                    this.myUpdateProgress.cancel();
                }
                catch (Error | RuntimeException e) {
                    PassExecutorService.saveException(e, this.myUpdateProgress);
                    throw e;
                }
            });
        }

        private void doRun() {
            if (this.myUpdateProgress.isCanceled()) {
                return;
            }
            PassExecutorService.log(this.myUpdateProgress, this.myPass, "Started. ");
            for (ScheduledPass successor : this.mySuccessorsOnSubmit) {
                int predecessorsToRun = successor.myRunningPredecessorsCount.decrementAndGet();
                if (predecessorsToRun != 0) continue;
                PassExecutorService.this.submit(successor);
            }
            ProgressManager.getInstance().executeProcessUnderProgress(() -> {
                boolean success = ApplicationManagerEx.getApplicationEx().tryRunReadAction(() -> {
                    try {
                        if (DumbService.getInstance((Project)PassExecutorService.this.myProject).isDumb() && !DumbService.isDumbAware((Object)this.myPass)) {
                            return;
                        }
                        if (!this.myUpdateProgress.isCanceled() && !PassExecutorService.this.myProject.isDisposed()) {
                            this.myPass.collectInformation((ProgressIndicator)this.myUpdateProgress);
                        }
                    }
                    catch (ProcessCanceledException e) {
                        PassExecutorService.log(this.myUpdateProgress, this.myPass, "Canceled ");
                        if (!this.myUpdateProgress.isCanceled()) {
                            this.myUpdateProgress.cancel(e);
                        }
                    }
                    catch (Error | RuntimeException e) {
                        this.myUpdateProgress.cancel(e);
                        LOG.error(e);
                        throw e;
                    }
                });
                if (!success) {
                    this.myUpdateProgress.cancel();
                }
            }, (ProgressIndicator)this.myUpdateProgress);
            PassExecutorService.log(this.myUpdateProgress, this.myPass, "Finished. ");
            if (!this.myUpdateProgress.isCanceled()) {
                PassExecutorService.this.applyInformationToEditorsLater(this.myFileEditor, this.myPass, this.myUpdateProgress, this.myThreadsToStartCountdown, () -> {
                    for (ScheduledPass successor : this.mySuccessorsOnCompletion) {
                        int predecessorsToRun = successor.myRunningPredecessorsCount.decrementAndGet();
                        if (predecessorsToRun != 0) continue;
                        PassExecutorService.this.submit(successor);
                    }
                });
            }
        }

        @NonNls
        public String toString() {
            return "SP: " + this.myPass;
        }

        private void addSuccessorOnCompletion(@NotNull ScheduledPass successor) {
            this.mySuccessorsOnCompletion.add(successor);
            successor.myRunningPredecessorsCount.incrementAndGet();
        }

        private void addSuccessorOnSubmit(@NotNull ScheduledPass successor) {
            this.mySuccessorsOnSubmit.add(successor);
            successor.myRunningPredecessorsCount.incrementAndGet();
        }
    }
}

