/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.daemon.impl;

import com.intellij.codeInsight.daemon.impl.HighlightInfo;
import com.intellij.openapi.editor.RangeMarker;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.TextRange;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.xml.util.XmlStringUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class HighlightInfoComposite
extends HighlightInfo {
    @NonNls
    private static final String LINE_BREAK = "<hr size=1 noshade>";

    private HighlightInfoComposite(@NotNull List<? extends HighlightInfo> infos, @NotNull HighlightInfo anchorInfo) {
        super(null, null, anchorInfo.type, anchorInfo.startOffset, anchorInfo.endOffset, HighlightInfoComposite.createCompositeDescription(infos), HighlightInfoComposite.createCompositeTooltip(infos), anchorInfo.type.getSeverity(null), false, null, false, 0, anchorInfo.getProblemGroup(), null, anchorInfo.getGutterIconRenderer(), anchorInfo.getGroup());
        this.highlighter = anchorInfo.getHighlighter();
        ArrayList<Pair<HighlightInfo.IntentionActionDescriptor, RangeMarker>> markers = ContainerUtil.emptyList();
        ArrayList<Pair<HighlightInfo.IntentionActionDescriptor, TextRange>> ranges = ContainerUtil.emptyList();
        for (HighlightInfo highlightInfo : infos) {
            if (highlightInfo.quickFixActionMarkers != null) {
                if (markers == ContainerUtil.emptyList()) {
                    markers = new ArrayList<Pair<HighlightInfo.IntentionActionDescriptor, RangeMarker>>();
                }
                markers.addAll(highlightInfo.quickFixActionMarkers);
            }
            if (highlightInfo.quickFixActionRanges == null) continue;
            if (ranges == ContainerUtil.emptyList()) {
                ranges = new ArrayList<Pair<HighlightInfo.IntentionActionDescriptor, TextRange>>();
            }
            ranges.addAll(highlightInfo.quickFixActionRanges);
        }
        this.quickFixActionMarkers = ContainerUtil.createLockFreeCopyOnWriteList((Collection)markers);
        this.quickFixActionRanges = ContainerUtil.createLockFreeCopyOnWriteList((Collection)ranges);
    }

    @NotNull
    static HighlightInfoComposite create(@NotNull List<? extends HighlightInfo> infos) {
        HighlightInfo anchorInfo = (HighlightInfo)ContainerUtil.find(infos, info -> info.getToolTip() != null);
        if (anchorInfo == null) {
            anchorInfo = infos.get(0);
        }
        return new HighlightInfoComposite(infos, anchorInfo);
    }

    @Nullable
    private static String createCompositeDescription(@NotNull List<? extends HighlightInfo> infos) {
        StringBuilder description = new StringBuilder();
        boolean isNull = true;
        for (HighlightInfo highlightInfo : infos) {
            String itemDescription = highlightInfo.getDescription();
            if (itemDescription == null) continue;
            itemDescription = itemDescription.trim();
            description.append(itemDescription);
            if (!itemDescription.endsWith(".")) {
                description.append('.');
            }
            description.append(' ');
            isNull = false;
        }
        return isNull ? null : description.toString();
    }

    @Nullable
    private static String createCompositeTooltip(@NotNull List<? extends HighlightInfo> infos) {
        StringBuilder result2 = new StringBuilder();
        for (HighlightInfo highlightInfo : infos) {
            String toolTip = highlightInfo.getToolTip();
            if (toolTip == null) continue;
            if (result2.length() != 0) {
                result2.append(LINE_BREAK);
            }
            toolTip = XmlStringUtil.stripHtml((String)toolTip);
            result2.append(toolTip);
        }
        if (result2.length() == 0) {
            return null;
        }
        return XmlStringUtil.wrapInHtml((CharSequence)result2);
    }
}

