/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.daemon.impl;

import com.intellij.codeInsight.daemon.impl.GutterIntentionAction;
import com.intellij.codeInsight.daemon.impl.HighlightInfo;
import com.intellij.codeInsight.daemon.impl.IntentionMenuContributor;
import com.intellij.codeInsight.daemon.impl.ShowIntentionsPass;
import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.execution.lineMarker.LineMarkerActionWrapper;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.ex.EditorEx;
import com.intellij.openapi.editor.ex.MarkupModelEx;
import com.intellij.openapi.editor.ex.RangeHighlighterEx;
import com.intellij.openapi.editor.impl.DocumentMarkupModel;
import com.intellij.openapi.editor.markup.GutterIconRenderer;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiFile;
import com.intellij.util.ArrayUtil;
import com.intellij.util.Processor;
import com.intellij.util.Processors;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.ui.EmptyIcon;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;

public class GutterIntentionMenuContributor
implements IntentionMenuContributor {
    @Override
    public void collectActions(@NotNull Editor hostEditor, @NotNull PsiFile hostFile, @NotNull ShowIntentionsPass.IntentionsInfo intentions, int passIdToShowIntentionsFor, int offset) {
        Project project = hostFile.getProject();
        Document hostDocument = hostEditor.getDocument();
        int line = hostDocument.getLineNumber(offset);
        MarkupModelEx model = (MarkupModelEx)DocumentMarkupModel.forDocument(hostDocument, project, true);
        ArrayList result2 = new ArrayList();
        Processor processor2 = Processors.cancelableCollectProcessor(result2);
        model.processRangeHighlightersOverlappingWith(hostDocument.getLineStartOffset(line), hostDocument.getLineEndOffset(line), (Processor<? super RangeHighlighterEx>)processor2);
        for (RangeHighlighterEx highlighter : result2) {
            GutterIntentionMenuContributor.addActions(project, highlighter, intentions.guttersToShow, ((EditorEx)hostEditor).getDataContext());
        }
    }

    private static void addActions(@NotNull Project project, @NotNull RangeHighlighterEx info, @NotNull List<? super HighlightInfo.IntentionActionDescriptor> descriptors, @NotNull DataContext dataContext) {
        GutterIconRenderer r = info.getGutterIconRenderer();
        if (r == null || DumbService.isDumb((Project)project) && !DumbService.isDumbAware((Object)r)) {
            return;
        }
        ArrayList list2 = new ArrayList();
        AtomicInteger order = new AtomicInteger();
        Object[] actions = new AnAction[]{r.getClickAction(), r.getMiddleButtonClickAction(), r.getRightButtonClickAction()};
        if (r.getPopupMenuActions() != null) {
            actions = (AnAction[])ArrayUtil.mergeArrays((Object[])actions, (Object[])r.getPopupMenuActions().getChildren(null));
        }
        for (Object action2 : actions) {
            if (action2 == null) continue;
            GutterIntentionMenuContributor.addActions((AnAction)action2, list2, r, order, dataContext);
        }
        descriptors.addAll(list2);
    }

    private static void addActions(@NotNull AnAction action2, @NotNull List<? super HighlightInfo.IntentionActionDescriptor> descriptors, @NotNull GutterIconRenderer renderer, AtomicInteger order, @NotNull DataContext dataContext) {
        GutterIntentionAction gutterAction;
        Icon icon2;
        AnAction[] children2;
        if (action2 instanceof LineMarkerActionWrapper && (children2 = Arrays.asList(((LineMarkerActionWrapper)action2).getChildren(null))).size() > 0 && ContainerUtil.all((Collection)children2, o -> o instanceof LineMarkerActionWrapper)) {
            for (AnAction child2 : children2) {
                GutterIntentionMenuContributor.addActions(child2, descriptors, renderer, order, dataContext);
            }
            return;
        }
        if (action2 instanceof ActionGroup) {
            for (AnAction child3 : ((ActionGroup)action2).getChildren(null)) {
                GutterIntentionMenuContributor.addActions(child3, descriptors, renderer, order, dataContext);
            }
        }
        if ((icon2 = action2.getTemplatePresentation().getIcon()) == null) {
            icon2 = EmptyIcon.ICON_16;
        }
        if (!(gutterAction = new GutterIntentionAction(action2, order.getAndIncrement(), icon2)).isAvailable(dataContext)) {
            return;
        }
        descriptors.add(new HighlightInfo.IntentionActionDescriptor((IntentionAction)gutterAction, Collections.emptyList(), null, icon2){

            @Override
            @NotNull
            public String getDisplayName() {
                return gutterAction.getText();
            }
        });
    }
}

