/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.daemon.impl;

import com.intellij.codeInsight.CodeInsightBundle;
import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.codeInspection.ex.InspectionToolWrapper;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.options.Configurable;
import com.intellij.openapi.options.ShowSettingsUtil;
import com.intellij.openapi.project.Project;
import com.intellij.profile.codeInspection.ProjectInspectionProfileManager;
import com.intellij.profile.codeInspection.ui.ProjectInspectionToolsConfigurable;
import com.intellij.psi.PsiFile;
import com.intellij.util.IncorrectOperationException;
import org.jetbrains.annotations.NotNull;

public class EditCleanupProfileIntentionAction
implements IntentionAction {
    public static final EditCleanupProfileIntentionAction INSTANCE = new EditCleanupProfileIntentionAction();

    private EditCleanupProfileIntentionAction() {
    }

    @NotNull
    public String getText() {
        return this.getFamilyName();
    }

    @NotNull
    public String getFamilyName() {
        return CodeInsightBundle.message((String)"intention.family.edit.cleanup.profile.settings", (Object[])new Object[0]);
    }

    public boolean isAvailable(@NotNull Project project, Editor editor, PsiFile file2) {
        return true;
    }

    public void invoke(@NotNull Project project, Editor editor, PsiFile file2) throws IncorrectOperationException {
        ProjectInspectionProfileManager profileManager = ProjectInspectionProfileManager.getInstance(project);
        ProjectInspectionToolsConfigurable configurable2 = new ProjectInspectionToolsConfigurable(profileManager){

            @Override
            protected boolean acceptTool(InspectionToolWrapper entry) {
                return super.acceptTool(entry) && entry.isCleanupTool();
            }

            @Override
            public String getDisplayName() {
                return "Code Cleanup Inspections";
            }
        };
        ShowSettingsUtil.getInstance().editConfigurable(project, (Configurable)configurable2);
    }

    public boolean startInWriteAction() {
        return false;
    }
}

