/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.daemon.impl;

import com.intellij.codeInsight.daemon.impl.DaemonTooltipAction;
import com.intellij.codeInsight.daemon.impl.HighlightInfo;
import com.intellij.codeInsight.daemon.impl.ShowIntentionsPass;
import com.intellij.codeInsight.intention.AbstractEmptyIntentionAction;
import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.codeInsight.intention.IntentionActionDelegate;
import com.intellij.codeInsight.intention.impl.CachedIntentions;
import com.intellij.codeInsight.intention.impl.IntentionActionWithTextCaching;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.RangeMarker;
import com.intellij.openapi.editor.ex.TooltipAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiFile;
import com.intellij.xml.util.XmlStringUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.IntRange;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=2, d1={"\u0000*\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u001a \u0010\u0000\u001a\u0004\u0018\u00010\u00012\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007\u001a \u0010\b\u001a\u0004\u0018\u00010\u00012\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\t\u001a\u00020\n\u001a\u001e\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u00012\u0006\u0010\u000e\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005\u00a8\u0006\u000f"}, d2={"extractMostPriorityFixFromHighlightInfo", "Lcom/intellij/codeInsight/intention/IntentionAction;", "highlightInfo", "Lcom/intellij/codeInsight/daemon/impl/HighlightInfo;", "editor", "Lcom/intellij/openapi/editor/Editor;", "psiFile", "Lcom/intellij/psi/PsiFile;", "getFirstAvailableAction", "intentionsInfo", "Lcom/intellij/codeInsight/daemon/impl/ShowIntentionsPass$IntentionsInfo;", "wrapIntentionToTooltipAction", "Lcom/intellij/openapi/editor/ex/TooltipAction;", "intention", "info", "intellij.platform.lang.impl"})
public final class DaemonTooltipActionProviderKt {
    /*
     * WARNING - void declaration
     */
    @Nullable
    public static final IntentionAction extractMostPriorityFixFromHighlightInfo(@NotNull HighlightInfo highlightInfo, @NotNull Editor editor, @NotNull PsiFile psiFile) {
        Collection<HighlightInfo.IntentionActionDescriptor> collection;
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        ApplicationManager.getApplication().assertReadAccessAllowed();
        boolean bl = false;
        List fixes = new ArrayList();
        List<Pair<HighlightInfo.IntentionActionDescriptor, TextRange>> quickFixActionMarkers = highlightInfo.quickFixActionRanges;
        if (quickFixActionMarkers == null || quickFixActionMarkers.isEmpty()) {
            return null;
        }
        Iterable iterable = quickFixActionMarkers;
        List list2 = fixes;
        boolean $i$f$map = false;
        void var7_9 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            Pair pair = (Pair)item$iv$iv;
            collection = destination$iv$iv;
            boolean bl2 = false;
            HighlightInfo.IntentionActionDescriptor intentionActionDescriptor = (HighlightInfo.IntentionActionDescriptor)it.first;
            collection.add(intentionActionDescriptor);
        }
        collection = (List)destination$iv$iv;
        list2.addAll(CollectionsKt.toList((Iterable)collection));
        ShowIntentionsPass.IntentionsInfo intentionsInfo = new ShowIntentionsPass.IntentionsInfo();
        ShowIntentionsPass.fillIntentionsInfoForHighlightInfo(highlightInfo, intentionsInfo, fixes);
        intentionsInfo.filterActions(psiFile);
        return DaemonTooltipActionProviderKt.getFirstAvailableAction(psiFile, editor, intentionsInfo);
    }

    @Nullable
    public static final IntentionAction getFirstAvailableAction(@NotNull PsiFile psiFile, @NotNull Editor editor, @NotNull ShowIntentionsPass.IntentionsInfo intentionsInfo) {
        Project project = psiFile.getProject();
        CachedIntentions cachedIntentions = CachedIntentions.createAndUpdateActions(project, psiFile, editor, intentionsInfo);
        List<IntentionActionWithTextCaching> allActions = cachedIntentions.getAllActions();
        if (allActions.isEmpty()) {
            return null;
        }
        Iterable $this$forEach$iv = allActions;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            String text;
            IntentionActionWithTextCaching it = (IntentionActionWithTextCaching)element$iv;
            boolean bl = false;
            IntentionAction action2 = IntentionActionDelegate.unwrap((IntentionAction)it.getAction());
            if (action2 instanceof AbstractEmptyIntentionAction || !action2.isAvailable(project, editor, psiFile) || XmlStringUtil.isWrappedInHtml((String)(text = it.getText()))) continue;
            return action2;
        }
        return null;
    }

    /*
     * Enabled aggressive block sorting
     */
    @NotNull
    public static final TooltipAction wrapIntentionToTooltipAction(@NotNull IntentionAction intention, @NotNull HighlightInfo info, @NotNull Editor editor) {
        RangeMarker pair;
        RangeMarker rangeMarker;
        RangeMarker rangeMarker2;
        int editorOffset = editor.getCaretModel().getOffset();
        int n = info.getActualStartOffset();
        if (new IntRange(n, info.getActualEndOffset()).contains(editorOffset)) {
            return new DaemonTooltipAction(intention.getText(), editorOffset);
        }
        List<Pair<HighlightInfo.IntentionActionDescriptor, RangeMarker>> list2 = info.quickFixActionMarkers;
        if (list2 == null) {
            rangeMarker2 = null;
        } else {
            Object v3;
            block4: {
                Iterable iterable = list2;
                boolean bl = false;
                Iterable iterable2 = iterable;
                boolean bl2 = false;
                for (Object t : iterable2) {
                    Pair it = (Pair)t;
                    boolean bl3 = false;
                    HighlightInfo.IntentionActionDescriptor intentionActionDescriptor = (HighlightInfo.IntentionActionDescriptor)it.first;
                    if (!Intrinsics.areEqual((Object)(intentionActionDescriptor != null ? intentionActionDescriptor.getAction() : null), (Object)intention)) continue;
                    v3 = t;
                    break block4;
                }
                v3 = null;
            }
            rangeMarker2 = v3;
        }
        int offset = (rangeMarker = (pair = rangeMarker2)) != null && (rangeMarker = (RangeMarker)rangeMarker.second) != null && rangeMarker.isValid() ? ((RangeMarker)pair.second).getStartOffset() : info.getActualStartOffset();
        return new DaemonTooltipAction(intention.getText(), offset);
    }
}

