/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.daemon;

import com.intellij.codeInsight.daemon.DaemonCodeAnalyzer;
import com.intellij.lang.annotation.Annotation;
import com.intellij.lang.annotation.AnnotationSession;
import com.intellij.lang.annotation.Annotator;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiFile;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;

@ApiStatus.Internal
public class AnnotatorStatisticsCollector {
    private final Map<Annotator, DaemonCodeAnalyzer.DaemonListener.AnnotatorStatistics> myAnnotatorStats = new ConcurrentHashMap<Annotator, DaemonCodeAnalyzer.DaemonListener.AnnotatorStatistics>();

    public void reportAnnotationProduced(@NotNull Annotator annotator, @NotNull Annotation annotation) {
        DaemonCodeAnalyzer.DaemonListener.AnnotatorStatistics stat = this.myAnnotatorStats.computeIfAbsent(annotator, __ -> new DaemonCodeAnalyzer.DaemonListener.AnnotatorStatistics(annotator));
        if (stat.firstAnnotation == null) {
            stat.firstAnnotation = annotation;
            stat.firstAnnotationStamp = System.nanoTime();
        }
        stat.lastAnnotation = annotation;
        stat.lastAnnotationStamp = System.nanoTime();
    }

    public void reportAnalysisFinished(@NotNull Project project, @NotNull AnnotationSession session2, @NotNull PsiFile file2) {
        for (DaemonCodeAnalyzer.DaemonListener.AnnotatorStatistics stat : this.myAnnotatorStats.values()) {
            stat.annotatorFinishStamp = System.nanoTime();
        }
        ((DaemonCodeAnalyzer.DaemonListener)project.getMessageBus().syncPublisher(DaemonCodeAnalyzer.DAEMON_EVENT_TOPIC)).daemonAnnotatorStatisticsGenerated(session2, this.myAnnotatorStats.values(), file2);
        this.myAnnotatorStats.clear();
    }

    public void reportNewAnnotatorCreated(@NotNull Annotator annotator) {
        DaemonCodeAnalyzer.DaemonListener.AnnotatorStatistics stat = this.myAnnotatorStats.computeIfAbsent(annotator, __ -> new DaemonCodeAnalyzer.DaemonListener.AnnotatorStatistics(annotator));
        stat.annotatorStartStamp = System.nanoTime();
    }
}

