/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.actions;

import com.intellij.codeInsight.FileModificationService;
import com.intellij.codeInsight.actions.CodeInsightEditorAction;
import com.intellij.codeInsight.actions.MultiCaretCodeInsightActionHandler;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.command.CommandProcessor;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Caret;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.EditorModificationUtil;
import com.intellij.openapi.editor.ScrollType;
import com.intellij.openapi.editor.actionSystem.DocCommandGroupId;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Ref;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiFile;
import com.intellij.psi.impl.source.tree.injected.InjectedLanguageUtil;
import com.intellij.psi.util.PsiUtilBase;
import org.jetbrains.annotations.NotNull;

public abstract class MultiCaretCodeInsightAction
extends AnAction {
    private static final Logger LOG = Logger.getInstance(MultiCaretCodeInsightAction.class);

    public void actionPerformed(@NotNull AnActionEvent e) {
        Project project = e.getProject();
        if (project == null) {
            return;
        }
        Editor hostEditor = (Editor)e.getData(CommonDataKeys.EDITOR);
        if (hostEditor == null) {
            return;
        }
        if (hostEditor.isDisposed()) {
            LOG.error("Action " + (Object)((Object)this) + " invoked on a disposed editor in " + e.getDataContext());
            return;
        }
        if (!EditorModificationUtil.checkModificationAllowed((Editor)hostEditor)) {
            return;
        }
        PsiFile hostFile = PsiDocumentManager.getInstance((Project)project).getPsiFile(hostEditor.getDocument());
        if (hostFile != null && !FileModificationService.getInstance().prepareFileForWrite(hostFile)) {
            return;
        }
        this.actionPerformedImpl(project, hostEditor);
    }

    public void actionPerformedImpl(Project project, Editor hostEditor) {
        CommandProcessor.getInstance().executeCommand(project, () -> ApplicationManager.getApplication().runWriteAction(() -> {
            MultiCaretCodeInsightActionHandler handler2 = this.getHandler();
            try {
                MultiCaretCodeInsightAction.iterateOverCarets(project, hostEditor, handler2);
            }
            finally {
                handler2.postInvoke();
            }
        }), this.getCommandName(), (Object)DocCommandGroupId.noneGroupId((Document)hostEditor.getDocument()));
        hostEditor.getScrollingModel().scrollToCaret(ScrollType.RELATIVE);
    }

    public void beforeActionPerformedUpdate(@NotNull AnActionEvent e) {
        CodeInsightEditorAction.beforeActionPerformedUpdate((AnActionEvent)e);
        super.beforeActionPerformedUpdate(e);
    }

    public void update(@NotNull AnActionEvent e) {
        Presentation presentation2 = e.getPresentation();
        Project project = e.getProject();
        if (project == null) {
            presentation2.setEnabled(false);
            return;
        }
        Editor hostEditor = (Editor)e.getData(CommonDataKeys.EDITOR);
        if (hostEditor == null) {
            presentation2.setEnabled(false);
            return;
        }
        if (hostEditor.isDisposed()) {
            LOG.error("Disposed editor in " + e.getDataContext() + " for " + (Object)((Object)this));
            presentation2.setEnabled(false);
            return;
        }
        final Ref enabled = new Ref((Object)Boolean.FALSE);
        MultiCaretCodeInsightAction.iterateOverCarets(project, hostEditor, new MultiCaretCodeInsightActionHandler(){

            @Override
            public void invoke(@NotNull Project project, @NotNull Editor editor, @NotNull Caret caret, @NotNull PsiFile file2) {
                if (MultiCaretCodeInsightAction.this.isValidFor(project, editor, caret, file2)) {
                    enabled.set((Object)Boolean.TRUE);
                }
            }
        });
        presentation2.setEnabled(((Boolean)enabled.get()).booleanValue());
    }

    private static void iterateOverCarets(@NotNull Project project, @NotNull Editor hostEditor, @NotNull MultiCaretCodeInsightActionHandler handler2) {
        PsiFile hostFile = PsiDocumentManager.getInstance((Project)project).getPsiFile(hostEditor.getDocument());
        hostEditor.getCaretModel().runForEachCaret(caret -> {
            PsiFile file2;
            Caret injectedCaret;
            Editor editor = hostEditor;
            if (hostFile != null && (injectedCaret = InjectedLanguageUtil.getCaretForInjectedLanguageNoCommit(caret, hostFile)) != null) {
                caret = injectedCaret;
                editor = caret.getEditor();
            }
            if ((file2 = PsiUtilBase.getPsiFileInEditor((Caret)caret, (Project)project)) != null) {
                handler2.invoke(project, editor, caret, file2);
            }
        });
    }

    protected boolean isValidFor(@NotNull Project project, @NotNull Editor editor, @NotNull Caret caret, @NotNull PsiFile file2) {
        return true;
    }

    @NotNull
    protected abstract MultiCaretCodeInsightActionHandler getHandler();

    protected String getCommandName() {
        String text = this.getTemplatePresentation().getText();
        return text == null ? "" : text;
    }
}

