/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.actions;

import com.intellij.codeInsight.actions.ReformatCodeRunOptions;
import com.intellij.codeInsight.actions.TextRangeType;
import com.intellij.ide.util.PropertiesComponent;
import com.intellij.lang.Language;
import com.intellij.lang.StdLanguages;
import com.intellij.psi.PsiFile;
import org.jetbrains.annotations.NotNull;

public class LastRunReformatCodeOptionsProvider {
    private static final String OPTIMIZE_IMPORTS_KEY = "LayoutCode.optimizeImports";
    private static final String REARRANGE_ENTRIES_KEY = "LayoutCode.rearrangeEntries";
    private static final String CODE_CLEANUP_KEY = "LayoutCode.codeCleanup";
    private static final String PROCESS_CHANGED_TEXT_KEY = "LayoutCode.processChangedText";
    private final PropertiesComponent myPropertiesComponent;

    public LastRunReformatCodeOptionsProvider(@NotNull PropertiesComponent propertiesComponent) {
        this.myPropertiesComponent = propertiesComponent;
    }

    public ReformatCodeRunOptions getLastRunOptions(@NotNull PsiFile file2) {
        Language language = file2.getLanguage();
        ReformatCodeRunOptions settings = new ReformatCodeRunOptions(this.getLastTextRangeType());
        settings.setOptimizeImports(this.getLastOptimizeImports());
        settings.setRearrangeCode(this.isRearrangeCode(language));
        return settings;
    }

    public void saveRearrangeState(@NotNull Language language, boolean value2) {
        String key = LastRunReformatCodeOptionsProvider.getRearrangeCodeKeyFor(language);
        this.myPropertiesComponent.setValue(key, Boolean.toString(value2));
    }

    public void saveOptimizeImportsState(boolean value2) {
        String optimizeImports = Boolean.toString(value2);
        this.myPropertiesComponent.setValue(OPTIMIZE_IMPORTS_KEY, optimizeImports);
    }

    public boolean getLastOptimizeImports() {
        return this.myPropertiesComponent.getBoolean(OPTIMIZE_IMPORTS_KEY);
    }

    public TextRangeType getLastTextRangeType() {
        return this.myPropertiesComponent.getBoolean(PROCESS_CHANGED_TEXT_KEY) ? TextRangeType.VCS_CHANGED_TEXT : TextRangeType.WHOLE_FILE;
    }

    public void saveProcessVcsChangedTextState(boolean value2) {
        String processOnlyVcsChangedText = Boolean.toString(value2);
        this.myPropertiesComponent.setValue(PROCESS_CHANGED_TEXT_KEY, processOnlyVcsChangedText);
    }

    public void saveRearrangeCodeState(boolean value2) {
        this.myPropertiesComponent.setValue(REARRANGE_ENTRIES_KEY, value2);
    }

    public boolean getLastRearrangeCode() {
        return this.myPropertiesComponent.getBoolean(REARRANGE_ENTRIES_KEY);
    }

    public void saveCodeCleanupState(boolean value2) {
        this.myPropertiesComponent.setValue(CODE_CLEANUP_KEY, value2);
    }

    public boolean getLastCodeCleanup() {
        return this.myPropertiesComponent.getBoolean(CODE_CLEANUP_KEY);
    }

    public boolean isRearrangeCode(@NotNull Language language) {
        String key = LastRunReformatCodeOptionsProvider.getRearrangeCodeKeyFor(language);
        return this.myPropertiesComponent.getBoolean(key, language == StdLanguages.XML);
    }

    private static String getRearrangeCodeKeyFor(@NotNull Language language) {
        return REARRANGE_ENTRIES_KEY + language.getDisplayName();
    }
}

