/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.actions;

import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.Queue;
import org.jetbrains.annotations.NotNull;

public class FileTreeIterator {
    private Queue<PsiFile> myCurrentFiles = new LinkedList<PsiFile>();
    private Queue<PsiDirectory> myCurrentDirectories = new LinkedList<PsiDirectory>();

    public FileTreeIterator(@NotNull List<? extends PsiFile> files2) {
        this.myCurrentFiles.addAll(files2);
    }

    public FileTreeIterator(@NotNull Module module) {
        this.myCurrentDirectories.addAll(FileTreeIterator.collectModuleDirectories(module));
        this.expandDirectoriesUntilFilesNotEmpty();
    }

    public FileTreeIterator(@NotNull Project project) {
        this.myCurrentDirectories.addAll(FileTreeIterator.collectProjectDirectories(project));
        this.expandDirectoriesUntilFilesNotEmpty();
    }

    @NotNull
    public static List<PsiDirectory> collectProjectDirectories(@NotNull Project project) {
        Module[] modules2;
        ArrayList<PsiDirectory> directories = new ArrayList<PsiDirectory>();
        for (Module module : modules2 = ModuleManager.getInstance((Project)project).getModules()) {
            directories.addAll(FileTreeIterator.collectModuleDirectories(module));
        }
        return directories;
    }

    public FileTreeIterator(@NotNull PsiDirectory directory) {
        this.myCurrentDirectories.add(directory);
        this.expandDirectoriesUntilFilesNotEmpty();
    }

    public FileTreeIterator(@NotNull FileTreeIterator fileTreeIterator) {
        this.myCurrentFiles = new LinkedList<PsiFile>(fileTreeIterator.myCurrentFiles);
        this.myCurrentDirectories = new LinkedList<PsiDirectory>(fileTreeIterator.myCurrentDirectories);
    }

    @NotNull
    public PsiFile next() {
        if (this.myCurrentFiles.isEmpty()) {
            throw new NoSuchElementException();
        }
        PsiFile current2 = this.myCurrentFiles.poll();
        this.expandDirectoriesUntilFilesNotEmpty();
        return current2;
    }

    public boolean hasNext() {
        return !this.myCurrentFiles.isEmpty();
    }

    private void expandDirectoriesUntilFilesNotEmpty() {
        while (this.myCurrentFiles.isEmpty() && !this.myCurrentDirectories.isEmpty()) {
            PsiDirectory dir = this.myCurrentDirectories.poll();
            this.expandDirectory(dir);
        }
    }

    private void expandDirectory(@NotNull PsiDirectory dir) {
        Collections.addAll(this.myCurrentFiles, dir.getFiles());
        Collections.addAll(this.myCurrentDirectories, dir.getSubdirectories());
    }

    @NotNull
    public static List<PsiDirectory> collectModuleDirectories(Module module) {
        VirtualFile[] contentRoots;
        ArrayList<PsiDirectory> dirs = new ArrayList<PsiDirectory>();
        for (VirtualFile root : contentRoots = ModuleRootManager.getInstance((Module)module).getContentRoots()) {
            PsiDirectory dir = PsiManager.getInstance((Project)module.getProject()).findDirectory(root);
            if (dir == null) continue;
            dirs.add(dir);
        }
        return dirs;
    }
}

