/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.build.output;

import com.intellij.build.FilePosition;
import com.intellij.build.events.BuildEvent;
import com.intellij.build.events.MessageEvent;
import com.intellij.build.events.impl.FileMessageEventImpl;
import com.intellij.build.events.impl.MessageEventImpl;
import com.intellij.build.output.BuildOutputCollector;
import com.intellij.build.output.BuildOutputInstantReader;
import com.intellij.build.output.BuildOutputParser;
import com.intellij.lang.LangBundle;
import com.intellij.openapi.util.io.FileUtilRt;
import com.intellij.openapi.util.text.StringUtil;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.function.Consumer;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JavacOutputParser
implements BuildOutputParser {
    private static final String COMPILER_MESSAGES_GROUP = "Compiler";
    private static final char COLON = ':';
    private static final String WARNING_PREFIX = "warning:";
    private static final String NOTE_PREFIX = "note:";
    private static final String ERROR_PREFIX = "error:";
    private final String[] myFileExtensions;

    public JavacOutputParser() {
        this("java");
    }

    public JavacOutputParser(String ... fileExtensions) {
        this.myFileExtensions = fileExtensions;
    }

    public boolean parse(@NotNull String line, @NotNull BuildOutputInstantReader reader, @NotNull Consumer<? super BuildEvent> messageConsumer2) {
        int colonIndex1 = line.indexOf(58);
        if (colonIndex1 == 1) {
            colonIndex1 = line.indexOf(58, colonIndex1 + 1);
        }
        if (colonIndex1 >= 0) {
            File file2;
            String message;
            int javaFileExtensionIndex;
            String part1 = line.substring(0, colonIndex1).trim();
            if (part1.equalsIgnoreCase("error") || part1.equalsIgnoreCase("Caused by")) {
                String text = line.substring(colonIndex1 + 1).trim();
                messageConsumer2.accept(new MessageEventImpl(reader.getParentEventId(), MessageEvent.Kind.ERROR, COMPILER_MESSAGES_GROUP, text, line));
                return true;
            }
            if (part1.equalsIgnoreCase("warning")) {
                String text = line.substring(colonIndex1 + 1).trim();
                messageConsumer2.accept(new MessageEventImpl(reader.getParentEventId(), MessageEvent.Kind.WARNING, COMPILER_MESSAGES_GROUP, text, line));
                return true;
            }
            if (part1.equalsIgnoreCase("javac")) {
                messageConsumer2.accept(new MessageEventImpl(reader.getParentEventId(), MessageEvent.Kind.ERROR, COMPILER_MESSAGES_GROUP, line, line));
                return true;
            }
            if (part1.equalsIgnoreCase("Note") && (javaFileExtensionIndex = (message = line.substring(colonIndex1 + 1).trim()).indexOf(".java")) > 0 && (file2 = new File(message.substring(0, javaFileExtensionIndex + ".java".length()))).isFile()) {
                message = message.substring(javaFileExtensionIndex + ".java".length() + 1);
                String detailedMessage = JavacOutputParser.amendNextInfoLinesIfNeeded(file2.getPath() + ":\n" + message, reader);
                messageConsumer2.accept(new FileMessageEventImpl(reader.getParentEventId(), MessageEvent.Kind.INFO, COMPILER_MESSAGES_GROUP, message, detailedMessage, new FilePosition(file2, 0, 0)));
                return true;
            }
            int colonIndex2 = line.indexOf(58, colonIndex1 + 1);
            if (colonIndex2 >= 0) {
                File file3 = new File(part1);
                if (!file3.isFile()) {
                    return false;
                }
                try {
                    int column;
                    int lineNumber = Integer.parseInt(line.substring(colonIndex1 + 1, colonIndex2).trim());
                    String text = line.substring(colonIndex2 + 1).trim();
                    MessageEvent.Kind kind = MessageEvent.Kind.ERROR;
                    if (text.startsWith(WARNING_PREFIX)) {
                        text = text.substring(WARNING_PREFIX.length()).trim();
                        kind = MessageEvent.Kind.WARNING;
                    } else if (text.startsWith(NOTE_PREFIX)) {
                        text = text.substring(NOTE_PREFIX.length()).trim();
                        kind = MessageEvent.Kind.INFO;
                    } else if (text.startsWith(ERROR_PREFIX)) {
                        text = text.substring(ERROR_PREFIX.length()).trim();
                        kind = MessageEvent.Kind.ERROR;
                    }
                    if (!this.isRelatedFile(file3)) {
                        return false;
                    }
                    BuildOutputCollector outputCollector = new BuildOutputCollector(reader);
                    ArrayList<String> messageList = new ArrayList<String>();
                    messageList.add(text);
                    String prevLine = null;
                    while (true) {
                        String nextLine;
                        if ((nextLine = outputCollector.readLine()) == null) {
                            return false;
                        }
                        if (nextLine.trim().equals("^")) {
                            column = nextLine.indexOf(94);
                            String messageEnd = outputCollector.readLine();
                            while (JavacOutputParser.isMessageEnd(messageEnd)) {
                                messageList.add(messageEnd.trim());
                                messageEnd = outputCollector.readLine();
                            }
                            if (messageEnd == null) break;
                            outputCollector.pushBack();
                            break;
                        }
                        if (prevLine != null) {
                            messageList.add(prevLine);
                        }
                        prevLine = nextLine;
                    }
                    if (column >= 0) {
                        String message2 = StringUtil.join(JavacOutputParser.convertMessages(messageList), (String)"\n");
                        String detailedMessage = line + "\n" + outputCollector.getOutput();
                        messageConsumer2.accept(new FileMessageEventImpl(reader.getParentEventId(), kind, COMPILER_MESSAGES_GROUP, message2, detailedMessage, new FilePosition(file3, lineNumber - 1, column)));
                        return true;
                    }
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            }
        }
        if (line.endsWith("java.lang.OutOfMemoryError")) {
            messageConsumer2.accept(new MessageEventImpl(reader.getParentEventId(), MessageEvent.Kind.ERROR, COMPILER_MESSAGES_GROUP, LangBundle.message((String)"build.event.message.out.memory", (Object[])new Object[0]), line));
            return true;
        }
        return false;
    }

    private boolean isRelatedFile(File file2) {
        String filePath = file2.getPath();
        return Arrays.stream(this.myFileExtensions).anyMatch(extension -> FileUtilRt.extensionEquals((String)filePath, (String)extension));
    }

    private static String amendNextInfoLinesIfNeeded(String str, BuildOutputInstantReader reader) {
        StringBuilder builder2 = new StringBuilder(str);
        String nextLine = reader.readLine();
        while (nextLine != null) {
            int index;
            if (nextLine.startsWith("Note: ") && (index = nextLine.indexOf(".java")) < 0) {
                builder2.append("\n").append(nextLine.substring("Note: ".length()));
                nextLine = reader.readLine();
                continue;
            }
            reader.pushBack();
            break;
        }
        return builder2.toString();
    }

    @Contract(value="null -> false")
    private static boolean isMessageEnd(@Nullable String line) {
        return line != null && line.length() > 0 && Character.isWhitespace(line.charAt(0));
    }

    @NotNull
    private static List<String> convertMessages(@NotNull List<String> messages) {
        String part1;
        if (messages.size() <= 1) {
            return messages;
        }
        String line0 = messages.get(0);
        String line1 = messages.get(1);
        int colonIndex = line1.indexOf(58);
        if (colonIndex > 0 && "symbol".equals(part1 = line1.substring(0, colonIndex).trim())) {
            String symbol = line1.substring(colonIndex + 1).trim();
            messages.remove(1);
            if (messages.size() >= 2) {
                messages.remove(1);
            }
            messages.set(0, line0 + " " + symbol);
        }
        return messages;
    }
}

