/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.build;

import com.intellij.build.BuildDescriptor;
import com.intellij.build.ExecutionNode;
import com.intellij.build.process.BuildProcessHandler;
import com.intellij.execution.filters.Filter;
import com.intellij.execution.runners.ExecutionEnvironment;
import com.intellij.execution.ui.ConsoleView;
import com.intellij.execution.ui.RunContentDescriptor;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.util.Consumer;
import com.intellij.util.SmartList;
import com.intellij.util.containers.ContainerUtil;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.function.Function;
import java.util.function.Supplier;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DefaultBuildDescriptor
implements BuildDescriptor {
    private final Object myId;
    private final String myTitle;
    private final String myWorkingDir;
    private final long myStartTime;
    private boolean myActivateToolWindowWhenAdded;
    private boolean myActivateToolWindowWhenFailed = true;
    private boolean myAutoFocusContent = false;
    @NotNull
    private final List<AnAction> myActions = new SmartList();
    @NotNull
    private final List<AnAction> myRestartActions = new SmartList();
    @NotNull
    private final List<Filter> myExecutionFilters = new SmartList();
    @NotNull
    private final List<Function<ExecutionNode, AnAction>> myContextActions = new SmartList();
    @Nullable
    private BuildProcessHandler myProcessHandler;
    @Nullable
    private Consumer<ConsoleView> myAttachedConsoleConsumer;
    @Nullable
    private ExecutionEnvironment myExecutionEnvironment;
    @Nullable
    private Supplier<RunContentDescriptor> myContentDescriptorSupplier;

    public DefaultBuildDescriptor(@NotNull Object id2, @NotNull @Nls(capitalization=Nls.Capitalization.Title) String title, @NotNull String workingDir, long startTime) {
        this.myId = id2;
        this.myTitle = title;
        this.myWorkingDir = workingDir;
        this.myStartTime = startTime;
    }

    public DefaultBuildDescriptor(@Nullable @NotNull BuildDescriptor descriptor2) {
        this(descriptor2.getId(), descriptor2.getTitle(), descriptor2.getWorkingDir(), descriptor2.getStartTime());
        if (descriptor2 instanceof DefaultBuildDescriptor) {
            DefaultBuildDescriptor defaultBuildDescriptor = (DefaultBuildDescriptor)descriptor2;
            this.myActivateToolWindowWhenAdded = defaultBuildDescriptor.myActivateToolWindowWhenAdded;
            this.myActivateToolWindowWhenFailed = defaultBuildDescriptor.myActivateToolWindowWhenFailed;
            this.myAutoFocusContent = defaultBuildDescriptor.myAutoFocusContent;
            defaultBuildDescriptor.myRestartActions.forEach(this::withRestartAction);
            defaultBuildDescriptor.myActions.forEach(this::withAction);
            defaultBuildDescriptor.myExecutionFilters.forEach(this::withExecutionFilter);
            defaultBuildDescriptor.myContextActions.forEach(this::withContextAction);
            this.myContentDescriptorSupplier = defaultBuildDescriptor.myContentDescriptorSupplier;
            this.myExecutionEnvironment = defaultBuildDescriptor.myExecutionEnvironment;
            this.myProcessHandler = defaultBuildDescriptor.myProcessHandler;
            this.myAttachedConsoleConsumer = defaultBuildDescriptor.myAttachedConsoleConsumer;
        }
    }

    @NotNull
    public Object getId() {
        return this.myId;
    }

    @NotNull
    public String getTitle() {
        return this.myTitle;
    }

    @NotNull
    public String getWorkingDir() {
        return this.myWorkingDir;
    }

    public long getStartTime() {
        return this.myStartTime;
    }

    @ApiStatus.Experimental
    @NotNull
    public List<AnAction> getActions() {
        return Collections.unmodifiableList(this.myActions);
    }

    @ApiStatus.Experimental
    @NotNull
    public List<AnAction> getRestartActions() {
        return Collections.unmodifiableList(this.myRestartActions);
    }

    @ApiStatus.Experimental
    @NotNull
    public List<AnAction> getContextActions(@NotNull ExecutionNode node) {
        return ContainerUtil.map(this.myContextActions, function -> (AnAction)function.apply(node));
    }

    @ApiStatus.Experimental
    @NotNull
    public List<Filter> getExecutionFilters() {
        return Collections.unmodifiableList(this.myExecutionFilters);
    }

    public boolean isActivateToolWindowWhenAdded() {
        return this.myActivateToolWindowWhenAdded;
    }

    public void setActivateToolWindowWhenAdded(boolean activateToolWindowWhenAdded) {
        this.myActivateToolWindowWhenAdded = activateToolWindowWhenAdded;
    }

    public boolean isActivateToolWindowWhenFailed() {
        return this.myActivateToolWindowWhenFailed;
    }

    public void setActivateToolWindowWhenFailed(boolean activateToolWindowWhenFailed) {
        this.myActivateToolWindowWhenFailed = activateToolWindowWhenFailed;
    }

    public boolean isAutoFocusContent() {
        return this.myAutoFocusContent;
    }

    public void setAutoFocusContent(boolean autoFocusContent) {
        this.myAutoFocusContent = autoFocusContent;
    }

    @Nullable
    public BuildProcessHandler getProcessHandler() {
        return this.myProcessHandler;
    }

    @Nullable
    public ExecutionEnvironment getExecutionEnvironment() {
        return this.myExecutionEnvironment;
    }

    @Nullable
    public Supplier<RunContentDescriptor> getContentDescriptorSupplier() {
        return this.myContentDescriptorSupplier;
    }

    @Nullable
    public Consumer<ConsoleView> getAttachedConsoleConsumer() {
        return this.myAttachedConsoleConsumer;
    }

    @ApiStatus.Experimental
    public DefaultBuildDescriptor withAction(@NotNull AnAction action2) {
        this.myActions.add(action2);
        return this;
    }

    @ApiStatus.Experimental
    public DefaultBuildDescriptor withRestartAction(@NotNull AnAction action2) {
        this.myRestartActions.add(action2);
        return this;
    }

    @ApiStatus.Experimental
    public DefaultBuildDescriptor withRestartActions(AnAction ... actions) {
        this.myRestartActions.addAll(Arrays.asList(actions));
        return this;
    }

    @ApiStatus.Experimental
    public DefaultBuildDescriptor withContextAction(Function<ExecutionNode, AnAction> contextAction) {
        this.myContextActions.add(contextAction);
        return this;
    }

    @ApiStatus.Experimental
    public DefaultBuildDescriptor withContextActions(AnAction ... actions) {
        for (AnAction action2 : actions) {
            this.myContextActions.add(node -> action2);
        }
        return this;
    }

    @ApiStatus.Experimental
    public DefaultBuildDescriptor withExecutionFilter(@NotNull Filter filter2) {
        this.myExecutionFilters.add(filter2);
        return this;
    }

    public DefaultBuildDescriptor withContentDescriptor(Supplier<RunContentDescriptor> contentDescriptorSupplier) {
        this.myContentDescriptorSupplier = contentDescriptorSupplier;
        return this;
    }

    public DefaultBuildDescriptor withProcessHandler(@Nullable BuildProcessHandler processHandler2, @Nullable Consumer<ConsoleView> attachedConsoleConsumer) {
        this.myProcessHandler = processHandler2;
        this.myAttachedConsoleConsumer = attachedConsoleConsumer;
        return this;
    }

    public DefaultBuildDescriptor withExecutionEnvironment(@Nullable ExecutionEnvironment env) {
        this.myExecutionEnvironment = env;
        return this;
    }
}

