/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.application.options.schemes;

import com.intellij.CommonBundle;
import com.intellij.application.options.schemes.AbstractSchemesPanel;
import com.intellij.application.options.schemes.SchemesModel;
import com.intellij.ide.IdeBundle;
import com.intellij.idea.ActionsBundle;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.actionSystem.Separator;
import com.intellij.openapi.application.ApplicationBundle;
import com.intellij.openapi.application.WriteAction;
import com.intellij.openapi.fileChooser.FileChooserFactory;
import com.intellij.openapi.fileChooser.FileSaverDescriptor;
import com.intellij.openapi.fileChooser.FileSaverDialog;
import com.intellij.openapi.options.ConfigurableSchemeExporter;
import com.intellij.openapi.options.Scheme;
import com.intellij.openapi.options.SchemeExporter;
import com.intellij.openapi.options.SchemeExporterEP;
import com.intellij.openapi.options.SchemeImporterEP;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.MessageType;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileWrapper;
import com.intellij.util.containers.ContainerUtil;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.function.BiFunction;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class AbstractSchemeActions<T extends Scheme> {
    @NotNull
    protected final AbstractSchemesPanel<T, ?> mySchemesPanel;

    protected AbstractSchemeActions(@NotNull AbstractSchemesPanel<T, ?> schemesPanel) {
        this.mySchemesPanel = schemesPanel;
    }

    @NotNull
    protected Collection<String> getSchemeImportersNames() {
        ArrayList<String> importersNames = new ArrayList<String>();
        for (SchemeImporterEP<T> importerEP : SchemeImporterEP.getExtensions(this.getSchemeType())) {
            importersNames.add(importerEP.name);
        }
        return importersNames;
    }

    @NotNull
    private Collection<String> getSchemeExporterNames() {
        ArrayList<String> exporterNames = new ArrayList<String>();
        for (SchemeExporterEP<T> exporterEP : SchemeExporterEP.getExtensions(this.getSchemeType())) {
            exporterNames.add(exporterEP.name);
        }
        return exporterNames;
    }

    @NotNull
    public final Collection<AnAction> getActions() {
        ArrayList<AnAction> actions = new ArrayList<AnAction>();
        if (this.mySchemesPanel.supportsProjectSchemes()) {
            actions.add((AnAction)new CopyToProjectAction());
            actions.add((AnAction)new CopyToIDEAction());
            actions.add((AnAction)new Separator());
        }
        actions.add((AnAction)new CopyAction());
        actions.add((AnAction)new RenameAction());
        this.addAdditionalActions(actions);
        actions.add((AnAction)new ResetAction());
        actions.add((AnAction)new DeleteAction());
        @NotNull Collection<String> schemeImportersNames = this.getSchemeImportersNames();
        @NotNull Collection<String> schemeExporterNames = this.getSchemeExporterNames();
        if (!schemeExporterNames.isEmpty()) {
            actions.add(AbstractSchemeActions.createImportExportAction(ApplicationBundle.message((String)"settings.editor.scheme.export", (Object[])new Object[0]), schemeExporterNames, (x$0, x$1) -> new ExportAction((String)x$0, (String)x$1)));
        }
        actions.add((AnAction)new Separator());
        if (!schemeImportersNames.isEmpty()) {
            actions.add(AbstractSchemeActions.createImportExportAction(ApplicationBundle.message((String)"settings.editor.scheme.import", (Object[])new Object[]{this.mySchemesPanel.getSchemeTypeName()}), schemeImportersNames, (x$0, x$1) -> new ImportAction((String)x$0, (String)x$1)));
        }
        return actions;
    }

    protected void addAdditionalActions(@NotNull List<? super AnAction> defaultActions) {
    }

    @NotNull
    private static AnAction createImportExportAction(@NotNull String groupName, @NotNull Collection<String> actionNames, final @NotNull BiFunction<? super String, ? super String, ? extends AnAction> createActionByName) {
        if (actionNames.size() == 1) {
            return createActionByName.apply((String)ContainerUtil.getFirstItem(actionNames), groupName + "...");
        }
        return new ImportExportActionGroup(groupName, actionNames){

            @Override
            @NotNull
            protected AnAction createAction(@NotNull String actionName) {
                return (AnAction)createActionByName.apply(actionName, actionName);
            }
        };
    }

    protected void importScheme(@NotNull String importerName) {
    }

    protected abstract void resetScheme(@NotNull T var1);

    protected abstract void duplicateScheme(@NotNull T var1, @NotNull String var2);

    private void deleteScheme(@NotNull T scheme) {
        if (Messages.showOkCancelDialog((String)IdeBundle.message((String)"message.do.you.want.to.delete.0.1", (Object[])new Object[]{scheme.getName(), StringUtil.toLowerCase((String)this.mySchemesPanel.getSchemeTypeName())}), (String)IdeBundle.message((String)"dialog.title.delete.0", (Object[])new Object[]{this.mySchemesPanel.getSchemeTypeName()}), (String)IdeBundle.message((String)"button.delete", (Object[])new Object[0]), (String)CommonBundle.getCancelButtonText(), (Icon)Messages.getQuestionIcon()) == 0) {
            this.mySchemesPanel.getModel().removeScheme(scheme);
        }
    }

    @Deprecated
    protected void exportScheme(@NotNull T scheme, @NotNull String exporterName) {
    }

    protected void exportScheme(@Nullable Project project, @NotNull T scheme, @NotNull String exporterName) {
        SchemeExporter<T> exporter = SchemeExporterEP.getExporter(exporterName, this.getSchemeType());
        if (exporter != null) {
            Object config2 = null;
            if (exporter instanceof ConfigurableSchemeExporter && (config2 = ((ConfigurableSchemeExporter)exporter).getConfiguration(this.mySchemesPanel, scheme)) == null) {
                return;
            }
            String ext = exporter.getExtension();
            FileSaverDialog saver = FileChooserFactory.getInstance().createSaveFileDialog(new FileSaverDescriptor(ApplicationBundle.message((String)"scheme.exporter.ui.file.chooser.title", (Object[])new Object[0]), ApplicationBundle.message((String)"scheme.exporter.ui.file.chooser.message", (Object[])new Object[0]), new String[]{ext}), this.getSchemesPanel());
            VirtualFileWrapper target2 = saver.save(exporter.getDefaultDir(project), exporter.getDefaultFileName(scheme.getDisplayName()) + "." + ext);
            if (target2 != null) {
                MessageType messageType;
                String message;
                VirtualFile targetFile = target2.getVirtualFile(true);
                if (targetFile != null) {
                    try {
                        Object finalConfig = config2;
                        WriteAction.run(() -> {
                            try (OutputStream outputStream = targetFile.getOutputStream((Object)this);){
                                if (exporter instanceof ConfigurableSchemeExporter) {
                                    ((ConfigurableSchemeExporter)exporter).exportScheme(scheme, outputStream, finalConfig);
                                }
                                exporter.exportScheme(project, scheme, outputStream);
                            }
                        });
                        message = ApplicationBundle.message((String)"scheme.exporter.ui.scheme.exported.message", (Object[])new Object[]{scheme.getName(), this.getSchemesPanel().getSchemeTypeName(), targetFile.getPresentableUrl()});
                        messageType = MessageType.INFO;
                    }
                    catch (Exception e) {
                        message = ApplicationBundle.message((String)"scheme.exporter.ui.export.failed", (Object[])new Object[]{e.getMessage()});
                        messageType = MessageType.ERROR;
                    }
                } else {
                    message = ApplicationBundle.message((String)"scheme.exporter.ui.cannot.write.message", (Object[])new Object[0]);
                    messageType = MessageType.ERROR;
                }
                this.getSchemesPanel().showStatus(message, messageType);
            }
        }
    }

    protected abstract void onSchemeChanged(@Nullable T var1);

    protected abstract void renameScheme(@NotNull T var1, @NotNull String var2);

    protected void copyToProject(@NotNull T scheme) {
    }

    protected void copyToIDE(@NotNull T scheme) {
    }

    @NotNull
    protected SchemesModel<T> getModel() {
        return this.mySchemesPanel.getModel();
    }

    @Nullable
    protected final T getCurrentScheme() {
        return this.mySchemesPanel.getSelectedScheme();
    }

    @NotNull
    protected abstract Class<T> getSchemeType();

    @NotNull
    public final AbstractSchemesPanel<T, ?> getSchemesPanel() {
        return this.mySchemesPanel;
    }

    private class ExportAction
    extends DumbAwareAction {
        private final String myExporterName;

        ExportAction(@NotNull String exporterName, String exporterText) {
            super(exporterText);
            this.myExporterName = exporterName;
        }

        public void actionPerformed(@NotNull AnActionEvent e) {
            Object currentScheme = AbstractSchemeActions.this.getCurrentScheme();
            if (currentScheme != null) {
                AbstractSchemeActions.this.mySchemesPanel.cancelEdit();
                Project project = e.getProject();
                AbstractSchemeActions.this.exportScheme(project, currentScheme, this.myExporterName);
            }
        }
    }

    private class ImportAction
    extends DumbAwareAction {
        private final String myImporterName;

        ImportAction(@NotNull String importerName, String importerText) {
            super(importerText);
            this.myImporterName = importerName;
        }

        public void actionPerformed(@NotNull AnActionEvent e) {
            AbstractSchemeActions.this.mySchemesPanel.cancelEdit();
            AbstractSchemeActions.this.importScheme(this.myImporterName);
        }
    }

    private static abstract class ImportExportActionGroup
    extends ActionGroup {
        private final Collection<String> myActionNames;

        ImportExportActionGroup(@NotNull String groupName, @NotNull Collection<String> actionNames) {
            super(groupName, true);
            this.myActionNames = actionNames;
        }

        public AnAction @NotNull [] getChildren(@Nullable AnActionEvent e) {
            ArrayList<AnAction> namedActions = new ArrayList<AnAction>();
            for (String actionName : this.myActionNames) {
                namedActions.add(this.createAction(actionName));
            }
            return namedActions.toArray(AnAction.EMPTY_ARRAY);
        }

        @NotNull
        protected abstract AnAction createAction(@NotNull String var1);
    }

    private class DeleteAction
    extends DumbAwareAction {
        DeleteAction() {
            super(ApplicationBundle.messagePointer((String)"settings.editor.scheme.delete", (Object[])new Object[0]));
        }

        public void actionPerformed(@NotNull AnActionEvent e) {
            Object currentScheme = AbstractSchemeActions.this.getCurrentScheme();
            if (currentScheme != null) {
                AbstractSchemeActions.this.mySchemesPanel.cancelEdit();
                AbstractSchemeActions.this.deleteScheme(currentScheme);
            }
        }

        public void update(@NotNull AnActionEvent e) {
            boolean isEnabled;
            Presentation p = e.getPresentation();
            Object scheme = AbstractSchemeActions.this.getCurrentScheme();
            boolean bl = isEnabled = scheme != null && AbstractSchemeActions.this.mySchemesPanel.getModel().canDeleteScheme(scheme);
            if (AbstractSchemeActions.this.mySchemesPanel.hideDeleteActionIfUnavailable()) {
                p.setEnabledAndVisible(isEnabled);
            } else {
                p.setEnabled(isEnabled);
            }
        }
    }

    private class RenameAction
    extends DumbAwareAction {
        RenameAction() {
            super(ActionsBundle.messagePointer((String)"action.RenameAction.text", (Object[])new Object[0]));
        }

        public void actionPerformed(@NotNull AnActionEvent e) {
            AbstractSchemeActions.this.mySchemesPanel.editCurrentSchemeName((currentScheme, newName) -> AbstractSchemeActions.this.renameScheme(currentScheme, (String)newName));
        }

        public void update(@NotNull AnActionEvent e) {
            Presentation p = e.getPresentation();
            Object scheme = AbstractSchemeActions.this.getCurrentScheme();
            p.setEnabledAndVisible(scheme != null && AbstractSchemeActions.this.mySchemesPanel.getModel().canRenameScheme(scheme));
        }
    }

    private class CopyAction
    extends DumbAwareAction {
        CopyAction() {
            super(ApplicationBundle.messagePointer((String)"settings.editor.scheme.copy", (Object[])new Object[0]));
        }

        public void actionPerformed(@NotNull AnActionEvent e) {
            Object currentScheme = AbstractSchemeActions.this.getCurrentScheme();
            if (currentScheme != null) {
                AbstractSchemeActions.this.mySchemesPanel.editNewSchemeName(currentScheme.getDisplayName(), AbstractSchemeActions.this.mySchemesPanel.supportsProjectSchemes() && AbstractSchemeActions.this.getModel().isProjectScheme(currentScheme), newName -> AbstractSchemeActions.this.duplicateScheme(currentScheme, (String)newName));
            }
        }

        public void update(@NotNull AnActionEvent e) {
            Presentation p = e.getPresentation();
            Object scheme = AbstractSchemeActions.this.getCurrentScheme();
            p.setEnabledAndVisible(scheme != null && AbstractSchemeActions.this.mySchemesPanel.getModel().canDuplicateScheme(scheme));
        }
    }

    private class ResetAction
    extends DumbAwareAction {
        ResetAction() {
            super(ApplicationBundle.messagePointer((String)"settings.editor.scheme.reset", (Object[])new Object[0]));
        }

        public void actionPerformed(@NotNull AnActionEvent e) {
            Object currentScheme = AbstractSchemeActions.this.getCurrentScheme();
            if (currentScheme != null) {
                AbstractSchemeActions.this.mySchemesPanel.cancelEdit();
                AbstractSchemeActions.this.resetScheme(currentScheme);
            }
        }

        public void update(@NotNull AnActionEvent e) {
            Presentation p = e.getPresentation();
            Object scheme = AbstractSchemeActions.this.getCurrentScheme();
            if (scheme != null && AbstractSchemeActions.this.mySchemesPanel.getModel().canResetScheme(scheme)) {
                p.setVisible(true);
                p.setEnabled(AbstractSchemeActions.this.mySchemesPanel.getModel().differsFromDefault(scheme));
            } else {
                p.setEnabledAndVisible(false);
            }
        }
    }

    private class CopyToIDEAction
    extends DumbAwareAction {
        CopyToIDEAction() {
            super(ApplicationBundle.messagePointer((String)"settings.editor.scheme.copy.to.ide", (Object[])new Object[0]));
        }

        public void actionPerformed(@NotNull AnActionEvent e) {
            Object currentScheme = AbstractSchemeActions.this.getCurrentScheme();
            if (currentScheme != null && AbstractSchemeActions.this.getModel().isProjectScheme(currentScheme)) {
                AbstractSchemeActions.this.copyToIDE(currentScheme);
            }
        }

        public void update(@NotNull AnActionEvent e) {
            Presentation p = e.getPresentation();
            Object currentScheme = AbstractSchemeActions.this.getCurrentScheme();
            p.setEnabledAndVisible(currentScheme != null && AbstractSchemeActions.this.getModel().isProjectScheme(currentScheme));
        }
    }

    private class CopyToProjectAction
    extends DumbAwareAction {
        CopyToProjectAction() {
            super(ApplicationBundle.messagePointer((String)"settings.editor.scheme.copy.to.project", (Object[])new Object[0]));
        }

        public void actionPerformed(@NotNull AnActionEvent e) {
            Object currentScheme = AbstractSchemeActions.this.getCurrentScheme();
            if (currentScheme != null && !AbstractSchemeActions.this.getModel().isProjectScheme(currentScheme)) {
                AbstractSchemeActions.this.copyToProject(currentScheme);
            }
        }

        public void update(@NotNull AnActionEvent e) {
            Presentation p = e.getPresentation();
            Object currentScheme = AbstractSchemeActions.this.getCurrentScheme();
            p.setEnabledAndVisible(currentScheme != null && !AbstractSchemeActions.this.getModel().isProjectScheme(currentScheme));
        }
    }
}

