/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.application.options.colors;

import com.intellij.application.options.colors.AbstractFontOptionsPanel;
import com.intellij.application.options.colors.ColorAndFontOptions;
import com.intellij.ide.DataManager;
import com.intellij.openapi.application.ApplicationBundle;
import com.intellij.openapi.editor.colors.DelegatingFontPreferences;
import com.intellij.openapi.editor.colors.EditorColorsScheme;
import com.intellij.openapi.editor.colors.FontPreferences;
import com.intellij.openapi.editor.colors.impl.AppEditorFontOptions;
import com.intellij.openapi.options.Configurable;
import com.intellij.openapi.options.ex.Settings;
import com.intellij.ui.JBColor;
import com.intellij.ui.components.labels.LinkLabel;
import com.intellij.ui.components.labels.LinkListener;
import com.intellij.util.ui.JBDimension;
import com.intellij.util.ui.JBUI;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class FontOptions
extends AbstractFontOptionsPanel {
    @NotNull
    private final ColorAndFontOptions myOptions;
    @Nullable
    private JCheckBox myOverwriteCheckBox;
    @Nullable
    private JLabel myBaseFontInfoLabel;
    private static final int FONT_PANEL_LEFT_OFFSET = 15;

    public FontOptions(@NotNull ColorAndFontOptions options2) {
        this.myOptions = options2;
    }

    @Nullable
    protected String getInheritedFontTitle() {
        return ApplicationBundle.message((String)"settings.editor.font.default", (Object[])new Object[0]);
    }

    protected String getOverwriteFontTitle() {
        return ApplicationBundle.message((String)"settings.editor.font.overwrite", (Object[])new Object[0]);
    }

    @Override
    protected JComponent createControls() {
        Component inheritBox = this.createOverwriteCheckBox();
        if (inheritBox != null) {
            JPanel topPanel = new JPanel(new GridBagLayout());
            GridBagConstraints c = new GridBagConstraints();
            c.gridx = 0;
            c.gridy = 0;
            c.gridwidth = 2;
            c.insets = JBUI.insets((int)10, (int)5, (int)12, (int)0);
            c.anchor = 21;
            topPanel.add(inheritBox, c);
            c.gridy = 1;
            c.gridx = 0;
            c.gridwidth = 1;
            c.insets = JBUI.emptyInsets();
            topPanel.add(Box.createRigidArea((Dimension)JBDimension.create((Dimension)new Dimension(15, 0))), c);
            c.gridx = 1;
            c.anchor = 18;
            topPanel.add((Component)this.createFontSettingsPanel(), c);
            return topPanel;
        }
        return super.createControls();
    }

    @Nullable
    private Component createOverwriteCheckBox() {
        if (this.getInheritedFontTitle() != null) {
            JPanel overwritePanel = new JPanel(new FlowLayout(3, 0, 0));
            overwritePanel.setBorder(BorderFactory.createEmptyBorder());
            this.myOverwriteCheckBox = new JCheckBox(this.getOverwriteFontTitle());
            this.myOverwriteCheckBox.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 5));
            this.myOverwriteCheckBox.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    FontOptions.this.setDelegatingPreferences(!FontOptions.this.myOverwriteCheckBox.isSelected());
                }
            });
            overwritePanel.add(this.myOverwriteCheckBox);
            overwritePanel.add(this.createHyperlinkLabel());
            overwritePanel.add(FontOptions.grayed(new JLabel(" (")));
            this.myBaseFontInfoLabel = FontOptions.grayed(new JLabel("?"));
            overwritePanel.add(this.myBaseFontInfoLabel);
            overwritePanel.add(FontOptions.grayed(new JLabel(")")));
            return overwritePanel;
        }
        return null;
    }

    private static JLabel grayed(JLabel label2) {
        label2.setForeground((Color)JBColor.GRAY);
        return label2;
    }

    private String getBaseFontInfo() {
        FontPreferences basePrefs = this.getBaseFontPreferences();
        return basePrefs.getFontFamily() + ',' + basePrefs.getSize(basePrefs.getFontFamily());
    }

    protected FontPreferences getBaseFontPreferences() {
        return AppEditorFontOptions.getInstance().getFontPreferences();
    }

    @NotNull
    private JLabel createHyperlinkLabel() {
        return new LinkLabel(this.getInheritedFontTitle(), null, (LinkListener)new LinkListener<Object>(){

            public void linkSelected(LinkLabel<Object> aSource, Object aLinkData) {
                FontOptions.this.navigateToParentFontConfigurable();
            }
        });
    }

    protected void navigateToParentFontConfigurable() {
        Configurable fontConfigurable;
        Settings allSettings = (Settings)Settings.KEY.getData(DataManager.getInstance().getDataContext((Component)this.getPanel()));
        if (allSettings != null && (fontConfigurable = allSettings.find("editor.preferences.fonts.default")) != null) {
            allSettings.select(fontConfigurable);
        }
    }

    @Override
    protected void setDelegatingPreferences(boolean isDelegating) {
        FontPreferences currPrefs = this.getCurrentScheme().getFontPreferences();
        if (currPrefs instanceof DelegatingFontPreferences == isDelegating) {
            return;
        }
        if (isDelegating) {
            this.getCurrentScheme().setUseAppFontPreferencesInEditor();
        } else {
            this.getCurrentScheme().setFontPreferences(this.getFontPreferences());
        }
        this.updateOptionsList();
        this.updateDescription(true);
    }

    @Override
    protected boolean isReadOnly() {
        return ColorAndFontOptions.isReadOnly(this.myOptions.getSelectedScheme());
    }

    @Override
    protected boolean isDelegating() {
        return this.getFontPreferences() instanceof DelegatingFontPreferences;
    }

    @Override
    @NotNull
    protected FontPreferences getFontPreferences() {
        return this.getCurrentScheme().getFontPreferences();
    }

    @Override
    protected void setFontSize(int fontSize) {
        this.getCurrentScheme().setEditorFontSize(fontSize);
    }

    @Override
    protected float getLineSpacing() {
        return this.getCurrentScheme().getLineSpacing();
    }

    @Override
    protected void setCurrentLineSpacing(float lineSpacing) {
        this.getCurrentScheme().setLineSpacing(lineSpacing);
    }

    protected EditorColorsScheme getCurrentScheme() {
        return this.myOptions.getSelectedScheme();
    }

    @Override
    protected void updateCustomOptions() {
        if (this.myOverwriteCheckBox != null) {
            this.myOverwriteCheckBox.setEnabled(!this.isReadOnly());
            this.myOverwriteCheckBox.setSelected(!this.isDelegating());
        }
        if (this.myBaseFontInfoLabel != null) {
            this.myBaseFontInfoLabel.setText(this.getBaseFontInfo());
        }
    }
}

