/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.application.options.colors;

import com.intellij.openapi.editor.colors.EditorColorsScheme;
import com.intellij.openapi.editor.colors.EditorSchemeAttributeDescriptorWithPath;
import com.intellij.openapi.editor.colors.impl.AbstractColorsScheme;
import com.intellij.openapi.editor.colors.impl.ReadOnlyColorsScheme;
import com.intellij.openapi.editor.markup.EffectType;
import com.intellij.openapi.editor.markup.TextAttributes;
import com.intellij.openapi.options.colors.AbstractKeyDescriptor;
import com.intellij.openapi.options.colors.ColorAndFontDescriptorsProvider;
import com.intellij.openapi.util.Pair;
import java.awt.Color;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class ColorAndFontDescription
extends TextAttributes
implements EditorSchemeAttributeDescriptorWithPath {
    private final String myName;
    private final String myGroup;
    private final String myType;
    private final Icon myIcon;
    private final String myToolTip;
    private final EditorColorsScheme myScheme;
    private boolean isForegroundChecked;
    private boolean isBackgroundChecked;
    private boolean isEffectsColorChecked;
    private boolean isErrorStripeChecked;
    private boolean isInherited;

    public ColorAndFontDescription(@NotNull String name, @Nullable String group, @Nullable String type, @Nullable EditorColorsScheme scheme, @Nullable Icon icon2, @Nullable String toolTip) {
        this.myName = name;
        this.myGroup = group;
        this.myType = type;
        this.myScheme = scheme;
        this.myIcon = icon2;
        this.myToolTip = toolTip;
    }

    public String toString() {
        return this.myName;
    }

    public String getGroup() {
        return this.myGroup;
    }

    public String getType() {
        return this.myType;
    }

    public EditorColorsScheme getScheme() {
        return this.myScheme;
    }

    public Icon getIcon() {
        return this.myIcon;
    }

    public String getToolTip() {
        return this.myToolTip;
    }

    protected void initCheckedStatus() {
        this.isForegroundChecked = this.getExternalForeground() != null;
        this.isBackgroundChecked = this.getExternalBackground() != null;
        this.isErrorStripeChecked = this.getExternalErrorStripe() != null;
        this.isEffectsColorChecked = this.getExternalEffectColor() != null;
        super.setForegroundColor(this.getExternalForeground());
        super.setBackgroundColor(this.getExternalBackground());
        super.setEffectColor(this.getExternalEffectColor());
        super.setEffectType(this.getExternalEffectType());
        super.setErrorStripeColor(this.getExternalErrorStripe());
    }

    public abstract Color getExternalForeground();

    public abstract Color getExternalBackground();

    public abstract Color getExternalErrorStripe();

    public abstract Color getExternalEffectColor();

    public abstract EffectType getExternalEffectType();

    public abstract void setExternalForeground(Color var1);

    public abstract void setExternalBackground(Color var1);

    public abstract void setExternalErrorStripe(Color var1);

    public abstract void setExternalEffectColor(Color var1);

    public abstract void setExternalEffectType(EffectType var1);

    public final void setForegroundColor(Color col) {
        super.setForegroundColor(col);
        if (this.isForegroundChecked) {
            this.setExternalForeground(col);
        } else {
            this.setExternalForeground(null);
        }
    }

    public boolean isTransparencyEnabled() {
        return false;
    }

    public final void setBackgroundColor(Color col) {
        super.setBackgroundColor(col);
        if (this.isBackgroundChecked) {
            this.setExternalBackground(col);
        } else {
            this.setExternalBackground(null);
        }
    }

    public void setErrorStripeColor(Color color) {
        super.setErrorStripeColor(color);
        if (this.isErrorStripeChecked) {
            this.setExternalErrorStripe(color);
        } else {
            this.setExternalErrorStripe(null);
        }
    }

    public final void setEffectColor(Color col) {
        super.setEffectColor(col);
        if (this.isEffectsColorChecked) {
            this.setExternalEffectColor(col);
        } else {
            this.setExternalEffectColor(null);
        }
    }

    public final void setEffectType(EffectType effectType) {
        super.setEffectType(effectType);
        this.setExternalEffectType(effectType);
    }

    public boolean isForegroundChecked() {
        return this.isForegroundChecked;
    }

    public boolean isBackgroundChecked() {
        return this.isBackgroundChecked;
    }

    public boolean isErrorStripeChecked() {
        return this.isErrorStripeChecked;
    }

    public boolean isEffectsColorChecked() {
        return this.isEffectsColorChecked;
    }

    public final void setForegroundChecked(boolean val) {
        this.isForegroundChecked = val;
        this.setForegroundColor(this.getForegroundColor());
    }

    public final void setBackgroundChecked(boolean val) {
        this.isBackgroundChecked = val;
        this.setBackgroundColor(this.getBackgroundColor());
    }

    public final void setErrorStripeChecked(boolean val) {
        this.isErrorStripeChecked = val;
        this.setErrorStripeColor(this.getErrorStripeColor());
    }

    public final void setEffectsColorChecked(boolean val) {
        this.isEffectsColorChecked = val;
        this.setEffectColor(this.getEffectColor());
        this.setEffectType(this.getEffectType());
    }

    public abstract int getFontType();

    public abstract void setFontType(int var1);

    public boolean isFontEnabled() {
        return true;
    }

    public boolean isForegroundEnabled() {
        return true;
    }

    public boolean isBackgroundEnabled() {
        return true;
    }

    public boolean isErrorStripeEnabled() {
        return false;
    }

    public boolean isEffectsColorEnabled() {
        return true;
    }

    public boolean isModified() {
        return false;
    }

    public final boolean isInherited() {
        return this.isInherited;
    }

    public void setInherited(boolean isInherited) {
        this.isInherited = isInherited;
    }

    public boolean isEditable() {
        return !(this.myScheme instanceof ReadOnlyColorsScheme) && (!(this.myScheme instanceof AbstractColorsScheme) || !((AbstractColorsScheme)this.myScheme).isReadOnly());
    }

    @Nullable
    public TextAttributes getBaseAttributes() {
        return null;
    }

    @Nullable
    public Pair<ColorAndFontDescriptorsProvider, ? extends AbstractKeyDescriptor> getFallbackKeyDescriptor() {
        return null;
    }

    public boolean equals(Object o) {
        return this == o;
    }

    public int hashCode() {
        return System.identityHashCode((Object)this);
    }
}

