/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.application.options.codeStyle.cache;

import com.intellij.application.options.codeStyle.cache.CodeStyleCachedValueProvider;
import com.intellij.application.options.codeStyle.cache.CodeStyleCachingService;
import com.intellij.ide.plugins.DynamicPluginListener;
import com.intellij.ide.plugins.IdeaPluginDescriptor;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.openapi.util.UserDataHolderBase;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiFile;
import com.intellij.psi.codeStyle.CodeStyleSettings;
import com.intellij.util.ObjectUtils;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Map;
import java.util.PriorityQueue;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CodeStyleCachingServiceImpl
implements CodeStyleCachingService,
Disposable {
    public static final int MAX_CACHE_SIZE = 100;
    private static final Key<CodeStyleCachedValueProvider> PROVIDER_KEY = Key.create((String)"code.style.cached.value.provider");
    private final Map<String, FileData> myFileDataCache = new HashMap<String, FileData>();
    private final Object CACHE_LOCK = new Object();
    private final PriorityQueue<FileData> myRemoveQueue = new PriorityQueue<FileData>(100, Comparator.comparingLong(fileData -> FileData.access$200(fileData)));

    public CodeStyleCachingServiceImpl() {
        ApplicationManager.getApplication().getMessageBus().connect((Disposable)this).subscribe(DynamicPluginListener.TOPIC, (Object)new DynamicPluginListener(){

            @Override
            public void pluginLoaded(@NotNull IdeaPluginDescriptor pluginDescriptor) {
                CodeStyleCachingServiceImpl.this.clearCache();
            }

            @Override
            public void pluginUnloaded(@NotNull IdeaPluginDescriptor pluginDescriptor, boolean isUpdate) {
                CodeStyleCachingServiceImpl.this.clearCache();
            }
        });
    }

    @Nullable
    public CodeStyleSettings tryGetSettings(@NotNull PsiFile file2) {
        CodeStyleCachedValueProvider provider = this.getOrCreateCachedValueProvider(file2);
        return provider != null ? provider.tryGetSettings() : null;
    }

    public void scheduleWhenSettingsComputed(@NotNull PsiFile file2, @NotNull Runnable runnable2) {
        CodeStyleCachedValueProvider provider = this.getOrCreateCachedValueProvider(file2);
        if (provider != null) {
            provider.scheduleWhenComputed(runnable2);
        } else {
            runnable2.run();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    private CodeStyleCachedValueProvider getOrCreateCachedValueProvider(@NotNull PsiFile file2) {
        Object object = this.CACHE_LOCK;
        synchronized (object) {
            VirtualFile virtualFile = file2.getVirtualFile();
            if (virtualFile != null) {
                FileData fileData = this.getOrCreateFileData(CodeStyleCachingServiceImpl.getFileKey(virtualFile));
                CodeStyleCachedValueProvider provider = (CodeStyleCachedValueProvider)fileData.getUserData(PROVIDER_KEY);
                if (provider == null || provider.isExpired()) {
                    provider = new CodeStyleCachedValueProvider(file2);
                    fileData.putUserData(PROVIDER_KEY, provider);
                }
                return provider;
            }
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void clearCache() {
        Object object = this.CACHE_LOCK;
        synchronized (object) {
            this.myFileDataCache.values().forEach(fileData -> ObjectUtils.consumeIfNotNull((Object)fileData.getUserData(PROVIDER_KEY), provider -> provider.cancelComputation()));
            this.myFileDataCache.clear();
            this.myRemoveQueue.clear();
        }
    }

    @Nullable
    public UserDataHolder getDataHolder(@NotNull VirtualFile virtualFile) {
        return this.getOrCreateFileData(CodeStyleCachingServiceImpl.getFileKey(virtualFile));
    }

    @NotNull
    private synchronized FileData getOrCreateFileData(@NotNull String path) {
        FileData fileData;
        if (this.myFileDataCache.containsKey(path)) {
            FileData fileData2 = this.myFileDataCache.get(path);
            fileData2.update();
            return fileData2;
        }
        FileData newData = new FileData();
        if (this.myFileDataCache.size() >= 100 && (fileData = this.myRemoveQueue.poll()) != null) {
            this.myFileDataCache.values().remove((Object)fileData);
        }
        this.myFileDataCache.put(path, newData);
        this.myRemoveQueue.add(newData);
        return newData;
    }

    @NotNull
    private static String getFileKey(VirtualFile file2) {
        return file2.getUrl();
    }

    public void dispose() {
        this.clearCache();
    }

    private static class FileData
    extends UserDataHolderBase {
        private long lastRefTimeStamp;

        private FileData() {
            this.update();
        }

        void update() {
            this.lastRefTimeStamp = System.currentTimeMillis();
        }
    }
}

