/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.application.options.codeStyle;

import com.intellij.application.options.codeStyle.MarginOptionsUtil;
import com.intellij.application.options.codeStyle.OptionTableWithPreviewPanel;
import com.intellij.lang.Language;
import com.intellij.openapi.application.ApplicationBundle;
import com.intellij.openapi.ui.ComboBox;
import com.intellij.psi.codeStyle.CodeStyleSettings;
import com.intellij.psi.codeStyle.CodeStyleSettingsCustomizable;
import com.intellij.psi.codeStyle.CommonCodeStyleSettings;
import com.intellij.psi.codeStyle.LanguageCodeStyleSettingsProvider;
import com.intellij.psi.codeStyle.presentation.CodeStyleBoundedIntegerSettingPresentation;
import com.intellij.psi.codeStyle.presentation.CodeStyleSelectSettingPresentation;
import com.intellij.psi.codeStyle.presentation.CodeStyleSettingPresentation;
import com.intellij.psi.codeStyle.presentation.CodeStyleSoftMarginsPresentation;
import com.intellij.ui.components.fields.CommaSeparatedIntegersField;
import com.intellij.ui.components.fields.valueEditors.CommaSeparatedIntegersValueEditor;
import com.intellij.util.containers.MultiMap;
import com.intellij.util.ui.UIUtil;
import java.awt.Component;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class WrappingAndBracesPanel
extends OptionTableWithPreviewPanel {
    private final MultiMap<String, String> myGroupToFields = new MultiMap();
    private Map<String, SettingsGroup> myFieldNameToGroup;
    private final CommaSeparatedIntegersField mySoftMarginsEditor = new CommaSeparatedIntegersField(null, 0, 1000, "Optional");
    private final JComboBox<String> myWrapOnTypingCombo = new ComboBox((Object[])WRAP_ON_TYPING_OPTIONS);

    public WrappingAndBracesPanel(CodeStyleSettings settings) {
        super(settings);
        MarginOptionsUtil.customizeWrapOnTypingCombo(this.myWrapOnTypingCombo, settings);
        this.init();
        UIUtil.applyStyle((UIUtil.ComponentStyle)UIUtil.ComponentStyle.MINI, (Component)this.mySoftMarginsEditor);
        UIUtil.applyStyle((UIUtil.ComponentStyle)UIUtil.ComponentStyle.SMALL, this.myWrapOnTypingCombo);
    }

    @Override
    public LanguageCodeStyleSettingsProvider.SettingsType getSettingsType() {
        return LanguageCodeStyleSettingsProvider.SettingsType.WRAPPING_AND_BRACES_SETTINGS;
    }

    @Override
    protected void addOption(@NotNull String fieldName, @NotNull String title, @Nullable String groupName) {
        super.addOption(fieldName, title, groupName);
        if (groupName != null) {
            this.myGroupToFields.putValue((Object)groupName, (Object)fieldName);
        }
    }

    @Override
    protected void addOption(@NotNull String fieldName, @NotNull String title, @Nullable String groupName, String @NotNull [] options2, int @NotNull [] values2) {
        super.addOption(fieldName, title, groupName, options2, values2);
        if (groupName == null) {
            this.myGroupToFields.putValue((Object)title, (Object)fieldName);
        }
    }

    @Override
    protected void initTables() {
        for (Map.Entry entry : CodeStyleSettingPresentation.getStandardSettings((LanguageCodeStyleSettingsProvider.SettingsType)this.getSettingsType()).entrySet()) {
            CodeStyleSettingPresentation.SettingsGroup group = (CodeStyleSettingPresentation.SettingsGroup)entry.getKey();
            for (CodeStyleSettingPresentation setting : (List)entry.getValue()) {
                String fieldName = setting.getFieldName();
                String uiName = setting.getUiName();
                if (setting instanceof CodeStyleBoundedIntegerSettingPresentation) {
                    CodeStyleBoundedIntegerSettingPresentation intSetting = (CodeStyleBoundedIntegerSettingPresentation)setting;
                    int defaultValue = intSetting.getDefaultValue();
                    this.addOption(fieldName, uiName, group.name, intSetting.getLowerBound(), intSetting.getUpperBound(), defaultValue, this.getDefaultIntValueRenderer(fieldName));
                    continue;
                }
                if (setting instanceof CodeStyleSelectSettingPresentation) {
                    CodeStyleSelectSettingPresentation selectSetting = (CodeStyleSelectSettingPresentation)setting;
                    this.addOption(fieldName, uiName, group.name, selectSetting.getOptions(), selectSetting.getValues());
                    continue;
                }
                if (setting instanceof CodeStyleSoftMarginsPresentation) {
                    this.addSoftMarginsOption(fieldName, uiName, group.name);
                    this.showOption(fieldName);
                    continue;
                }
                this.addOption(fieldName, uiName, group.name);
            }
        }
    }

    private Function<Integer, String> getDefaultIntValueRenderer(@NotNull String fieldName) {
        if ("RIGHT_MARGIN".equals(fieldName)) {
            return integer -> MarginOptionsUtil.getDefaultRightMarginText(this.getSettings());
        }
        return integer -> ApplicationBundle.message((String)"integer.field.value.default", (Object[])new Object[0]);
    }

    protected SettingsGroup getAssociatedSettingsGroup(String fieldName) {
        if (this.myFieldNameToGroup == null) {
            this.myFieldNameToGroup = new HashMap<String, SettingsGroup>();
            Set groups = this.myGroupToFields.keySet();
            for (String group : groups) {
                Collection fields2 = this.myGroupToFields.get((Object)group);
                SettingsGroup settingsGroup = new SettingsGroup(group, fields2);
                for (String field : fields2) {
                    this.myFieldNameToGroup.put(field, settingsGroup);
                }
            }
        }
        return this.myFieldNameToGroup.get(fieldName);
    }

    @Override
    protected String getTabTitle() {
        return ApplicationBundle.message((String)"wrapping.and.braces", (Object[])new Object[0]);
    }

    private void addSoftMarginsOption(@NotNull String optionName, @NotNull String title, @Nullable String groupName) {
        Language language = this.getDefaultLanguage();
        if (language != null) {
            this.addCustomOption(new SoftMarginsOption(language, optionName, title, groupName));
        }
    }

    private static List<Integer> castToIntList(@Nullable Object value2) {
        if (value2 instanceof List && ((List)value2).size() > 0 && ((List)value2).get(0) instanceof Integer) {
            return (List)value2;
        }
        return Collections.emptyList();
    }

    @Override
    @Nullable
    protected JComponent getCustomValueRenderer(@NotNull String optionName, @NotNull Object value2) {
        if ("SoftMargins".equals(optionName)) {
            JLabel softMarginsLabel = new JLabel(this.getSoftMarginsString(WrappingAndBracesPanel.castToIntList(value2)));
            UIUtil.applyStyle((UIUtil.ComponentStyle)UIUtil.ComponentStyle.SMALL, (Component)softMarginsLabel);
            return softMarginsLabel;
        }
        if ("WRAP_ON_TYPING".equals(optionName) && value2.equals(ApplicationBundle.message((String)"wrapping.wrap.on.typing.default", (Object[])new Object[0]))) {
            JLabel wrapLabel = new JLabel(MarginOptionsUtil.getDefaultWrapOnTypingText(this.getSettings()));
            UIUtil.applyStyle((UIUtil.ComponentStyle)UIUtil.ComponentStyle.SMALL, (Component)wrapLabel);
            return wrapLabel;
        }
        return super.getCustomValueRenderer(optionName, value2);
    }

    @NotNull
    private String getSoftMarginsString(@NotNull List<Integer> intList) {
        if (intList.size() > 0) {
            return CommaSeparatedIntegersValueEditor.intListToString(intList);
        }
        return MarginOptionsUtil.getDefaultVisualGuidesText(this.getSettings());
    }

    @Override
    @Nullable
    protected JComponent getCustomNodeEditor(@NotNull OptionTableWithPreviewPanel.MyTreeNode node) {
        String optionName = node.getKey().getOptionName();
        if ("SoftMargins".equals(optionName)) {
            this.mySoftMarginsEditor.setValue(WrappingAndBracesPanel.castToIntList(node.getValue()));
            return this.mySoftMarginsEditor;
        }
        if ("WRAP_ON_TYPING".equals(optionName)) {
            Object value2 = node.getValue();
            if (value2 instanceof String) {
                for (int i2 = 0; i2 < CodeStyleSettingsCustomizable.WRAP_ON_TYPING_OPTIONS.length; ++i2) {
                    if (!CodeStyleSettingsCustomizable.WRAP_ON_TYPING_OPTIONS.equals(value2)) continue;
                    this.myWrapOnTypingCombo.setSelectedIndex(i2);
                    break;
                }
            }
            return this.myWrapOnTypingCombo;
        }
        return super.getCustomNodeEditor(node);
    }

    @Override
    @Nullable
    protected Object getCustomNodeEditorValue(@NotNull JComponent customEditor) {
        if (customEditor instanceof CommaSeparatedIntegersField) {
            return ((CommaSeparatedIntegersField)customEditor).getValue();
        }
        if (customEditor == this.myWrapOnTypingCombo) {
            int i2 = this.myWrapOnTypingCombo.getSelectedIndex();
            return i2 >= 0 ? CodeStyleSettingsCustomizable.WRAP_ON_TYPING_OPTIONS[i2] : null;
        }
        return super.getCustomNodeEditorValue(customEditor);
    }

    private static class SoftMarginsOption
    extends OptionTableWithPreviewPanel.Option {
        private final Language myLanguage;

        protected SoftMarginsOption(@NotNull Language language, @NotNull String optionName, @NotNull String title, @Nullable String groupName) {
            super(optionName, title, groupName, null, null);
            this.myLanguage = language;
        }

        @Override
        public Object getValue(CodeStyleSettings settings) {
            CommonCodeStyleSettings langSettings = settings.getCommonSettings(this.myLanguage);
            return langSettings.getSoftMargins();
        }

        @Override
        public void setValue(Object value2, CodeStyleSettings settings) {
            settings.setSoftMargins(this.myLanguage, WrappingAndBracesPanel.castToIntList(value2));
        }

        @Override
        public boolean isEnabled() {
            return true;
        }
    }

    protected static class SettingsGroup {
        public final String title;
        public final Collection<String> commonCodeStyleSettingFieldNames;

        public SettingsGroup(@NotNull String title, @NotNull Collection<String> commonCodeStyleSettingFieldNames) {
            this.title = title;
            this.commonCodeStyleSettingFieldNames = commonCodeStyleSettingFieldNames;
        }
    }
}

