/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.application.options.codeStyle;

import com.intellij.ide.ui.search.SearchUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.ui.SimpleColoredComponent;
import com.intellij.ui.speedSearch.SpeedSearchSupply;
import com.intellij.util.ObjectUtils;
import java.awt.Color;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SpeedSearchHelper {
    @Nullable
    private final SpeedSearchSupply mySpeedSearch;
    @Nullable
    private String mySearchString;

    SpeedSearchHelper() {
        this(null);
    }

    public SpeedSearchHelper(@Nullable SpeedSearchSupply search2) {
        this.mySpeedSearch = search2;
    }

    private String getSearchString() {
        String speedSearch2;
        String string = speedSearch2 = this.mySpeedSearch != null ? this.mySpeedSearch.getEnteredPrefix() : null;
        if (StringUtil.isNotEmpty((String)speedSearch2)) {
            return speedSearch2;
        }
        return (String)ObjectUtils.notNull((Object)this.mySearchString, (Object)"");
    }

    public void find(@NotNull String searchString) {
        this.mySearchString = searchString;
        if (this.mySpeedSearch != null) {
            this.mySpeedSearch.findAndSelectElement(searchString);
        }
    }

    public void setLabelText(@NotNull SimpleColoredComponent label2, @NotNull String text, int style, @Nullable Color foreground, @Nullable Color background) {
        label2.clear();
        SearchUtil.appendFragments(this.getSearchString(), text, style, foreground, background, label2);
    }
}

