/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.application.options;

import com.intellij.application.options.PathMacroExpandableProtocolBean;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.components.PathMacroMap;
import com.intellij.openapi.util.io.FileUtilRt;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.util.text.StringUtilRt;
import com.intellij.openapi.util.text.Strings;
import com.intellij.util.ArrayUtilRt;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.hash.LinkedHashMap;
import it.unimi.dsi.fastutil.objects.Object2IntMap;
import it.unimi.dsi.fastutil.objects.Object2IntOpenHashMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;

public final class ReplacePathToMacroMap
extends PathMacroMap {
    private List<String> myPathsIndex = null;
    private final Map<String, String> myMacroMap = new LinkedHashMap();
    public static final String[] PROTOCOLS;

    public ReplacePathToMacroMap() {
    }

    public ReplacePathToMacroMap(@NotNull ReplacePathToMacroMap map2) {
        this.myMacroMap.putAll(map2.myMacroMap);
    }

    public void addMacroReplacement(String path, String macroName) {
        this.addReplacement(FileUtilRt.toSystemIndependentName((String)path), "$" + macroName + "$", true);
    }

    public void addReplacement(String path, String macroExpr, boolean overwrite) {
        path = Strings.trimEnd((String)path, (String)"/");
        this.putIfAbsent(path, macroExpr, overwrite);
        for (String protocol : PROTOCOLS) {
            this.putIfAbsent(protocol + ":" + path, protocol + ":" + macroExpr, overwrite);
            this.putIfAbsent(protocol + ":/" + path, protocol + ":/" + macroExpr, overwrite);
            this.putIfAbsent(protocol + "://" + path, protocol + "://" + macroExpr, overwrite);
        }
    }

    private void putIfAbsent(String path, String substitution, boolean overwrite) {
        if (overwrite || !this.myMacroMap.containsKey(path)) {
            this.myMacroMap.put(path, substitution);
        }
    }

    @NotNull
    public String substitute(@NotNull String text, boolean caseSensitive) {
        for (String path : this.getPathIndex()) {
            text = this.replacePathMacro(text, path, caseSensitive);
        }
        return text;
    }

    @NotNull
    private String replacePathMacro(@NotNull String text, @NotNull String path, boolean caseSensitive) {
        if (text.length() < path.length() || path.isEmpty()) {
            return text;
        }
        if (!(!caseSensitive ? StringUtilRt.startsWithIgnoreCase((String)text, (String)path) : text.startsWith(path))) {
            return text;
        }
        int endOfOccurrence = path.length();
        boolean isWindowsRoot = path.endsWith(":/");
        if (!(isWindowsRoot || endOfOccurrence >= text.length() || text.charAt(endOfOccurrence) == '/' || text.charAt(endOfOccurrence) == '!' && text.substring(endOfOccurrence).startsWith("!/"))) {
            return text;
        }
        String s = this.myMacroMap.get(path);
        if (text.length() > endOfOccurrence) {
            return s + text.substring(endOfOccurrence);
        }
        return s;
    }

    @NotNull
    public CharSequence substituteRecursively(@NotNull String text, boolean caseSensitive) {
        CharSequence result2 = text;
        for (String path : this.getPathIndex()) {
            result2 = this.replacePathMacroRecursively(result2, path, caseSensitive);
        }
        return result2;
    }

    private CharSequence replacePathMacroRecursively(@NotNull CharSequence text, @NotNull String path, boolean caseSensitive) {
        if (text.length() < path.length() || path.isEmpty()) {
            return text;
        }
        StringBuilder newText = new StringBuilder();
        boolean isWindowsRoot = path.endsWith(":/");
        int i2 = 0;
        while (i2 < text.length()) {
            int occurrenceOfPath;
            int n = occurrenceOfPath = caseSensitive ? Strings.indexOf((CharSequence)text, (CharSequence)path, (int)i2) : Strings.indexOfIgnoreCase((CharSequence)text, (CharSequence)path, (int)i2);
            if (occurrenceOfPath >= 0) {
                char prev;
                int endOfOccurrence = occurrenceOfPath + path.length();
                if (!isWindowsRoot && endOfOccurrence < text.length() && text.charAt(endOfOccurrence) != '/' && text.charAt(endOfOccurrence) != '\"' && text.charAt(endOfOccurrence) != ' ' && !Strings.startsWith((CharSequence)text, (int)endOfOccurrence, (CharSequence)"!/")) {
                    newText.append(text, i2, endOfOccurrence);
                    i2 = endOfOccurrence;
                    continue;
                }
                if (occurrenceOfPath > 0 && (Character.isLetterOrDigit(prev = text.charAt(occurrenceOfPath - 1)) || prev == '_')) {
                    newText.append(text, i2, endOfOccurrence);
                    i2 = endOfOccurrence;
                    continue;
                }
            }
            if (occurrenceOfPath < 0) {
                if (newText.length() == 0) {
                    return text;
                }
                newText.append(text, i2, text.length());
                break;
            }
            newText.append(text, i2, occurrenceOfPath);
            newText.append(this.myMacroMap.get(path));
            i2 = occurrenceOfPath + path.length();
        }
        return newText;
    }

    private static int getIndex(@NotNull String replacement) {
        if (replacement.contains("..") || replacement.contains("$USER_HOME$") || replacement.contains("$APPLICATION_HOME_DIR$") || replacement.contains("$MAVEN_REPOSITORY$")) {
            return 1;
        }
        if (replacement.contains("$MODULE_DIR$") || replacement.contains("$PROJECT_DIR$")) {
            return 3;
        }
        return 2;
    }

    private static int stripPrefix(@NotNull String key) {
        key = StringUtil.trimStart((String)key, (String)"jar:");
        key = StringUtil.trimStart((String)key, (String)"file:");
        while (key.startsWith("/")) {
            key = key.substring(1);
        }
        return key.length();
    }

    @NotNull
    private List<String> getPathIndex() {
        if (this.myPathsIndex != null && this.myPathsIndex.size() == this.myMacroMap.size()) {
            return this.myPathsIndex;
        }
        ArrayList<Map.Entry<String, String>> entries = new ArrayList<Map.Entry<String, String>>(this.myMacroMap.entrySet());
        Object2IntOpenHashMap weights = new Object2IntOpenHashMap(entries.size());
        for (Map.Entry entry2 : entries) {
            weights.put(entry2.getKey(), ReplacePathToMacroMap.getIndex((String)entry2.getValue()) * 512 + ReplacePathToMacroMap.stripPrefix((String)entry2.getKey()));
        }
        entries.sort((arg_0, arg_1) -> ReplacePathToMacroMap.lambda$getPathIndex$1((Object2IntMap)weights, arg_0, arg_1));
        this.myPathsIndex = ContainerUtil.map2List(entries, entry -> (String)entry.getKey());
        return this.myPathsIndex;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof ReplacePathToMacroMap)) {
            return false;
        }
        return this.myMacroMap.equals(((ReplacePathToMacroMap)((Object)obj)).myMacroMap);
    }

    public int hashCode() {
        return this.myMacroMap.hashCode();
    }

    public void put(String path, String replacement) {
        this.myMacroMap.put(path, replacement);
    }

    public String toString() {
        return "macroMap: " + this.myMacroMap + "\n\npathsIndex: " + StringUtil.join(this.myPathsIndex, (String)"\n");
    }

    private static /* synthetic */ int lambda$getPathIndex$1(Object2IntMap weights, Map.Entry o1, Map.Entry o2) {
        return weights.getInt(o2.getKey()) - weights.getInt(o1.getKey());
    }

    static {
        ArrayList<String> protocols = new ArrayList<String>();
        protocols.add("file");
        protocols.add("jar");
        if (ApplicationManager.getApplication().getExtensionArea().hasExtensionPoint(PathMacroExpandableProtocolBean.EP_NAME)) {
            PathMacroExpandableProtocolBean.EP_NAME.forEachExtensionSafe(bean -> protocols.add(bean.protocol));
        }
        PROTOCOLS = ArrayUtilRt.toStringArray(protocols);
    }
}

