/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.analysis.problemsView.toolWindow;

import com.intellij.analysis.problemsView.toolWindow.FileNode;
import com.intellij.analysis.problemsView.toolWindow.Node;
import com.intellij.analysis.problemsView.toolWindow.Problem;
import com.intellij.analysis.problemsView.toolWindow.ProblemFilter;
import com.intellij.analysis.problemsView.toolWindow.ProblemNode;
import com.intellij.openapi.vfs.VirtualFile;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000X\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010#\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u001e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0000\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u000e\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u000bJ\u0006\u0010\u0012\u001a\u00020\u0013J\u0006\u0010\u0014\u001a\u00020\u0015J\u0010\u0010\u0014\u001a\u00020\u00152\b\u0010\u0016\u001a\u0004\u0018\u00010\u0017J\u0010\u0010\u0018\u001a\u0004\u0018\u00010\f2\u0006\u0010\u0011\u001a\u00020\u000bJ\u0018\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u000b0\u001a2\b\u0010\u0016\u001a\u0004\u0018\u00010\u0017H\u0002J\u000e\u0010\u001b\u001a\u00020\b2\u0006\u0010\u001c\u001a\u00020\u001dJ\u0018\u0010\u001e\u001a\u00020\f2\u0006\u0010\u001c\u001a\u00020\b2\u0006\u0010\u0011\u001a\u00020\u000bH\u0002J\u0016\u0010\u001f\u001a\b\u0012\u0004\u0012\u00020\f0\u001a2\b\u0010\u0016\u001a\u0004\u0018\u00010\u0017J\u000e\u0010 \u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u000bR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006R\u0010\u0010\u0007\u001a\u0004\u0018\u00010\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001a\u0010\t\u001a\u000e\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\f0\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000b0\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006!"}, d2={"Lcom/intellij/analysis/problemsView/toolWindow/FileProblems;", "", "file", "Lcom/intellij/openapi/vfs/VirtualFile;", "(Lcom/intellij/openapi/vfs/VirtualFile;)V", "getFile", "()Lcom/intellij/openapi/vfs/VirtualFile;", "fileNode", "Lcom/intellij/analysis/problemsView/toolWindow/FileNode;", "nodes", "", "Lcom/intellij/analysis/problemsView/toolWindow/Problem;", "Lcom/intellij/analysis/problemsView/toolWindow/ProblemNode;", "problems", "", "add", "", "problem", "clear", "", "count", "", "filter", "Lcom/intellij/analysis/problemsView/toolWindow/ProblemFilter;", "findProblemNode", "get", "", "getFileNode", "parent", "Lcom/intellij/analysis/problemsView/toolWindow/Node;", "getProblemNode", "getProblemNodes", "remove", "intellij.platform.lang.impl"})
public final class FileProblems {
    private final Set<Problem> problems;
    private final Map<Problem, ProblemNode> nodes;
    private FileNode fileNode;
    @NotNull
    private final VirtualFile file;

    @NotNull
    public final FileNode getFileNode(@NotNull Node parent) {
        FileNode newNode;
        FileNode oldNode;
        FileNode fileNode = oldNode = this.fileNode;
        if ((fileNode != null ? fileNode.getParentDescriptor() : null) == parent) {
            return oldNode;
        }
        this.fileNode = newNode = new FileNode(parent, this.file);
        this.nodes.clear();
        return newNode;
    }

    private final ProblemNode getProblemNode(FileNode parent, Problem problem) {
        ProblemNode oldNode;
        ProblemNode problemNode = oldNode = this.nodes.get(problem);
        if ((problemNode != null ? problemNode.getParentDescriptor() : null) == parent) {
            return oldNode;
        }
        ProblemNode newNode = new ProblemNode(parent, problem);
        this.nodes.put(problem, newNode);
        return newNode;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final Collection<ProblemNode> getProblemNodes(@Nullable ProblemFilter filter2) {
        void $this$mapTo$iv$iv;
        if (this.problems.isEmpty()) {
            return CollectionsKt.emptyList();
        }
        FileNode fileNode = this.fileNode;
        if (fileNode == null) {
            return CollectionsKt.emptyList();
        }
        FileNode parent = fileNode;
        Iterable $this$map$iv = this.get(filter2);
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            Problem problem = (Problem)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            ProblemNode problemNode = this.getProblemNode(parent, (Problem)it);
            collection.add(problemNode);
        }
        return (List)destination$iv$iv;
    }

    @Nullable
    public final ProblemNode findProblemNode(@NotNull Problem problem) {
        FileNode fileNode = this.fileNode;
        if (fileNode == null) {
            return null;
        }
        FileNode parent = fileNode;
        return this.getProblemNode(parent, problem);
    }

    public final boolean add(@NotNull Problem problem) {
        return this.problems.add(problem);
    }

    public final boolean remove(@NotNull Problem problem) {
        if (!this.problems.remove(problem)) {
            return false;
        }
        this.nodes.remove(problem);
        return true;
    }

    public final void clear() {
        this.problems.clear();
        this.nodes.clear();
    }

    public final int count() {
        return this.problems.size();
    }

    public final int count(@Nullable ProblemFilter filter2) {
        int n;
        if (filter2 == null) {
            n = this.problems.size();
        } else {
            Iterable $this$count$iv = this.problems;
            boolean $i$f$count = false;
            if ($this$count$iv instanceof Collection && ((Collection)$this$count$iv).isEmpty()) {
                n = 0;
            } else {
                int count$iv = 0;
                for (Object element$iv : $this$count$iv) {
                    if (!((Boolean)((Function1)filter2).invoke(element$iv)).booleanValue()) continue;
                    int n2 = ++count$iv;
                    boolean bl = false;
                    if (n2 >= 0) continue;
                    CollectionsKt.throwCountOverflow();
                }
                n = count$iv;
            }
        }
        return n;
    }

    /*
     * WARNING - void declaration
     */
    private final Collection<Problem> get(ProblemFilter filter2) {
        Collection collection;
        if (filter2 == null) {
            collection = this.problems;
        } else {
            void $this$filterTo$iv$iv;
            Iterable $this$filter$iv = this.problems;
            boolean $i$f$filter = false;
            Iterable iterable = $this$filter$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterTo = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv) {
                if (!((Boolean)((Function1)filter2).invoke(element$iv$iv)).booleanValue()) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            collection = (List)destination$iv$iv;
        }
        return collection;
    }

    @NotNull
    public final VirtualFile getFile() {
        return this.file;
    }

    public FileProblems(@NotNull VirtualFile file2) {
        this.file = file2;
        boolean bl = false;
        this.problems = new LinkedHashSet();
        bl = false;
        this.nodes = new LinkedHashMap();
    }
}

