/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.highlighter;

import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.function.Predicate;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.descriptors.ValueParameterDescriptor;
import org.jetbrains.kotlin.diagnostics.rendering.DiagnosticParameterRenderer;
import org.jetbrains.kotlin.diagnostics.rendering.RenderingContext;
import org.jetbrains.kotlin.diagnostics.rendering.SmartDescriptorRenderer;
import org.jetbrains.kotlin.diagnostics.rendering.SmartTypeRenderer;
import org.jetbrains.kotlin.diagnostics.rendering.TabledDescriptorRenderer;
import org.jetbrains.kotlin.idea.KotlinIdeaAnalysisBundle;
import org.jetbrains.kotlin.idea.highlighter.IdeRenderers;
import org.jetbrains.kotlin.idea.highlighter.renderersUtil.RenderersUtilKt;
import org.jetbrains.kotlin.renderer.DescriptorRenderer;
import org.jetbrains.kotlin.renderer.DescriptorRendererOptions;
import org.jetbrains.kotlin.renderer.RenderingFormat;
import org.jetbrains.kotlin.resolve.calls.inference.constraintPosition.ConstraintPosition;
import org.jetbrains.kotlin.resolve.calls.inference.constraintPosition.ConstraintPositionKind;
import org.jetbrains.kotlin.types.KotlinType;

public class HtmlTabledDescriptorRenderer
extends TabledDescriptorRenderer {
    private static final DescriptorRenderer.ValueParametersHandler VALUE_PARAMETERS_HANDLER = new DescriptorRenderer.ValueParametersHandler(){

        public void appendBeforeValueParameter(@NotNull ValueParameterDescriptor parameter, int parameterIndex, int parameterCount, @NotNull StringBuilder builder) {
            if (parameter == null) {
                1.$$$reportNull$$$0(0);
            }
            if (builder == null) {
                1.$$$reportNull$$$0(1);
            }
            builder.append("<td align=\"right\" style=\"white-space:nowrap;font-weight:bold;\">");
        }

        public void appendAfterValueParameter(@NotNull ValueParameterDescriptor parameter, int parameterIndex, int parameterCount, @NotNull StringBuilder builder) {
            boolean last;
            if (parameter == null) {
                1.$$$reportNull$$$0(2);
            }
            if (builder == null) {
                1.$$$reportNull$$$0(3);
            }
            boolean bl = last = parameterIndex == parameterCount - 1;
            if (!last) {
                builder.append(",");
            }
            builder.append("</td>");
        }

        public void appendBeforeValueParameters(int parameterCount, @NotNull StringBuilder builder) {
            if (builder == null) {
                1.$$$reportNull$$$0(4);
            }
            builder.append("</td>");
            if (parameterCount == 0) {
                HtmlTabledDescriptorRenderer.tdBold(builder, "( )");
            } else {
                HtmlTabledDescriptorRenderer.tdBold(builder, "(");
            }
        }

        public void appendAfterValueParameters(int parameterCount, @NotNull StringBuilder builder) {
            if (builder == null) {
                1.$$$reportNull$$$0(5);
            }
            if (parameterCount != 0) {
                HtmlTabledDescriptorRenderer.tdBold(builder, ")");
            }
            builder.append("<td style=\"white-space:nowrap;font-weight:bold;\">");
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "parameter";
                    break;
                }
                case 1: 
                case 3: 
                case 4: 
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "builder";
                    break;
                }
            }
            objectArray2[1] = "org/jetbrains/kotlin/idea/highlighter/HtmlTabledDescriptorRenderer$1";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "appendBeforeValueParameter";
                    break;
                }
                case 2: 
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[2] = "appendAfterValueParameter";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[2] = "appendBeforeValueParameters";
                    break;
                }
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[2] = "appendAfterValueParameters";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    };
    private static final DiagnosticParameterRenderer<DeclarationDescriptor> DESCRIPTOR_IN_TABLE = new SmartDescriptorRenderer(DescriptorRenderer.Companion.withOptions((Function1)new Function1<DescriptorRendererOptions, Unit>(){

        public Unit invoke(DescriptorRendererOptions options) {
            options.setWithDefinedIn(false);
            options.setModifiers(Collections.emptySet());
            options.setValueParametersHandler(VALUE_PARAMETERS_HANDLER);
            options.setTextFormat(RenderingFormat.HTML);
            return Unit.INSTANCE;
        }
    }));

    @NotNull
    public DiagnosticParameterRenderer<KotlinType> getTypeRenderer() {
        SmartTypeRenderer smartTypeRenderer = IdeRenderers.HTML_RENDER_TYPE;
        if (smartTypeRenderer == null) {
            HtmlTabledDescriptorRenderer.$$$reportNull$$$0(0);
        }
        return smartTypeRenderer;
    }

    protected void renderText(TabledDescriptorRenderer.TextRenderer textRenderer, StringBuilder result) {
        for (TabledDescriptorRenderer.TextRenderer.TextElement element2 : textRenderer.elements) {
            HtmlTabledDescriptorRenderer.renderText(result, element2.type, element2.text);
        }
    }

    private static void renderText(StringBuilder result, TabledDescriptorRenderer.TextElementType elementType, String text2) {
        if (elementType == TabledDescriptorRenderer.TextElementType.DEFAULT) {
            result.append(text2);
        } else if (elementType == TabledDescriptorRenderer.TextElementType.ERROR) {
            result.append(RenderersUtilKt.renderError(text2));
        } else if (elementType == TabledDescriptorRenderer.TextElementType.STRONG) {
            result.append(RenderersUtilKt.renderStrong(text2));
        }
    }

    private static int countColumnNumber(TabledDescriptorRenderer.TableRenderer table) {
        int argumentsNumber = 0;
        for (TabledDescriptorRenderer.TableRenderer.TableRow row : table.rows) {
            int argumentTypesNumber;
            if (row instanceof TabledDescriptorRenderer.TableRenderer.DescriptorRow) {
                int valueParametersNumber = ((TabledDescriptorRenderer.TableRenderer.DescriptorRow)row).descriptor.getValueParameters().size();
                if (valueParametersNumber <= argumentsNumber) continue;
                argumentsNumber = valueParametersNumber;
                continue;
            }
            if (!(row instanceof TabledDescriptorRenderer.TableRenderer.FunctionArgumentsRow) || (argumentTypesNumber = ((TabledDescriptorRenderer.TableRenderer.FunctionArgumentsRow)row).argumentTypes.size()) <= argumentsNumber) continue;
            argumentsNumber = argumentTypesNumber;
        }
        return argumentsNumber + 6;
    }

    protected void renderTable(TabledDescriptorRenderer.TableRenderer table, StringBuilder result) {
        if (table.rows.isEmpty()) {
            return;
        }
        RenderingContext context = HtmlTabledDescriptorRenderer.computeRenderingContext((TabledDescriptorRenderer.TableRenderer)table);
        int rowsNumber = HtmlTabledDescriptorRenderer.countColumnNumber(table);
        result.append("<table>");
        for (TabledDescriptorRenderer.TableRenderer.TableRow row : table.rows) {
            result.append("<tr>");
            if (row instanceof TabledDescriptorRenderer.TextRenderer) {
                StringBuilder rowText = new StringBuilder();
                this.renderText((TabledDescriptorRenderer.TextRenderer)row, rowText);
                HtmlTabledDescriptorRenderer.tdColspan(result, rowText.toString(), rowsNumber);
            }
            if (row instanceof TabledDescriptorRenderer.TableRenderer.DescriptorRow) {
                HtmlTabledDescriptorRenderer.tdSpace(result);
                HtmlTabledDescriptorRenderer.tdRightBoldColspan(result, 2, DESCRIPTOR_IN_TABLE.render((Object)((TabledDescriptorRenderer.TableRenderer.DescriptorRow)row).descriptor, context));
            }
            if (row instanceof TabledDescriptorRenderer.TableRenderer.FunctionArgumentsRow) {
                TabledDescriptorRenderer.TableRenderer.FunctionArgumentsRow functionArgumentsRow = (TabledDescriptorRenderer.TableRenderer.FunctionArgumentsRow)row;
                this.renderFunctionArguments(functionArgumentsRow.receiverType, functionArgumentsRow.argumentTypes, functionArgumentsRow.isErrorPosition, result, context);
            }
            result.append("</tr>");
        }
        result.append("</table>");
    }

    private void renderFunctionArguments(@Nullable KotlinType receiverType, @NotNull List<KotlinType> argumentTypes, Predicate<ConstraintPosition> isErrorPosition, StringBuilder result, @NotNull RenderingContext context) {
        if (argumentTypes == null) {
            HtmlTabledDescriptorRenderer.$$$reportNull$$$0(1);
        }
        if (context == null) {
            HtmlTabledDescriptorRenderer.$$$reportNull$$$0(2);
        }
        boolean hasReceiver = receiverType != null;
        HtmlTabledDescriptorRenderer.tdSpace(result);
        String receiver = "";
        if (hasReceiver) {
            boolean error = false;
            if (isErrorPosition.test(ConstraintPositionKind.RECEIVER_POSITION.position())) {
                error = true;
            }
            receiver = KotlinIdeaAnalysisBundle.message("function.receiver.0", RenderersUtilKt.renderStrong(this.getTypeRenderer().render((Object)receiverType, context), error));
        }
        HtmlTabledDescriptorRenderer.td(result, receiver);
        HtmlTabledDescriptorRenderer.td(result, hasReceiver ? KotlinIdeaAnalysisBundle.message("function.arguments", new Object[0]) : "");
        if (argumentTypes.isEmpty()) {
            HtmlTabledDescriptorRenderer.tdBold(result, "( )");
            return;
        }
        HtmlTabledDescriptorRenderer.td(result, RenderersUtilKt.renderStrong("("));
        int i2 = 0;
        Iterator<KotlinType> iterator = argumentTypes.iterator();
        while (iterator.hasNext()) {
            KotlinType argumentType = iterator.next();
            boolean error = false;
            if (isErrorPosition.test(ConstraintPositionKind.VALUE_PARAMETER_POSITION.position(i2))) {
                error = true;
            }
            String renderedArgument = argumentType == null ? "unknown" : this.getTypeRenderer().render((Object)argumentType, context);
            HtmlTabledDescriptorRenderer.tdRight(result, RenderersUtilKt.renderStrong(renderedArgument, error) + (iterator.hasNext() ? RenderersUtilKt.renderStrong(",") : ""));
            ++i2;
        }
        HtmlTabledDescriptorRenderer.td(result, RenderersUtilKt.renderStrong(")"));
    }

    public static HtmlTabledDescriptorRenderer create() {
        return new HtmlTabledDescriptorRenderer();
    }

    protected HtmlTabledDescriptorRenderer() {
    }

    private static void td(StringBuilder builder, String text2) {
        builder.append("<td style=\"white-space:nowrap;\">").append(text2).append("</td>");
    }

    private static void tdSpace(StringBuilder builder) {
        builder.append("<td width=\"10%\"></td>");
    }

    private static void tdColspan(StringBuilder builder, String text2, int colspan) {
        builder.append("<td colspan=\"").append(colspan).append("\" style=\"white-space:nowrap;\">").append(text2).append("</td>");
    }

    private static void tdBold(StringBuilder builder, String text2) {
        builder.append("<td style=\"white-space:nowrap;font-weight:bold;\">").append(text2).append("</td>");
    }

    private static void tdRight(StringBuilder builder, String text2) {
        builder.append("<td align=\"right\" style=\"white-space:nowrap;\">").append(text2).append("</td>");
    }

    private static void tdRightBoldColspan(StringBuilder builder, int colspan, String text2) {
        builder.append("<td align=\"right\" colspan=\"").append(colspan).append("\" style=\"white-space:nowrap;font-weight:bold;\">").append(text2).append("</td>");
    }

    public static String tableForTypes(String message, String firstDescription, TabledDescriptorRenderer.TextElementType firstType, String secondDescription, TabledDescriptorRenderer.TextElementType secondType) {
        StringBuilder result = new StringBuilder();
        result.append("<html>").append(message);
        result.append("<table><tr><td>").append(firstDescription).append("</td><td>");
        HtmlTabledDescriptorRenderer.renderText(result, firstType, "{0}");
        result.append("</td></tr><tr><td>").append(secondDescription).append("</td><td>");
        HtmlTabledDescriptorRenderer.renderText(result, secondType, "{1}");
        result.append("</td></tr></table></html>");
        return result.toString();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: 
            case 2: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: 
            case 2: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/kotlin/idea/highlighter/HtmlTabledDescriptorRenderer";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "argumentTypes";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getTypeRenderer";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/kotlin/idea/highlighter/HtmlTabledDescriptorRenderer";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "renderFunctionArguments";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: 
            case 2: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

