/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.core.script.configuration.loader;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiFile;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.idea.core.script.configuration.cache.ScriptConfigurationSnapshot;
import org.jetbrains.kotlin.idea.core.script.configuration.loader.ScriptConfigurationLoader;
import org.jetbrains.kotlin.idea.core.script.configuration.loader.ScriptConfigurationLoadingContext;
import org.jetbrains.kotlin.idea.highlighter.OutsidersPsiFileSupportUtils;
import org.jetbrains.kotlin.psi.KtFile;
import org.jetbrains.kotlin.scripting.definitions.ScriptDefinition;

@Metadata(mv={1, 1, 18}, bv={1, 0, 3}, k=1, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0000\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J(\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\b2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0010"}, d2={"Lorg/jetbrains/kotlin/idea/core/script/configuration/loader/ScriptOutsiderFileConfigurationLoader;", "Lorg/jetbrains/kotlin/idea/core/script/configuration/loader/ScriptConfigurationLoader;", "project", "Lcom/intellij/openapi/project/Project;", "(Lcom/intellij/openapi/project/Project;)V", "getProject", "()Lcom/intellij/openapi/project/Project;", "loadDependencies", "", "isFirstLoad", "ktFile", "Lorg/jetbrains/kotlin/psi/KtFile;", "scriptDefinition", "Lorg/jetbrains/kotlin/scripting/definitions/ScriptDefinition;", "context", "Lorg/jetbrains/kotlin/idea/core/script/configuration/loader/ScriptConfigurationLoadingContext;", "kotlin.core"})
public final class ScriptOutsiderFileConfigurationLoader
implements ScriptConfigurationLoader {
    @NotNull
    private final Project project;

    @Override
    public boolean loadDependencies(boolean isFirstLoad, @NotNull KtFile ktFile, @NotNull ScriptDefinition scriptDefinition, @NotNull ScriptConfigurationLoadingContext context) {
        VirtualFile virtualFile;
        Intrinsics.checkNotNullParameter((Object)ktFile, (String)"ktFile");
        Intrinsics.checkNotNullParameter((Object)scriptDefinition, (String)"scriptDefinition");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        if (!isFirstLoad) {
            return false;
        }
        PsiFile psiFile = ktFile.getOriginalFile();
        Intrinsics.checkNotNullExpressionValue((Object)psiFile, (String)"ktFile.originalFile");
        VirtualFile virtualFile2 = virtualFile = psiFile.getVirtualFile();
        Intrinsics.checkNotNullExpressionValue((Object)virtualFile2, (String)"virtualFile");
        VirtualFile virtualFile3 = OutsidersPsiFileSupportUtils.INSTANCE.getOutsiderFileOrigin(this.project, virtualFile2);
        if (virtualFile3 == null) {
            return false;
        }
        VirtualFile fileOrigin = virtualFile3;
        ScriptConfigurationSnapshot original = context.getCachedConfiguration(fileOrigin);
        if (original != null) {
            boolean bl = false;
            context.saveNewConfiguration(virtualFile, new ScriptConfigurationSnapshot(original.getInputs(), CollectionsKt.emptyList(), original.getConfiguration()));
        }
        return true;
    }

    @NotNull
    public final Project getProject() {
        return this.project;
    }

    public ScriptOutsiderFileConfigurationLoader(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        this.project = project;
    }

    @Override
    public boolean shouldRunInBackground(@NotNull ScriptDefinition scriptDefinition) {
        Intrinsics.checkNotNullParameter((Object)scriptDefinition, (String)"scriptDefinition");
        return ScriptConfigurationLoader.DefaultImpls.shouldRunInBackground(this, scriptDefinition);
    }

    @Override
    public boolean interceptBackgroundLoading(@NotNull VirtualFile file, boolean isFirstLoad, @NotNull Function0<Unit> doLoad) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        Intrinsics.checkNotNullParameter(doLoad, (String)"doLoad");
        return ScriptConfigurationLoader.DefaultImpls.interceptBackgroundLoading(this, file, isFirstLoad, doLoad);
    }

    @Override
    public void hideInterceptedNotification(@NotNull VirtualFile file) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        ScriptConfigurationLoader.DefaultImpls.hideInterceptedNotification(this, file);
    }
}

