/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.xml.ui;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.command.WriteCommandAction;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.Factory;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiFile;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.psi.xml.XmlFile;
import com.intellij.util.xml.DomElement;
import com.intellij.util.xml.DomManager;
import com.intellij.util.xml.StableElement;
import com.intellij.util.xml.ui.BasicDomElementComponent;
import com.intellij.util.xml.ui.CommittablePanel;
import com.intellij.util.xml.ui.DomFileEditor;
import com.intellij.util.xml.ui.EditedElementDescription;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;

public class MockDomElementsEditor {
    private final Map<EditedElementDescription<? extends DomElement>, DomElement> myDomElements = new HashMap<EditedElementDescription<? extends DomElement>, DomElement>();
    private final Module myModule;
    private CommittablePanel myContents;
    private DomFileEditor myFileEditor;

    public MockDomElementsEditor(Module module) {
        this.myModule = module;
    }

    protected final <T extends DomElement> T addEditedElement(Class<? extends T> aClass, EditedElementDescription<T> description) {
        DomManager domManager = DomManager.getDomManager(this.myModule.getProject());
        Object t = domManager.createStableValue(() -> {
            Object t1 = description.find();
            if (t1 == null) {
                return this.createMockElement(aClass);
            }
            return t1;
        });
        this.myDomElements.put((EditedElementDescription<? extends DomElement>)description, (DomElement)t);
        return t;
    }

    protected <T extends DomElement> T createMockElement(Class<T> aClass) {
        return this.createMockElement(aClass, this.myModule);
    }

    protected final DomFileEditor initFileEditor(BasicDomElementComponent component, VirtualFile virtualFile, String name) {
        this.initFileEditor(component.getProject(), virtualFile, name, (Factory<? extends BasicDomElementComponent>)((Factory)() -> component));
        Disposer.register((Disposable)this.myFileEditor, (Disposable)component);
        return this.myFileEditor;
    }

    protected final DomFileEditor initFileEditor(final Project project, VirtualFile virtualFile, String name, Factory<? extends BasicDomElementComponent> component) {
        this.myFileEditor = new DomFileEditor<BasicDomElementComponent>(project, virtualFile, name, component){

            @Override
            public JComponent getPreferredFocusedComponent() {
                return null;
            }

            @Override
            @NotNull
            protected JComponent createCustomComponent() {
                JComponent customComponent = super.createCustomComponent();
                MockDomElementsEditor.this.myContents = this.getDomComponent();
                return customComponent;
            }

            @Override
            public void reset() {
                for (Map.Entry entry : MockDomElementsEditor.this.myDomElements.entrySet()) {
                    Object newValue = ((EditedElementDescription)entry.getKey()).find();
                    DomElement oldValue = (DomElement)entry.getValue();
                    if ((newValue == null || newValue.equals(oldValue)) && (newValue != null || oldValue.getManager().isMockElement(oldValue))) continue;
                    ((StableElement)((Object)oldValue)).revalidate();
                }
                super.reset();
            }

            @Override
            public void commit() {
                super.commit();
                ArrayList<EditedElementDescription> descriptions = new ArrayList<EditedElementDescription>();
                HashSet<XmlFile> changedFiles = new HashSet<XmlFile>();
                for (Map.Entry entry : MockDomElementsEditor.this.myDomElements.entrySet()) {
                    EditedElementDescription description = (EditedElementDescription)entry.getKey();
                    DomElement editedElement = (DomElement)entry.getValue();
                    if (description.find() != null || editedElement.getXmlTag() == null) continue;
                    descriptions.add(description);
                    XmlFile xmlFile = description.getEditedFile();
                    if (xmlFile == null) continue;
                    changedFiles.add(xmlFile);
                }
                WriteCommandAction.writeCommandAction((Project)project, (PsiFile[])PsiUtilCore.toPsiFileArray(changedFiles)).run(() -> {
                    for (EditedElementDescription description : descriptions) {
                        DomElement editedElement = (DomElement)MockDomElementsEditor.this.myDomElements.get(description);
                        Object element = description.addElement();
                        element.copyFrom(editedElement);
                        description.initialize(element);
                        this.removeWatchedElement(editedElement);
                        ((StableElement)((Object)editedElement)).invalidate();
                    }
                });
            }
        };
        DomManager domManager = DomManager.getDomManager(project);
        for (DomElement element : this.myDomElements.values()) {
            if (!domManager.isMockElement(element)) continue;
            this.myFileEditor.addWatchedElement(element);
        }
        return this.myFileEditor;
    }

    public final DomFileEditor getFileEditor() {
        return this.myFileEditor;
    }

    private <T extends DomElement> T createMockElement(Class<T> aClass, Module module) {
        Project project = module.getProject();
        ApplicationManager.getApplication().invokeLater(() -> {
            if (this.myFileEditor.isInitialised()) {
                this.myContents.reset();
            }
        });
        DomManager domManager = DomManager.getDomManager(project);
        T mockElement = domManager.createMockElement(aClass, module, true);
        if (this.myFileEditor != null) {
            this.myFileEditor.addWatchedElement((DomElement)mockElement);
        }
        return mockElement;
    }
}

