/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.testFramework.fixtures.impl;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.WriteAction;
import com.intellij.openapi.util.Computable;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileFilter;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.testFramework.LightPlatformTestCase;
import com.intellij.testFramework.UsefulTestCase;
import com.intellij.testFramework.fixtures.TempDirTestFixture;
import com.intellij.testFramework.fixtures.impl.BaseFixture;
import com.intellij.util.PathUtil;
import java.io.IOException;
import java.util.List;
import kotlin.Lazy;
import kotlin.LazyKt;
import org.jetbrains.annotations.NotNull;
import org.junit.Assert;

public final class LightTempDirTestFixtureImpl
extends BaseFixture
implements TempDirTestFixture {
    private final Lazy<VirtualFile> mySourceRoot;

    public LightTempDirTestFixtureImpl() {
        this(false);
    }

    public LightTempDirTestFixtureImpl(boolean usePlatformSourceRoot) {
        this.mySourceRoot = usePlatformSourceRoot ? LazyKt.lazyOf(null) : LazyKt.lazy(() -> {
            VirtualFile fsRoot = VirtualFileManager.getInstance().findFileByUrl("temp:///");
            Assert.assertNotNull((Object)fsRoot);
            try {
                return (VirtualFile)WriteAction.computeAndWait(() -> fsRoot.createChildDirectory((Object)this, "root"));
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        });
    }

    @Override
    public void tearDown() throws Exception {
        try {
            this.deleteAll();
        }
        catch (Throwable e) {
            this.addSuppressedException(e);
        }
        finally {
            super.tearDown();
        }
    }

    @Override
    @NotNull
    public VirtualFile findOrCreateDir(@NotNull String path) {
        return (VirtualFile)WriteAction.computeAndWait(() -> {
            try {
                return this.findOrCreateChildDir(this.getSourceRoot(), path);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        });
    }

    @Override
    @NotNull
    public VirtualFile copyAll(@NotNull String dataDir, @NotNull String targetDir) {
        return this.copyAll(dataDir, targetDir, VirtualFileFilter.ALL);
    }

    @Override
    @NotNull
    public VirtualFile copyAll(final @NotNull String dataDir, final @NotNull String targetDir, final @NotNull VirtualFileFilter filter) {
        return (VirtualFile)ApplicationManager.getApplication().runWriteAction((Computable)new Computable<VirtualFile>(){

            public VirtualFile compute() {
                VirtualFile from = LocalFileSystem.getInstance().refreshAndFindFileByPath(dataDir);
                Assert.assertNotNull((String)("Cannot find testdata directory " + dataDir), (Object)from);
                try {
                    UsefulTestCase.refreshRecursively(from);
                    VirtualFile tempDir = LightTempDirTestFixtureImpl.this.getSourceRoot();
                    if (targetDir.length() > 0) {
                        tempDir = LightTempDirTestFixtureImpl.this.findOrCreateChildDir(tempDir, targetDir);
                    }
                    VfsUtil.copyDirectory((Object)this, (VirtualFile)from, (VirtualFile)tempDir, (VirtualFileFilter)filter);
                    return tempDir;
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            }
        });
    }

    private VirtualFile findOrCreateChildDir(VirtualFile root, String relativePath) throws IOException {
        if (relativePath.length() == 0) {
            return root;
        }
        List dirs = StringUtil.split((String)StringUtil.trimStart((String)relativePath, (String)"/"), (String)"/");
        for (String dirName : dirs) {
            if (dirName.equals(".")) continue;
            if (dirName.equals("..")) {
                if ((root = root.getParent()) != null) continue;
                throw new IllegalArgumentException("Invalid path: " + relativePath);
            }
            VirtualFile dir = root.findChild(dirName);
            if (dir != null) {
                root = dir;
                continue;
            }
            root = root.createChildDirectory((Object)this, dirName);
        }
        return root;
    }

    @Override
    @NotNull
    public String getTempDirPath() {
        return "temp:///root";
    }

    @Override
    public VirtualFile getFile(@NotNull String path) {
        VirtualFile sourceRoot = this.getSourceRoot();
        VirtualFile result = sourceRoot.findFileByRelativePath(path);
        if (result == null) {
            sourceRoot.refresh(false, true);
            result = sourceRoot.findFileByRelativePath(path);
        }
        return result;
    }

    @Override
    @NotNull
    public VirtualFile createFile(@NotNull String targetPath) {
        try {
            return (VirtualFile)WriteAction.computeAndWait(() -> this.doCreateFile(targetPath));
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @NotNull
    private VirtualFile doCreateFile(@NotNull String targetPath) throws IOException {
        String path = PathUtil.getParentPath((String)targetPath);
        String name = PathUtil.getFileName((String)targetPath);
        VirtualFile targetDir = this.findOrCreateDir(path);
        return targetDir.createChildData((Object)this, name);
    }

    @Override
    @NotNull
    public VirtualFile createFile(@NotNull String name, @NotNull String text) throws IOException {
        return (VirtualFile)WriteAction.computeAndWait(() -> {
            VirtualFile file2 = this.doCreateFile(name);
            VfsUtil.saveText((VirtualFile)file2, (String)text);
            return file2;
        });
    }

    public void deleteAll() {
        if (!this.mySourceRoot.isInitialized()) {
            return;
        }
        ApplicationManager.getApplication().runWriteAction(() -> {
            VirtualFile[] toDelete;
            VirtualFile[] virtualFileArray;
            VirtualFile sourceRoot = (VirtualFile)this.mySourceRoot.getValue();
            if (sourceRoot == null) {
                virtualFileArray = this.getSourceRoot().getChildren();
            } else {
                VirtualFile[] virtualFileArray2 = new VirtualFile[1];
                virtualFileArray = virtualFileArray2;
                virtualFileArray2[0] = sourceRoot;
            }
            for (VirtualFile file2 : toDelete = virtualFileArray) {
                try {
                    file2.delete((Object)this);
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
        });
    }

    @NotNull
    private VirtualFile getSourceRoot() {
        VirtualFile sourceRoot = (VirtualFile)this.mySourceRoot.getValue();
        return sourceRoot == null ? LightPlatformTestCase.getSourceRoot() : sourceRoot;
    }
}

