/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.testFramework;

import com.intellij.application.options.CodeStyle;
import com.intellij.idea.IdeaLogger;
import com.intellij.mock.MockApplication;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.DataProvider;
import com.intellij.openapi.application.AccessToken;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.WriteAction;
import com.intellij.openapi.application.impl.LaterInvocator;
import com.intellij.openapi.application.impl.NonBlockingReadActionImpl;
import com.intellij.openapi.command.CommandProcessor;
import com.intellij.openapi.command.WriteCommandAction;
import com.intellij.openapi.command.impl.DocumentReferenceManagerImpl;
import com.intellij.openapi.command.impl.StartMarkAction;
import com.intellij.openapi.command.impl.UndoManagerImpl;
import com.intellij.openapi.command.undo.DocumentReferenceManager;
import com.intellij.openapi.command.undo.UndoManager;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.fileTypes.FileTypeManager;
import com.intellij.openapi.fileTypes.impl.FileTypeManagerImpl;
import com.intellij.openapi.module.EmptyModuleType;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.module.ModuleType;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectManager;
import com.intellij.openapi.project.ex.ProjectManagerEx;
import com.intellij.openapi.project.impl.ProjectImpl;
import com.intellij.openapi.project.impl.TooManyProjectLeakedException;
import com.intellij.openapi.projectRoots.ProjectJdkTable;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.roots.ModuleRootModificationUtil;
import com.intellij.openapi.roots.ex.ProjectRootManagerEx;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.EmptyRunnable;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.io.FileUtilRt;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.openapi.vfs.impl.VirtualFilePointerTracker;
import com.intellij.openapi.vfs.impl.jar.JarFileSystemImpl;
import com.intellij.openapi.vfs.impl.local.LocalFileSystemImpl;
import com.intellij.openapi.vfs.newvfs.impl.VirtualDirectoryImpl;
import com.intellij.project.TestProjectManager;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.codeStyle.CodeStyleSettings;
import com.intellij.psi.impl.PsiDocumentManagerBase;
import com.intellij.psi.impl.PsiManagerImpl;
import com.intellij.psi.impl.source.tree.injected.InjectedLanguageManagerImpl;
import com.intellij.refactoring.rename.inplace.InplaceRefactoring;
import com.intellij.testFramework.CodeStyleSettingsTracker;
import com.intellij.testFramework.EditorListenerTracker;
import com.intellij.testFramework.EdtTestUtil;
import com.intellij.testFramework.FixtureRuleKt;
import com.intellij.testFramework.HeavyTestHelper;
import com.intellij.testFramework.LeakHunter;
import com.intellij.testFramework.LightPlatformTestCase;
import com.intellij.testFramework.PlatformTestUtil;
import com.intellij.testFramework.PsiTestUtil;
import com.intellij.testFramework.RunAll;
import com.intellij.testFramework.SdkLeakTracker;
import com.intellij.testFramework.TempFiles;
import com.intellij.testFramework.TemporaryDirectory;
import com.intellij.testFramework.TestApplicationManager;
import com.intellij.testFramework.TestApplicationManagerKt;
import com.intellij.testFramework.TestDataProvider;
import com.intellij.testFramework.TestRunnerUtil;
import com.intellij.testFramework.ThreadTracker;
import com.intellij.testFramework.UsefulTestCase;
import com.intellij.testFramework.VfsTestUtil;
import com.intellij.util.MemoryDumpHelper;
import com.intellij.util.PathUtil;
import com.intellij.util.ThrowableRunnable;
import com.intellij.util.indexing.FileBasedIndex;
import com.intellij.util.indexing.FileBasedIndexImpl;
import com.intellij.util.indexing.IndexableSetContributor;
import com.intellij.util.ui.UIUtil;
import it.unimi.dsi.fastutil.ints.IntOpenHashSet;
import it.unimi.dsi.fastutil.ints.IntSet;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import java.lang.reflect.InvocationTargetException;
import java.net.URL;
import java.nio.charset.Charset;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;
import javax.swing.SwingUtilities;
import junit.framework.TestCase;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class HeavyPlatformTestCase
extends UsefulTestCase
implements DataProvider {
    private static boolean ourReportedLeakedProjects;
    protected Project myProject;
    protected Module myModule;
    protected final Collection<Path> myFilesToDelete = new HashSet<Path>();
    private final TempFiles myTempFiles = new TempFiles(this.myFilesToDelete);
    protected boolean myAssertionsInTestDetected;
    private static TestCase ourTestCase;
    private EditorListenerTracker myEditorListenerTracker;
    private ThreadTracker myThreadTracker;
    private static boolean ourPlatformPrefixInitialized;
    private static Set<VirtualFile> ourEternallyLivingFilesCache;
    private SdkLeakTracker myOldSdks;
    private VirtualFilePointerTracker myVirtualFilePointerTracker;
    @Nullable
    private CodeStyleSettingsTracker myCodeStyleSettingsTracker;
    private AccessToken projectTracker;
    private static final String[] PREFIX_CANDIDATES;

    @NotNull
    public TempFiles getTempDir() {
        return this.myTempFiles;
    }

    @NotNull
    protected final VirtualFile createTestProjectStructure() {
        return PsiTestUtil.createTestProjectStructure(this.myProject, this.myModule, this.myFilesToDelete);
    }

    @NotNull
    protected final VirtualFile createTestProjectStructure(String rootPath) {
        return PsiTestUtil.createTestProjectStructure(this.myProject, this.myModule, rootPath, this.myFilesToDelete);
    }

    public static void synchronizeTempDirVfs(@NotNull VirtualFile tempDir) {
        tempDir.getChildren();
        tempDir.refresh(false, true);
    }

    public static VirtualFile synchronizeTempDirVfs(@NotNull Path tempDir) {
        VirtualFile virtualFile = LocalFileSystem.getInstance().refreshAndFindFileByPath(FileUtil.toSystemIndependentName((String)tempDir.toString()));
        if (virtualFile != null) {
            HeavyPlatformTestCase.synchronizeTempDirVfs(virtualFile);
        }
        return virtualFile;
    }

    protected void initApplication() throws Exception {
        TestApplicationManager testAppManager = TestApplicationManager.getInstance();
        testAppManager.setDataProvider(this);
        this.myOldSdks = new SdkLeakTracker();
    }

    public static void doAutodetectPlatformPrefix() {
        if (Arrays.asList(PREFIX_CANDIDATES).contains(System.getProperty("idea.platform.prefix"))) {
            ourPlatformPrefixInitialized = true;
        }
        if (ourPlatformPrefixInitialized) {
            return;
        }
        if (System.getProperty("idea.platform.prefix") != null) {
            ourPlatformPrefixInitialized = true;
            return;
        }
        for (String candidate : PREFIX_CANDIDATES) {
            String markerPath = candidate == null ? "idea/ApplicationInfo.xml" : "META-INF/" + candidate + "Plugin.xml";
            URL resource = HeavyPlatformTestCase.class.getClassLoader().getResource(markerPath);
            if (resource == null) continue;
            if (candidate == null) break;
            HeavyPlatformTestCase.setPlatformPrefix(candidate);
            break;
        }
    }

    @Override
    protected void setUp() throws Exception {
        super.setUp();
        this.myFilesToDelete.add(Paths.get(FileUtilRt.getTempDirectory(), new String[0]));
        if (ourTestCase != null) {
            String message = "Previous test " + ourTestCase + " hasn't called tearDown(). Probably overridden without super call.";
            ourTestCase = null;
            HeavyPlatformTestCase.fail((String)message);
        }
        IdeaLogger.ourErrorsOccurred = null;
        LOG.debug(((Object)((Object)this)).getClass().getName() + ".setUp()");
        this.initApplication();
        this.projectTracker = ((TestProjectManager)ProjectManager.getInstance()).startTracking();
        if (this.myOldSdks == null) {
            this.myOldSdks = new SdkLeakTracker();
        }
        this.setUpProject();
        this.myEditorListenerTracker = new EditorListenerTracker();
        this.myThreadTracker = new ThreadTracker();
        boolean isTrackCodeStyleChanges = !this.isStressTest() && ApplicationManager.getApplication() != null && !(ApplicationManager.getApplication() instanceof MockApplication);
        this.myCodeStyleSettingsTracker = isTrackCodeStyleChanges ? new CodeStyleSettingsTracker(() -> CodeStyle.getDefaultSettings()) : null;
        ourTestCase = this;
        if (this.myProject != null) {
            CodeStyle.setTemporarySettings((Project)this.myProject, (CodeStyleSettings)CodeStyle.createTestSettings());
            InjectedLanguageManagerImpl.pushInjectors((Project)this.myProject);
            ((PsiDocumentManagerBase)PsiDocumentManager.getInstance((Project)this.myProject)).clearUncommittedDocuments();
        }
        UIUtil.dispatchAllInvocationEvents();
        this.myVirtualFilePointerTracker = new VirtualFilePointerTracker();
    }

    public final Project getProject() {
        return this.myProject;
    }

    @NotNull
    public final PsiManager getPsiManager() {
        return PsiManager.getInstance((Project)this.myProject);
    }

    public Module getModule() {
        return this.myModule;
    }

    protected void setUpProject() throws Exception {
        this.myProject = this.doCreateProject(this.getProjectDirOrFile());
        LocalFileSystem.getInstance().refreshNioFiles(this.myFilesToDelete);
        PlatformTestUtil.openProject(this.myProject);
        WriteAction.run(() -> ProjectRootManagerEx.getInstanceEx((Project)this.myProject).mergeRootsChangesDuring(() -> {
            this.setUpModule();
            this.setUpJdk();
        }));
        LightPlatformTestCase.clearUncommittedDocuments(this.getProject());
        ((FileTypeManagerImpl)FileTypeManager.getInstance()).drainReDetectQueue();
    }

    @NotNull
    protected Project doCreateProject(@NotNull Path projectFile) throws Exception {
        return HeavyPlatformTestCase.createProject(projectFile, this.getProjectFilename());
    }

    @NotNull
    public static Project createProject(@NotNull Path file2) {
        return HeavyPlatformTestCase.createProject(file2, null);
    }

    @NotNull
    private static Project createProject(@NotNull Path file2, @Nullable String projectName) {
        try {
            return Objects.requireNonNull(ProjectManagerEx.getInstanceEx().newProject(file2, FixtureRuleKt.createTestOpenProjectOptions().withProjectName(projectName)));
        }
        catch (TooManyProjectLeakedException e) {
            if (ourReportedLeakedProjects) {
                HeavyPlatformTestCase.fail((String)"Too many projects leaked, again.");
                return null;
            }
            ourReportedLeakedProjects = true;
            HeavyPlatformTestCase.reportLeakedProjects(e);
            return null;
        }
    }

    @NotNull
    public static String publishHeapDump(@NotNull String fileNamePrefix) {
        String fileName = fileNamePrefix + ".hprof.zip";
        File dumpFile = new File(System.getProperty("teamcity.build.tempDir", System.getProperty("java.io.tmpdir")), fileName);
        try {
            FileUtil.delete((File)dumpFile);
            MemoryDumpHelper.captureMemoryDumpZipped((File)dumpFile);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        String dumpPath = dumpFile.getAbsolutePath();
        System.out.println("##teamcity[publishArtifacts '" + dumpPath + "']");
        return dumpPath;
    }

    @Contract(value="_ -> fail")
    public static void reportLeakedProjects(@NotNull TooManyProjectLeakedException e) {
        IntOpenHashSet hashCodes = new IntOpenHashSet();
        for (Project project2 : e.getLeakedProjects()) {
            hashCodes.add(System.identityHashCode(project2));
        }
        String dumpPath = HeavyPlatformTestCase.publishHeapDump("leakedProjects");
        StringBuilder leakers = new StringBuilder();
        leakers.append("Too many projects leaked: \n");
        LeakHunter.processLeaks(LeakHunter.allRoots(), ProjectImpl.class, arg_0 -> HeavyPlatformTestCase.lambda$reportLeakedProjects$3((IntSet)hashCodes, arg_0), (arg_0, arg_1) -> HeavyPlatformTestCase.lambda$reportLeakedProjects$4(leakers, (IntSet)hashCodes, arg_0, arg_1));
        HeavyPlatformTestCase.fail((String)(leakers + "\nPlease see '" + dumpPath + "' for a memory dump"));
    }

    @NotNull
    protected Path getProjectDirOrFile() {
        return this.getProjectDirOrFile(false);
    }

    protected boolean isCreateProjectFileExplicitly() {
        return true;
    }

    @NotNull
    protected final Path getProjectDirOrFile(boolean isDirectoryBasedProject) {
        if (!isDirectoryBasedProject && this.isCreateProjectFileExplicitly()) {
            try {
                Path tempFile = FileUtil.createTempFile((String)this.getName(), (String)".ipr").toPath();
                this.myFilesToDelete.add(tempFile);
                return tempFile;
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
        Path tempFile = TemporaryDirectory.generateTemporaryPath(this.getProjectFilename() + (isDirectoryBasedProject ? "" : ".ipr"));
        this.myFilesToDelete.add(tempFile);
        return tempFile;
    }

    @Nullable
    private String getProjectFilename() {
        String testName = this.getName();
        return testName == null ? null : FileUtil.sanitizeFileName((String)testName, (boolean)false);
    }

    protected void setUpModule() {
        try {
            WriteCommandAction.writeCommandAction((Project)this.getProject()).run(() -> {
                this.myModule = this.createMainModule();
            });
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @NotNull
    protected Module createMainModule() throws IOException {
        return this.createModule(this.myProject.getName());
    }

    @NotNull
    protected Module createModule(@NonNls @NotNull String moduleName) {
        return this.doCreateRealModule(moduleName);
    }

    @NotNull
    protected Module doCreateRealModule(@NotNull String moduleName) {
        return this.doCreateRealModuleIn(moduleName, this.myProject, this.getModuleType());
    }

    @NotNull
    protected Module doCreateRealModuleIn(@NotNull String moduleName, @NotNull Project project2, @NotNull ModuleType<?> moduleType) {
        return this.createModuleAt(moduleName, project2, moduleType, Objects.requireNonNull(project2.getBasePath()));
    }

    @NotNull
    protected Module createModuleAt(@NotNull String moduleName, @NotNull Project project2, @NotNull ModuleType<?> moduleType, @NotNull String path) {
        return HeavyTestHelper.createModuleAt(moduleName, project2, moduleType, path, this.isCreateProjectFileExplicitly(), this.myFilesToDelete);
    }

    @NotNull
    protected ModuleType<?> getModuleType() {
        return EmptyModuleType.getInstance();
    }

    public static void cleanupApplicationCaches(@Nullable Project project2) {
        LocalFileSystemImpl localFileSystem;
        FileBasedIndex fileBasedIndex;
        ProjectManagerEx projectManager;
        Application app = ApplicationManager.getApplication();
        if (app == null) {
            return;
        }
        NonBlockingReadActionImpl.waitForAsyncTaskCompletion();
        UndoManagerImpl globalInstance = (UndoManagerImpl)UndoManager.getGlobalInstance();
        if (globalInstance != null) {
            globalInstance.dropHistoryInTests();
        }
        if (project2 != null && !project2.isDisposed()) {
            ((UndoManagerImpl)UndoManager.getInstance((Project)project2)).dropHistoryInTests();
            ((DocumentReferenceManagerImpl)DocumentReferenceManager.getInstance()).cleanupForNextTest();
            ((PsiManagerImpl)PsiManager.getInstance((Project)project2)).cleanupForNextTest();
        }
        if ((projectManager = ProjectManagerEx.getInstanceExIfCreated()) != null && projectManager.isDefaultProjectInitialized()) {
            Project defaultProject = projectManager.getDefaultProject();
            ((PsiManagerImpl)PsiManager.getInstance((Project)defaultProject)).cleanupForNextTest();
        }
        if ((fileBasedIndex = (FileBasedIndex)app.getServiceIfCreated(FileBasedIndex.class)) != null) {
            ((FileBasedIndexImpl)fileBasedIndex).cleanupForNextTest();
        }
        if (app.getServiceIfCreated(VirtualFileManager.class) != null && (localFileSystem = (LocalFileSystemImpl)LocalFileSystem.getInstance()) != null) {
            localFileSystem.cleanupForNextTest();
        }
    }

    @NotNull
    private static Set<VirtualFile> eternallyLivingFiles() {
        if (ourEternallyLivingFilesCache != null) {
            return ourEternallyLivingFilesCache;
        }
        HashSet<VirtualFile> survivors = new HashSet<VirtualFile>();
        for (IndexableSetContributor contributor : (IndexableSetContributor[])IndexableSetContributor.EP_NAME.getExtensions()) {
            for (VirtualFile file2 : IndexableSetContributor.getRootsToIndex((IndexableSetContributor)contributor)) {
                HeavyPlatformTestCase.registerSurvivor(survivors, file2);
            }
        }
        ourEternallyLivingFilesCache = survivors;
        return survivors;
    }

    public static void addSurvivingFiles(@NotNull Collection<? extends VirtualFile> files) {
        for (VirtualFile virtualFile : files) {
            HeavyPlatformTestCase.registerSurvivor(HeavyPlatformTestCase.eternallyLivingFiles(), virtualFile);
        }
    }

    private static void registerSurvivor(@NotNull Set<? super VirtualFile> survivors, @NotNull VirtualFile file2) {
        HeavyPlatformTestCase.addSubTree(file2, survivors);
        while (file2 != null && survivors.add((VirtualFile)file2)) {
            file2 = file2.getParent();
        }
    }

    private static void addSubTree(@NotNull VirtualFile root, @NotNull Set<? super VirtualFile> to) {
        if (root instanceof VirtualDirectoryImpl) {
            for (VirtualFile child : ((VirtualDirectoryImpl)root).getCachedChildren()) {
                if (!(child instanceof VirtualDirectoryImpl)) continue;
                to.add((VirtualFile)child);
                HeavyPlatformTestCase.addSubTree(child, to);
            }
        }
    }

    @Override
    protected void tearDown() throws Exception {
        Project project2 = this.myProject;
        if (project2 != null && !project2.isDisposed()) {
            TestApplicationManagerKt.waitForProjectLeakingThreads(project2);
        }
        RunAll.runAll(() -> this.disposeRootDisposable(), () -> {
            if (project2 != null) {
                TestApplicationManagerKt.tearDownProjectAndApp(project2);
            }
            this.myProject = null;
        }, () -> {
            AccessToken projectTracker = this.projectTracker;
            if (projectTracker != null) {
                this.projectTracker = null;
                projectTracker.finish();
            }
        }, () -> UIUtil.dispatchAllInvocationEvents(), () -> {
            if (this.myCodeStyleSettingsTracker != null) {
                this.myCodeStyleSettingsTracker.checkForSettingsDamage();
            }
        }, () -> {
            if (project2 != null) {
                InjectedLanguageManagerImpl.checkInjectorsAreDisposed((Project)project2);
            }
        }, () -> {
            StartMarkAction.checkCleared((Project)project2);
            InplaceRefactoring.checkCleared();
        }, () -> {
            JarFileSystemImpl.cleanupForNextTest();
            this.getTempDir().deleteAll();
            LocalFileSystem.getInstance().refreshNioFiles(this.myFilesToDelete);
            LaterInvocator.dispatchPendingFlushes();
        }, () -> {
            if (!this.myAssertionsInTestDetected && IdeaLogger.ourErrorsOccurred != null) {
                throw IdeaLogger.ourErrorsOccurred;
            }
        }, () -> super.tearDown(), () -> {
            if (this.myEditorListenerTracker != null) {
                this.myEditorListenerTracker.checkListenersLeak();
            }
        }, () -> {
            if (this.myThreadTracker != null) {
                this.myThreadTracker.checkLeak();
            }
        }, () -> LightPlatformTestCase.checkEditorsReleased(), () -> this.myOldSdks.checkForJdkTableLeaks(), () -> this.myVirtualFilePointerTracker.assertPointersAreDisposed(), () -> {
            this.myModule = null;
            this.myFilesToDelete.clear();
            this.myEditorListenerTracker = null;
            this.myThreadTracker = null;
            ourTestCase = null;
        });
    }

    protected void resetAllFields() {
        this.resetClassFields(((Object)((Object)this)).getClass());
    }

    @Override
    @NotNull
    protected final <T extends Disposable> T disposeOnTearDown(@NotNull T disposable) {
        Disposer.register((Disposable)this.myProject, disposable);
        return disposable;
    }

    private void resetClassFields(@NotNull Class<?> aClass) {
        try {
            HeavyPlatformTestCase.clearDeclaredFields((Object)this, aClass);
        }
        catch (IllegalAccessException e) {
            LOG.error((Throwable)e);
        }
        if (aClass == HeavyPlatformTestCase.class) {
            return;
        }
        this.resetClassFields(aClass.getSuperclass());
    }

    protected void registerTestProjectJdk(Sdk jdk) {
        ProjectJdkTable jdkTable = ProjectJdkTable.getInstance();
        for (Sdk existingSdk : jdkTable.getAllJdks()) {
            if (existingSdk != jdk) continue;
            return;
        }
        WriteAction.runAndWait(() -> jdkTable.addJdk(jdk, (Disposable)this.myProject));
    }

    protected void setUpJdk() {
        Module[] modules;
        Sdk jdk = this.getTestProjectJdk();
        if (jdk != null) {
            this.registerTestProjectJdk(jdk);
        }
        for (Module module2 : modules = ModuleManager.getInstance((Project)this.myProject).getModules()) {
            ModuleRootModificationUtil.setModuleSdk((Module)module2, (Sdk)jdk);
        }
    }

    @Nullable
    protected Sdk getTestProjectJdk() {
        return null;
    }

    @Override
    public void runBare() throws Throwable {
        if (!this.shouldRunTest()) {
            return;
        }
        TestRunnerUtil.replaceIdeEventQueueSafely();
        try {
            this.runBareImpl();
        }
        finally {
            try {
                EdtTestUtil.runInEdtAndWait((ThrowableRunnable<Throwable>)((ThrowableRunnable)() -> {
                    HeavyPlatformTestCase.cleanupApplicationCaches(this.getProject());
                    this.resetAllFields();
                }));
            }
            catch (Throwable throwable) {}
        }
    }

    private void runBareImpl() throws Throwable {
        ThrowableRunnable runnable = () -> {
            try {
                this.myAssertionsInTestDetected = true;
                this.setUp();
                this.myAssertionsInTestDetected = false;
            }
            catch (Throwable e) {
                try {
                    this.tearDown();
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
                throw e;
            }
            Throwable exception = null;
            try {
                this.myAssertionsInTestDetected = true;
                this.runTest();
                this.myAssertionsInTestDetected = false;
            }
            catch (Throwable e) {
                exception = e;
            }
            finally {
                block17: {
                    try {
                        this.tearDown();
                    }
                    catch (Throwable e) {
                        if (exception != null) break block17;
                        exception = e;
                    }
                }
            }
            if (exception != null) {
                throw exception;
            }
        };
        this.runBareRunnable((ThrowableRunnable<Throwable>)runnable);
        if (IdeaLogger.ourErrorsOccurred != null) {
            throw IdeaLogger.ourErrorsOccurred;
        }
        HeavyPlatformTestCase.waitForAllLaters();
        if (IdeaLogger.ourErrorsOccurred != null) {
            throw IdeaLogger.ourErrorsOccurred;
        }
    }

    private static void waitForAllLaters() throws InterruptedException, InvocationTargetException {
        for (int i = 0; i < 3; ++i) {
            SwingUtilities.invokeAndWait(EmptyRunnable.getInstance());
        }
    }

    protected void runBareRunnable(@NotNull ThrowableRunnable<Throwable> runnable) throws Throwable {
        if (this.runInDispatchThread()) {
            EdtTestUtil.runInEdtAndWait(runnable);
        } else {
            runnable.run();
        }
    }

    protected boolean isRunInWriteAction() {
        return false;
    }

    @Override
    protected void invokeTestRunnable(@NotNull Runnable runnable) throws Exception {
        Ref e = new Ref();
        Runnable runnable1 = () -> {
            try {
                if (ApplicationManager.getApplication().isDispatchThread() && this.isRunInWriteAction()) {
                    ApplicationManager.getApplication().runWriteAction(runnable);
                } else {
                    runnable.run();
                }
            }
            catch (Exception e1) {
                e.set((Object)e1);
            }
        };
        if (this.annotatedWith(WrapInCommand.class)) {
            CommandProcessor.getInstance().executeCommand(this.myProject, runnable1, "", null);
        } else {
            runnable1.run();
        }
        if (!e.isNull()) {
            throw (Exception)e.get();
        }
    }

    public Object getData(@NotNull String dataId) {
        return this.myProject == null || this.myProject.isDisposed() ? null : new TestDataProvider(this.myProject).getData(dataId);
    }

    @NotNull
    public File createTempDir(@NonNls @NotNull String prefix) throws IOException {
        return this.createTempDir(prefix, true);
    }

    @NotNull
    public File createTempDir(@NonNls @NotNull String prefix, boolean refresh) throws IOException {
        File tempDirectory = FileUtilRt.createTempDirectory((String)("idea_test_" + prefix), null, (boolean)false);
        this.myFilesToDelete.add(tempDirectory.toPath());
        if (refresh) {
            HeavyPlatformTestCase.getVirtualFile(tempDirectory);
        }
        return tempDirectory;
    }

    protected static VirtualFile getVirtualFile(@NotNull File file2) {
        return LocalFileSystem.getInstance().refreshAndFindFileByIoFile(file2);
    }

    @NotNull
    protected File createTempDirectory() throws IOException {
        return this.createTempDir("");
    }

    @NotNull
    protected File createTempDirectory(boolean refresh) throws IOException {
        return this.createTempDir("", refresh);
    }

    @NotNull
    protected File createTempFile(@NotNull String name, @Nullable String text) throws IOException {
        File directory = this.createTempDirectory();
        File file2 = new File(directory, name);
        if (!file2.createNewFile()) {
            throw new IOException("Can't create " + file2);
        }
        if (text != null) {
            FileUtil.writeToFile((File)file2, (String)text);
        }
        return file2;
    }

    public static void setContentOnDisk(@NotNull File file2, byte @Nullable [] bom, @NotNull String content, @NotNull Charset charset) throws IOException {
        FileOutputStream stream = new FileOutputStream(file2);
        if (bom != null) {
            stream.write(bom);
        }
        try (OutputStreamWriter writer = new OutputStreamWriter((OutputStream)stream, charset);){
            writer.write(content);
        }
    }

    @NotNull
    public VirtualFile createTempFile(@NonNls @NotNull String ext, byte @Nullable [] bom, @NonNls @NotNull String content, @NotNull Charset charset) throws IOException {
        File temp = FileUtil.createTempFile((String)"copy", (String)("." + ext));
        HeavyPlatformTestCase.setContentOnDisk(temp, bom, content, charset);
        this.myFilesToDelete.add(temp.toPath());
        VirtualFile file2 = HeavyPlatformTestCase.getVirtualFile(temp);
        assert (file2 != null) : temp;
        return file2;
    }

    @Nullable
    protected PsiFile getPsiFile(@NotNull Document document) {
        return PsiDocumentManager.getInstance((Project)this.getProject()).getPsiFile(document);
    }

    private static void setPlatformPrefix(@NotNull String prefix) {
        System.setProperty("idea.platform.prefix", prefix);
        ourPlatformPrefixInitialized = true;
    }

    @NotNull
    protected static VirtualFile createChildData(@NotNull VirtualFile dir, @NonNls @NotNull String name) {
        try {
            return (VirtualFile)WriteAction.computeAndWait(() -> dir.createChildData(null, name));
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @NotNull
    protected static VirtualFile createChildDirectory(@NotNull VirtualFile dir, @NonNls @NotNull String name) {
        try {
            return (VirtualFile)WriteAction.computeAndWait(() -> dir.createChildDirectory(null, name));
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    protected static void rename(@NotNull VirtualFile vFile1, @NotNull String newName) {
        try {
            WriteCommandAction.writeCommandAction(null).run(() -> vFile1.rename((Object)vFile1, newName));
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    protected static void delete(@NotNull VirtualFile vFile1) {
        VfsTestUtil.deleteFile(vFile1);
    }

    public static void move(@NotNull VirtualFile vFile1, @NotNull VirtualFile newFile) {
        try {
            WriteCommandAction.writeCommandAction(null).run(() -> vFile1.move((Object)vFile1, newFile));
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @NotNull
    protected static VirtualFile copy(@NotNull VirtualFile file2, @NotNull VirtualFile newParent, @NotNull String copyName) {
        VirtualFile[] copy = new VirtualFile[1];
        try {
            WriteCommandAction.writeCommandAction(null).run(() -> {
                copy[0] = file2.copy((Object)file2, newParent, copyName);
            });
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return copy[0];
    }

    public static void copyDirContentsTo(@NotNull VirtualFile vTestRoot, @NotNull VirtualFile toDir) {
        try {
            WriteCommandAction.writeCommandAction(null).run(() -> {
                for (VirtualFile file2 : vTestRoot.getChildren()) {
                    VfsUtil.copy((Object)file2, (VirtualFile)file2, (VirtualFile)toDir);
                }
            });
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public static void setFileText(@NotNull VirtualFile file2, @NotNull String text) {
        try {
            WriteAction.runAndWait(() -> VfsUtil.saveText((VirtualFile)file2, (String)text));
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public static void setBinaryContent(@NotNull VirtualFile file2, byte @NotNull [] content) {
        try {
            WriteAction.runAndWait(() -> file2.setBinaryContent(content));
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public static void setBinaryContent(@NotNull VirtualFile file2, byte @NotNull [] content, long newModificationStamp, long newTimeStamp, Object requestor) {
        try {
            WriteAction.runAndWait(() -> file2.setBinaryContent(content, newModificationStamp, newTimeStamp, requestor));
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @NotNull
    protected VirtualFile getOrCreateProjectBaseDir() {
        String basePath = this.myProject.getBasePath();
        VirtualFile baseDir = LocalFileSystem.getInstance().findFileByPath(Objects.requireNonNull(basePath));
        if (baseDir == null) {
            try {
                Files.createDirectories(Paths.get(basePath, new String[0]), new FileAttribute[0]);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
            return Objects.requireNonNull(LocalFileSystem.getInstance().refreshAndFindFileByPath(basePath));
        }
        return baseDir;
    }

    @NotNull
    protected final Path createTempDirectoryWithSuffix(@Nullable String suffix) throws IOException {
        return FileUtilRt.createTempDirectory((String)this.getTestName(true), (String)suffix, (boolean)false).toPath();
    }

    @NotNull
    protected static VirtualFile getOrCreateModuleDir(@NotNull Module module2) throws IOException {
        File moduleDir = new File(PathUtil.getParentPath((String)module2.getModuleFilePath()));
        FileUtil.ensureExists((File)moduleDir);
        return Objects.requireNonNull(LocalFileSystem.getInstance().refreshAndFindFileByIoFile(moduleDir));
    }

    private static /* synthetic */ boolean lambda$reportLeakedProjects$4(StringBuilder leakers, IntSet hashCodes, ProjectImpl leaked, Object backLink) {
        int hashCode = System.identityHashCode(leaked);
        leakers.append("Leaked project found:").append(leaked).append("; hash: ").append(hashCode).append("; place: ").append(TestProjectManager.getCreationPlace((Project)leaked)).append("\n");
        leakers.append(backLink).append("\n");
        leakers.append(";-----\n");
        hashCodes.remove(hashCode);
        return !hashCodes.isEmpty();
    }

    private static /* synthetic */ boolean lambda$reportLeakedProjects$3(IntSet hashCodes, ProjectImpl p) {
        return hashCodes.contains(System.identityHashCode(p));
    }

    static {
        PREFIX_CANDIDATES = new String[]{"AndroidStudio", "Idea"};
    }

    @Retention(value=RetentionPolicy.RUNTIME)
    @Target(value={ElementType.METHOD, ElementType.TYPE})
    public static @interface WrapInCommand {
    }
}

